/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ms() = mapOf(
    Strings.NavigationMenu to "Menu navigasi",
    Strings.ExposedDropdownMenu to "Menu lungsur",
    Strings.CloseDrawer to "Tutup menu navigasi",
    Strings.CloseSheet to "Tutup helaian",
    Strings.DefaultErrorMessage to "Input tidak sah",
    Strings.SliderRangeStart to "Permulaan julat",
    Strings.SliderRangeEnd to "Penghujung julat",
    Strings.Dialog to "Dialog",
    Strings.MenuExpanded to "Dikembangkan",
    Strings.MenuCollapsed to "Dikuncupkan",
    Strings.ToggleDropdownMenu to "Togol menu lungsur",
    Strings.SnackbarDismiss to "Ketepikan",
    Strings.SearchBarSearch to "Carian",
    Strings.SuggestionsAvailable to "Cadangan di bawah",
    Strings.DatePickerTitle to "Pilih tarikh",
    Strings.DatePickerHeadline to "Tarikh dipilih",
    Strings.DatePickerSwitchToYearSelection to "Beralih kepada pemilihan tahun",
    Strings.DatePickerSwitchToDaySelection to "Leret untuk memilih tahun atau ketik untuk bertukar kembali kepada pemilihan hari",
    Strings.DatePickerSwitchToNextMonth to "Tukar kepada bulan seterusnya",
    Strings.DatePickerSwitchToPreviousMonth to "Tukar kepada bulan sebelumnya",
    Strings.DatePickerNavigateToYearDescription to "Navigasi ke tahun %1\$s",
    Strings.DatePickerHeadlineDescription to "Pilihan semasa: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Tiada",
    Strings.DatePickerTodayDescription to "Hari ini",
    Strings.DatePickerYearPickerPaneTitle to "Pemilih tahun kelihatan",
    Strings.DateInputTitle to "Pilih tarikh",
    Strings.DateInputHeadline to "Tarikh yang dimasukkan",
    Strings.DateInputLabel to "Tarikh",
    Strings.DateInputHeadlineDescription to "Tarikh yang dimasukkan: %1\$s",
    Strings.DateInputNoInputDescription to "Tiada",
    Strings.DateInputInvalidNotAllowed to "Tarikh yang tidak dibenarkan: %1\$s",
    Strings.DateInputInvalidForPattern to "Tarikh tidak sepadan dengan corak yang dijangkakan: %1\$s",
    Strings.DateInputInvalidYearRange to "Tarikh di luar julat tahun yang dijangkakan %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Beralih kepada mod input kalendar",
    Strings.DatePickerSwitchToInputMode to "Beralih kepada mod input teks",
    Strings.DatePickerScrollToShowLaterYears to "Tatal untuk menunjukkan tahun kemudian",
    Strings.DatePickerScrollToShowEarlierYears to "Tatal untuk menunjukkan tahun terdahulu",
    Strings.DateRangePickerTitle to "Pilih tarikh",
    Strings.DateRangePickerStartHeadline to "Tarikh mula",
    Strings.DateRangePickerEndHeadline to "Tarikh tamat",
    Strings.DateRangePickerScrollToShowNextMonth to "Tatal untuk menunjukkan bulan seterusnya",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Tatal untuk menunjukkan bulan sebelumnya",
    Strings.DateRangePickerDayInRange to "Dalam liputan",
    Strings.DateRangeInputTitle to "Masukkan tarikh",
    Strings.DateRangeInputInvalidRangeInput to "Input julat tarikh tidak sah",
    Strings.BottomSheetPaneTitle to "Helaian Bawah",
    Strings.BottomSheetDragHandleDescription to "Pemegang seret",
    Strings.BottomSheetPartialExpandDescription to "Kuncupkan helaian bawah",
    Strings.BottomSheetDismissDescription to "Ketepikan helaian bawah",
    Strings.BottomSheetExpandDescription to "Kembangkan helaian bawah",
    Strings.TooltipPaneDescription to "Tip alat",
    Strings.TooltipLongPressLabel to "Tunjukkan tip alat",
    Strings.TimePickerPM to "P/M",
    Strings.TimePickerAM to "PG",
    Strings.TimePickerPeriodToggle to "Pilih PG atau PTG/MLM",
    Strings.TimePickerHourSelection to "Pilih jam",
    Strings.TimePickerMinuteSelection to "Pilih minit",
    Strings.TimePickerHourSuffix to "Pukul %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d jam",
    Strings.TimePickerMinuteSuffix to "%1\$d minit",
    Strings.TimePickerMinute to "Minit",
    Strings.TimePickerHour to "Jam",
    Strings.TimePickerMinuteTextField to "selama # minit",
    Strings.TimePickerHourTextField to "selama # jam",
)
