/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.lv() = mapOf(
    Strings.NavigationMenu to "Navigācijas izvēlne",
    Strings.ExposedDropdownMenu to "Nolaižamā izvēlne",
    Strings.CloseDrawer to "Aizvērt navigācijas izvēlni",
    Strings.CloseSheet to "Aizvērt izklājlapu",
    Strings.DefaultErrorMessage to "Nederīga ievade",
    Strings.SliderRangeStart to "Diapazona sākums",
    Strings.SliderRangeEnd to "Diapazona beigas",
    Strings.Dialog to "Dialoglodziņš",
    Strings.MenuExpanded to "Izvērsta",
    Strings.MenuCollapsed to "Sakļauta",
    Strings.ToggleDropdownMenu to "Pārslēgt nolaižamo izvēlni",
    Strings.SnackbarDismiss to "Nerādīt",
    Strings.SearchBarSearch to "Meklēšana",
    Strings.SuggestionsAvailable to "Tālāk ir sniegti ieteikumi",
    Strings.DatePickerTitle to "Atlasīt datumu",
    Strings.DatePickerHeadline to "Atlasītais datums",
    Strings.DatePickerSwitchToYearSelection to "Pāriet uz gada atlasi",
    Strings.DatePickerSwitchToDaySelection to "Velciet, lai atlasītu gadu, vai pieskarieties, lai pārietu atpakaļ pie dienas atlases",
    Strings.DatePickerSwitchToNextMonth to "Mainīt uz nākamo mēnesi",
    Strings.DatePickerSwitchToPreviousMonth to "Mainīt uz iepriekšējo mēnesi",
    Strings.DatePickerNavigateToYearDescription to "Pāriet uz %1\$s. gadu",
    Strings.DatePickerHeadlineDescription to "Pašreizējā atlase: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Nav",
    Strings.DatePickerTodayDescription to "Šodien",
    Strings.DatePickerYearPickerPaneTitle to "Redzams gada atlasītājs",
    Strings.DateInputTitle to "Atlasīt datumu",
    Strings.DateInputHeadline to "Ievadītais datums",
    Strings.DateInputLabel to "Datums",
    Strings.DateInputHeadlineDescription to "Ievadītais datums: %1\$s",
    Strings.DateInputNoInputDescription to "Nav",
    Strings.DateInputInvalidNotAllowed to "Datums nav atļauts: %1\$s",
    Strings.DateInputInvalidForPattern to "Datums neatbilst paredzētajam formātam: %1\$s",
    Strings.DateInputInvalidYearRange to "Datums nav paredzētajā gadu diapazonā (%1\$s.–%2\$s. g.)",
    Strings.DatePickerSwitchToCalendarMode to "Pārslēgties uz kalendāra ievades režīmu",
    Strings.DatePickerSwitchToInputMode to "Pārslēgties uz teksta ievades režīmu",
    Strings.DatePickerScrollToShowLaterYears to "Lai rādītu nākamos gadus, ritiniet",
    Strings.DatePickerScrollToShowEarlierYears to "Lai rādītu iepriekšējos gadus, ritiniet",
    Strings.DateRangePickerTitle to "Atlasiet datumus",
    Strings.DateRangePickerStartHeadline to "Sākuma datums",
    Strings.DateRangePickerEndHeadline to "Beigu datums",
    Strings.DateRangePickerScrollToShowNextMonth to "Lai rādītu nākamo mēnesi, ritiniet",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Lai rādītu iepriekšējo mēnesi, ritiniet",
    Strings.DateRangePickerDayInRange to "Atlasītajā diapazonā",
    Strings.DateRangeInputTitle to "Ievadiet datumus",
    Strings.DateRangeInputInvalidRangeInput to "Ievadīts nederīgs datumu diapazons.",
    Strings.BottomSheetPaneTitle to "Ekrāna apakšdaļas lapa",
    Strings.BottomSheetDragHandleDescription to "Vilkšanas turis",
    Strings.BottomSheetPartialExpandDescription to "Sakļaut ekrāna apakšdaļas lapu",
    Strings.BottomSheetDismissDescription to "Noraidīt ekrāna apakšdaļas lapu",
    Strings.BottomSheetExpandDescription to "Izvērst ekrāna apakšdaļas lapu",
    Strings.TooltipPaneDescription to "Rīka padoms",
    Strings.TooltipLongPressLabel to "Rādīt rīka padomu",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Atlasīt “AM” (priekšpusdienā) vai “PM” (pēcpusdienā)",
    Strings.TimePickerHourSelection to "Atlasīt stundu",
    Strings.TimePickerMinuteSelection to "Atlasīt minūtes",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d",
    Strings.TimePickerMinuteSuffix to "Minūtes: %1\$d",
    Strings.TimePickerMinute to "Minūtes",
    Strings.TimePickerHour to "Stunda",
    Strings.TimePickerMinuteTextField to "minūtēm",
    Strings.TimePickerHourTextField to "stundām",
)
