/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.material3.ExperimentalMaterial3Api;
import androidx.compose.material3.SheetDefaultsKt;
import androidx.compose.material3.SheetState;
import androidx.compose.material3.SheetValue;
import androidx.compose.material3.internal.AnchoredDraggableKt;
import androidx.compose.material3.internal.AnchoredDraggableState;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\"\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\u00072\b\b\u0002\u0010%\u001a\u00020\u001cH\u0080@\u00a2\u0006\u0004\b&\u0010'J\u000e\u0010(\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010)J\u000e\u0010+\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010)J\u0006\u0010,\u001a\u00020\u001cJ\u0018\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001cH\u0080@\u00a2\u0006\u0004\b.\u0010/J\u000e\u00100\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010)J\u0018\u00101\u001a\u00020$2\u0006\u0010!\u001a\u00020\u0007H\u0080@\u00a2\u0006\u0004\b2\u00103R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\n\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017R\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014\u00a8\u00065"}, d2={"Landroidx/compose/material3/SheetState;", "", "skipPartiallyExpanded", "", "density", "Landroidx/compose/ui/unit/Density;", "initialValue", "Landroidx/compose/material3/SheetValue;", "confirmValueChange", "Lkotlin/Function1;", "skipHiddenState", "(ZLandroidx/compose/ui/unit/Density;Landroidx/compose/material3/SheetValue;Lkotlin/jvm/functions/Function1;Z)V", "anchoredDraggableState", "Landroidx/compose/material3/internal/AnchoredDraggableState;", "getAnchoredDraggableState$material3", "()Landroidx/compose/material3/internal/AnchoredDraggableState;", "setAnchoredDraggableState$material3", "(Landroidx/compose/material3/internal/AnchoredDraggableState;)V", "currentValue", "getCurrentValue", "()Landroidx/compose/material3/SheetValue;", "hasExpandedState", "getHasExpandedState", "()Z", "hasPartiallyExpandedState", "getHasPartiallyExpandedState", "isVisible", "offset", "", "getOffset$material3", "()Ljava/lang/Float;", "getSkipHiddenState$material3", "getSkipPartiallyExpanded$material3", "targetValue", "getTargetValue", "animateTo", "", "velocity", "animateTo$material3", "(Landroidx/compose/material3/SheetValue;FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "expand", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hide", "partialExpand", "requireOffset", "settle", "settle$material3", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "show", "snapTo", "snapTo$material3", "(Landroidx/compose/material3/SheetValue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "material3"})
@Stable
@ExperimentalMaterial3Api
public final class SheetState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean skipPartiallyExpanded;
    private final boolean skipHiddenState;
    @NotNull
    private AnchoredDraggableState<SheetValue> anchoredDraggableState;
    public static final int $stable;

    public SheetState(boolean skipPartiallyExpanded, @NotNull Density density, @NotNull SheetValue initialValue, @NotNull Function1<? super SheetValue, Boolean> confirmValueChange, boolean skipHiddenState) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)initialValue), (String)"initialValue");
        Intrinsics.checkNotNullParameter(confirmValueChange, (String)"confirmValueChange");
        this.skipPartiallyExpanded = skipPartiallyExpanded;
        this.skipHiddenState = skipHiddenState;
        if (this.skipPartiallyExpanded && !(initialValue != SheetValue.PartiallyExpanded)) {
            boolean $i$a$-require-SheetState$42 = false;
            String $i$a$-require-SheetState$42 = "The initial value must not be set to PartiallyExpanded if skipPartiallyExpanded is set to true.";
            throw new IllegalArgumentException($i$a$-require-SheetState$42.toString());
        }
        if (this.skipHiddenState && !(initialValue != SheetValue.Hidden)) {
            boolean bl = false;
            String string = "The initial value must not be set to Hidden if skipHiddenState is set to true.";
            throw new IllegalArgumentException(string.toString());
        }
        AnimationSpec animationSpec = SheetDefaultsKt.access$getBottomSheetAnimationSpec$p();
        this.anchoredDraggableState = new AnchoredDraggableState<SheetValue>(initialValue, (Function1<? super Float, Float>)((Function1)new Function1<Float, Float>(density){
            final /* synthetic */ Density $density;
            {
                this.$density = $density;
                super(1);
            }

            @NotNull
            public final Float invoke(float it) {
                Density $this$invoke_u24lambda_u240 = this.$density;
                boolean bl = false;
                int $this$dp$iv = 56;
                boolean $i$f$getDp = false;
                return Float.valueOf($this$invoke_u24lambda_u240.toPx-0680j_4(Dp.constructor-impl((float)$this$dp$iv)));
            }
        }), (Function0<Float>)((Function0)new Function0<Float>(density){
            final /* synthetic */ Density $density;
            {
                this.$density = $density;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                Density $this$invoke_u24lambda_u240 = this.$density;
                boolean bl = false;
                int $this$dp$iv = 125;
                boolean $i$f$getDp = false;
                return Float.valueOf($this$invoke_u24lambda_u240.toPx-0680j_4(Dp.constructor-impl((float)$this$dp$iv)));
            }
        }), (AnimationSpec<Float>)animationSpec, confirmValueChange);
    }

    public /* synthetic */ SheetState(boolean bl, Density density, SheetValue sheetValue, Function1 function1, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            sheetValue = SheetValue.Hidden;
        }
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(bl, density, sheetValue, (Function1<? super SheetValue, Boolean>)function1, bl2);
    }

    public final boolean getSkipPartiallyExpanded$material3() {
        return this.skipPartiallyExpanded;
    }

    public final boolean getSkipHiddenState$material3() {
        return this.skipHiddenState;
    }

    @NotNull
    public final SheetValue getCurrentValue() {
        return this.anchoredDraggableState.getCurrentValue();
    }

    @NotNull
    public final SheetValue getTargetValue() {
        return this.anchoredDraggableState.getTargetValue();
    }

    public final boolean isVisible() {
        return this.anchoredDraggableState.getCurrentValue() != SheetValue.Hidden;
    }

    public final float requireOffset() {
        return this.anchoredDraggableState.requireOffset();
    }

    public final boolean getHasExpandedState() {
        return this.anchoredDraggableState.getAnchors().hasAnchorFor(SheetValue.Expanded);
    }

    public final boolean getHasPartiallyExpandedState() {
        return this.anchoredDraggableState.getAnchors().hasAnchorFor(SheetValue.PartiallyExpanded);
    }

    @Nullable
    public final Object expand(@NotNull Continuation<? super Unit> $completion) {
        Object object = AnchoredDraggableKt.animateTo$default(this.anchoredDraggableState, (Object)SheetValue.Expanded, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object partialExpand(@NotNull Continuation<? super Unit> $completion) {
        if (!(!this.skipPartiallyExpanded)) {
            boolean bl = false;
            String string = "Attempted to animate to partial expanded when skipPartiallyExpanded was enabled. Set skipPartiallyExpanded to false to use this function.";
            throw new IllegalStateException(string.toString());
        }
        Object object = SheetState.animateTo$material3$default(this, SheetValue.PartiallyExpanded, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object show(@NotNull Continuation<? super Unit> $completion) {
        SheetValue targetValue2 = this.getHasPartiallyExpandedState() ? SheetValue.PartiallyExpanded : SheetValue.Expanded;
        Object object = SheetState.animateTo$material3$default(this, targetValue2, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object hide(@NotNull Continuation<? super Unit> $completion) {
        if (!(!this.skipHiddenState)) {
            boolean bl = false;
            String string = "Attempted to animate to hidden when skipHiddenState was enabled. Set skipHiddenState to false to use this function.";
            throw new IllegalStateException(string.toString());
        }
        Object object = SheetState.animateTo$material3$default(this, SheetValue.Hidden, 0.0f, $completion, 2, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object animateTo$material3(@NotNull SheetValue targetValue2, float velocity, @NotNull Continuation<? super Unit> $completion) {
        Object object = AnchoredDraggableKt.animateTo(this.anchoredDraggableState, targetValue2, velocity, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object animateTo$material3$default(SheetState sheetState, SheetValue sheetValue, float f, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            f = sheetState.anchoredDraggableState.getLastVelocity();
        }
        return sheetState.animateTo$material3(sheetValue, f, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object snapTo$material3(@NotNull SheetValue targetValue2, @NotNull Continuation<? super Unit> $completion) {
        Object object = AnchoredDraggableKt.snapTo(this.anchoredDraggableState, targetValue2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object settle$material3(float velocity, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.anchoredDraggableState.settle(velocity, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final AnchoredDraggableState<SheetValue> getAnchoredDraggableState$material3() {
        return this.anchoredDraggableState;
    }

    public final void setAnchoredDraggableState$material3(@NotNull AnchoredDraggableState<SheetValue> anchoredDraggableState2) {
        Intrinsics.checkNotNullParameter(anchoredDraggableState2, (String)"<set-?>");
        this.anchoredDraggableState = anchoredDraggableState2;
    }

    @Nullable
    public final Float getOffset$material3() {
        return Float.valueOf(this.anchoredDraggableState.getOffset());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Landroidx/compose/material3/SheetState$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/material3/SheetState;", "Landroidx/compose/material3/SheetValue;", "skipPartiallyExpanded", "", "confirmValueChange", "Lkotlin/Function1;", "density", "Landroidx/compose/ui/unit/Density;", "skipHiddenState", "material3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<SheetState, SheetValue> Saver(boolean skipPartiallyExpanded, @NotNull Function1<? super SheetValue, Boolean> confirmValueChange, @NotNull Density density, boolean skipHiddenState) {
            Intrinsics.checkNotNullParameter(confirmValueChange, (String)"confirmValueChange");
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            return SaverKt.Saver((Function2)Saver.1.INSTANCE, (Function1)((Function1)new Function1<SheetValue, SheetState>(skipPartiallyExpanded, density, confirmValueChange, skipHiddenState){
                final /* synthetic */ boolean $skipPartiallyExpanded;
                final /* synthetic */ Density $density;
                final /* synthetic */ Function1<SheetValue, Boolean> $confirmValueChange;
                final /* synthetic */ boolean $skipHiddenState;
                {
                    this.$skipPartiallyExpanded = $skipPartiallyExpanded;
                    this.$density = $density;
                    this.$confirmValueChange = $confirmValueChange;
                    this.$skipHiddenState = $skipHiddenState;
                    super(1);
                }

                @Nullable
                public final SheetState invoke(@NotNull SheetValue savedValue) {
                    Intrinsics.checkNotNullParameter((Object)((Object)savedValue), (String)"savedValue");
                    return new SheetState(this.$skipPartiallyExpanded, this.$density, savedValue, this.$confirmValueChange, this.$skipHiddenState);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

