/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.zu() = mapOf(
    Strings.NavigationMenu to "Imenyu yokuzulazula",
    Strings.ExposedDropdownMenu to "Imenyu eya phansi",
    Strings.CloseDrawer to "Vala imenyu yokuzulazula",
    Strings.CloseSheet to "Vala ishidi",
    Strings.DefaultErrorMessage to "Okufakwayo okungalungile",
    Strings.SliderRangeStart to "Ukuqala kobubanzi",
    Strings.SliderRangeEnd to "Umkhawulo wobubanzi",
    Strings.Dialog to "Ibhokisi",
    Strings.MenuExpanded to "Kunwetshiwe",
    Strings.MenuCollapsed to "Kugoqiwe",
    Strings.ToggleDropdownMenu to "Guqula imenyu yokwehlayo",
    Strings.SnackbarDismiss to "Chitha",
    Strings.SearchBarSearch to "Sesha",
    Strings.SuggestionsAvailable to "Iziphakamiso ngezansi",
    Strings.DatePickerTitle to "Khetha usuku",
    Strings.DatePickerHeadline to "Usuku olukhethiwe",
    Strings.DatePickerSwitchToYearSelection to "Shintshela ekukhetheni unyaka",
    Strings.DatePickerSwitchToDaySelection to "Swayipha ukuze ukhethe unyaka, noma thepha ukuze ubuyele ekukhetheni usuku",
    Strings.DatePickerSwitchToNextMonth to "Shintshela kunyanga elandelayo",
    Strings.DatePickerSwitchToPreviousMonth to "Shintshela kunyanga edlule",
    Strings.DatePickerNavigateToYearDescription to "Funa onyakeni %1\$s",
    Strings.DatePickerHeadlineDescription to "Ukukhetha kwamanje: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Lutho",
    Strings.DatePickerTodayDescription to "Namuhla",
    Strings.DatePickerYearPickerPaneTitle to "Isikhethi sonyaka siyabonakala",
    Strings.DateInputTitle to "Khetha usuku",
    Strings.DateInputHeadline to "Usuku olufakiwe",
    Strings.DateInputLabel to "Usuku",
    Strings.DateInputHeadlineDescription to "Usuku olufakiwe: %1\$s",
    Strings.DateInputNoInputDescription to "Lutho",
    Strings.DateInputInvalidNotAllowed to "Usuku aluvunyelwe: %1\$s",
    Strings.DateInputInvalidForPattern to "Usuku alufani nephethini elindelekile: %1\$s",
    Strings.DateInputInvalidYearRange to "Usuku lungaphandle kwebanga lonyaka elilindelekile %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Shintshela kwimodi yokufaka yekhalenda",
    Strings.DatePickerSwitchToInputMode to "Shintshela kwimodi yokufaka yombhalo",
    Strings.DatePickerScrollToShowLaterYears to "Skrola ukuze ubonise iminyaka yakamuva",
    Strings.DatePickerScrollToShowEarlierYears to "Skrola ukuze ubonise iminyaka yangaphambilini",
    Strings.DateRangePickerTitle to "Khetha izinsuku",
    Strings.DateRangePickerStartHeadline to "Usuku lokuqala",
    Strings.DateRangePickerEndHeadline to "Usuku lokuphela",
    Strings.DateRangePickerScrollToShowNextMonth to "Skrola ukuze ubonise inyanga elandelayo",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Skrola ukuze ubonise inyanga edlule",
    Strings.DateRangePickerDayInRange to "Ebangeni",
    Strings.DateRangeInputTitle to "Faka izinsuku",
    Strings.DateRangeInputInvalidRangeInput to "Okokufaka kwebanga losuku okungavumelekile",
    Strings.BottomSheetPaneTitle to "Ishidi Eliphansi",
    Strings.BottomSheetDragHandleDescription to "Hudula isibambi",
    Strings.BottomSheetPartialExpandDescription to "Goqa ishidi eliphansi",
    Strings.BottomSheetDismissDescription to "Chitha ishidi eliphansi",
    Strings.BottomSheetExpandDescription to "Nweba ishidi eliphansi",
    Strings.TooltipPaneDescription to "Ithulithiphu",
    Strings.TooltipLongPressLabel to "Bonisa ithulithiphu",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Khetha u-AM noma u-PM",
    Strings.TimePickerHourSelection to "Khetha ihora",
    Strings.TimePickerMinuteSelection to "Khetha imizuzu",
    Strings.TimePickerHourSuffix to "Ngu-%1\$d o\'clock",
    Strings.TimePicker24HourSuffix to "Amahora angu-%1\$d",
    Strings.TimePickerMinuteSuffix to "Imizuzu engu-%1\$d",
    Strings.TimePickerMinute to "Umzuzu",
    Strings.TimePickerHour to "Ihora",
    Strings.TimePickerMinuteTextField to "ngemizuzu",
    Strings.TimePickerHourTextField to "ngehora",
)
