/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.bn() = mapOf(
    Strings.NavigationMenu to "নেভিগেশন মেনু",
    Strings.ExposedDropdownMenu to "ড্রপডাউন মেনু",
    Strings.CloseDrawer to "নেভিগেশন মেনু বন্ধ করুন",
    Strings.CloseSheet to "শিট বন্ধ করুন",
    Strings.DefaultErrorMessage to "ভুল ইনপুট",
    Strings.SliderRangeStart to "রেঞ্জ শুরু",
    Strings.SliderRangeEnd to "রেঞ্জ শেষ",
    Strings.Dialog to "ডায়ালগ",
    Strings.MenuExpanded to "বড় করা হয়েছে",
    Strings.MenuCollapsed to "আড়াল করা হয়েছে",
    Strings.ToggleDropdownMenu to "ড্রপডাউন মেনু টগল করুন",
    Strings.SnackbarDismiss to "বাতিল করুন",
    Strings.SearchBarSearch to "সার্চ করুন",
    Strings.SuggestionsAvailable to "নিচে দেওয়া সাজেশন",
    Strings.DatePickerTitle to "তারিখ বেছে নিন",
    Strings.DatePickerHeadline to "বেছে নেওয়া তারিখ",
    Strings.DatePickerSwitchToYearSelection to "কোনও একটি বছর বেছে নিতে বদল করুন",
    Strings.DatePickerSwitchToDaySelection to "একটি বছর বেছে নিতে সোয়াইপ করুন অথবা দিন বেছে নেওয়ার বিকল্পে ফিরে যেতে ট্যাপ করুন",
    Strings.DatePickerSwitchToNextMonth to "আগামী মাসে পরিবর্তন করুন",
    Strings.DatePickerSwitchToPreviousMonth to "আগের মাসে পরিবর্তন করুন",
    Strings.DatePickerNavigateToYearDescription to "নেভিগেট করে %1\$s বছরে যান",
    Strings.DatePickerHeadlineDescription to "বর্তমানে বেছে নেওয়া হয়েছে: %1\$s",
    Strings.DatePickerNoSelectionDescription to "কোনওটিই নয়",
    Strings.DatePickerTodayDescription to "আজ",
    Strings.DatePickerYearPickerPaneTitle to "বছর বেছে নেওয়ার তালিকা দেখা যাচ্ছে",
    Strings.DateInputTitle to "তারিখ বেছে নিন",
    Strings.DateInputHeadline to "উল্লেখ করা তারিখ",
    Strings.DateInputLabel to "তারিখ",
    Strings.DateInputHeadlineDescription to "উল্লেখ করা তারিখ: %1\$s",
    Strings.DateInputNoInputDescription to "কোনওটিই নয়",
    Strings.DateInputInvalidNotAllowed to "এই তারিখ লেখা যাবে না: %1\$s",
    Strings.DateInputInvalidForPattern to "প্রত্যাশিত প্যাটার্নের সাথে তারিখ মিলছে না: %1\$s",
    Strings.DateInputInvalidYearRange to "প্রত্যাশিত বছরের রেঞ্জের বাইরের তারিখ %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "ক্যালেন্ডার ইনপুট মোডে বদল করুন",
    Strings.DatePickerSwitchToInputMode to "টেক্সট ইনপুট মোডে বদল করুন",
    Strings.DatePickerScrollToShowLaterYears to "পরের বছরগুলি দেখতে স্ক্রল করুন",
    Strings.DatePickerScrollToShowEarlierYears to "আগের বছরগুলি দেখতে স্ক্রল করুন",
    Strings.DateRangePickerTitle to "তারিখ বেছে নিন",
    Strings.DateRangePickerStartHeadline to "শুরুর তারিখ",
    Strings.DateRangePickerEndHeadline to "শেষ হওয়ার তারিখ",
    Strings.DateRangePickerScrollToShowNextMonth to "পরের মাস দেখতে স্ক্রল করুন",
    Strings.DateRangePickerScrollToShowPreviousMonth to "আগের মাস দেখতে স্ক্রল করুন",
    Strings.DateRangePickerDayInRange to "সীমার মধ্যে",
    Strings.DateRangeInputTitle to "তারিখ লিখুন",
    Strings.DateRangeInputInvalidRangeInput to "তারিখের ব্যাপ্তি সম্পর্কিত ইনপুট ভুল দেওয়া আছে",
    Strings.BottomSheetPaneTitle to "স্ক্রিনের নিচে অ্যাটাচ করা শিট",
    Strings.BottomSheetDragHandleDescription to "টেনে আনার হ্যান্ডেল",
    Strings.BottomSheetPartialExpandDescription to "স্ক্রিনের নিচে অ্যাটাচ করা শিট আড়াল করুন",
    Strings.BottomSheetDismissDescription to "স্ক্রিনের নিচে অ্যাটাচ করা শিট বাতিল করুন",
    Strings.BottomSheetExpandDescription to "স্ক্রিনের নিচে অ্যাটাচ করা শিট বড় করুন",
    Strings.TooltipPaneDescription to "টুলটিপ",
    Strings.TooltipLongPressLabel to "টুলটিপ দেখান",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM বা PM বেছে নিন",
    Strings.TimePickerHourSelection to "ঘণ্টা বেছে নিন",
    Strings.TimePickerMinuteSelection to "মিনিট বেছে নিন",
    Strings.TimePickerHourSuffix to "%1\$dটা",
    Strings.TimePicker24HourSuffix to "%1\$d ঘণ্টা",
    Strings.TimePickerMinuteSuffix to "%1\$d মিনিট",
    Strings.TimePickerMinute to "মিনিট",
    Strings.TimePickerHour to "ঘণ্টা",
    Strings.TimePickerMinuteTextField to "এত মিনিটের জন্য",
    Strings.TimePickerHourTextField to "এত ঘণ্টার জন্য",
)
