/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.`in`() = mapOf(
    Strings.NavigationMenu to "Menu navigasi",
    Strings.ExposedDropdownMenu to "Menu dropdown",
    Strings.CloseDrawer to "Tutup menu navigasi",
    Strings.CloseSheet to "Tutup sheet",
    Strings.DefaultErrorMessage to "Input tidak valid",
    Strings.SliderRangeStart to "Rentang awal",
    Strings.SliderRangeEnd to "Rentang akhir",
    Strings.Dialog to "Dialog",
    Strings.MenuExpanded to "Diperluas",
    Strings.MenuCollapsed to "Diciutkan",
    Strings.ToggleDropdownMenu to "Aktifkan/nonaktifkan menu dropdown",
    Strings.SnackbarDismiss to "Tutup",
    Strings.SearchBarSearch to "Telusuri",
    Strings.SuggestionsAvailable to "Saran di bawah",
    Strings.DatePickerTitle to "Pilih tanggal",
    Strings.DatePickerHeadline to "Tanggal yang dipilih",
    Strings.DatePickerSwitchToYearSelection to "Beralih ke memilih tahun",
    Strings.DatePickerSwitchToDaySelection to "Geser untuk memilih tahun, atau ketuk untuk beralih kembali ke pemilihan tanggal",
    Strings.DatePickerSwitchToNextMonth to "Ubah ke bulan berikutnya",
    Strings.DatePickerSwitchToPreviousMonth to "Ubah ke bulan sebelumnya",
    Strings.DatePickerNavigateToYearDescription to "Pilih tahun %1\$s",
    Strings.DatePickerHeadlineDescription to "Pilihan saat ini: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Tidak ada",
    Strings.DatePickerTodayDescription to "Hari ini",
    Strings.DatePickerYearPickerPaneTitle to "Pemilih tahun terlihat",
    Strings.DateInputTitle to "Pilih tanggal",
    Strings.DateInputHeadline to "Tanggal yang dimasukkan",
    Strings.DateInputLabel to "Tanggal",
    Strings.DateInputHeadlineDescription to "Tanggal yang dimasukkan: %1\$s",
    Strings.DateInputNoInputDescription to "Tidak ada",
    Strings.DateInputInvalidNotAllowed to "Tanggal tidak diizinkan: %1\$s",
    Strings.DateInputInvalidForPattern to "Tanggal tidak cocok dengan pola yang diharapkan: %1\$s",
    Strings.DateInputInvalidYearRange to "Tanggal di luar rentang tahun yang diharapkan %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Beralih ke mode input kalender",
    Strings.DatePickerSwitchToInputMode to "Beralih ke mode input teks",
    Strings.DatePickerScrollToShowLaterYears to "Scroll untuk menampilkan tahun berikutnya",
    Strings.DatePickerScrollToShowEarlierYears to "Scroll untuk menampilkan tahun sebelumnya",
    Strings.DateRangePickerTitle to "Pilih tanggal",
    Strings.DateRangePickerStartHeadline to "Tanggal mulai",
    Strings.DateRangePickerEndHeadline to "Tanggal akhir",
    Strings.DateRangePickerScrollToShowNextMonth to "Scroll untuk menampilkan bulan berikutnya",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Scroll untuk menampilkan bulan sebelumnya",
    Strings.DateRangePickerDayInRange to "Dalam rentang",
    Strings.DateRangeInputTitle to "Masukkan tanggal",
    Strings.DateRangeInputInvalidRangeInput to "Input rentang tanggal tidak valid",
    Strings.BottomSheetPaneTitle to "Sheet Bawah",
    Strings.BottomSheetDragHandleDescription to "Handel geser",
    Strings.BottomSheetPartialExpandDescription to "Menciutkan sheet bawah",
    Strings.BottomSheetDismissDescription to "Menutup sheet bawah",
    Strings.BottomSheetExpandDescription to "Meluaskan sheet bawah",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Tampilkan tooltip",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Pilih AM atau PM",
    Strings.TimePickerHourSelection to "Pilih jam",
    Strings.TimePickerMinuteSelection to "Pilih menit",
    Strings.TimePickerHourSuffix to "Pukul %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d jam",
    Strings.TimePickerMinuteSuffix to "%1\$d menit",
    Strings.TimePickerMinute to "Menit",
    Strings.TimePickerHour to "Jam",
    Strings.TimePickerMinuteTextField to "untuk menit",
    Strings.TimePickerHourTextField to "untuk jam",
)
