/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.sw() = mapOf(
    Strings.NavigationMenu to "Menyu ya kusogeza",
    Strings.ExposedDropdownMenu to "Menyu kunjuzi",
    Strings.CloseDrawer to "Funga menyu ya kusogeza",
    Strings.CloseSheet to "Funga laha",
    Strings.DefaultErrorMessage to "Ulichoweka si sahihi",
    Strings.SliderRangeStart to "Mwanzo wa masafa",
    Strings.SliderRangeEnd to "Mwisho wa masafa",
    Strings.Dialog to "Kidirisha",
    Strings.MenuExpanded to "Imepanuliwa",
    Strings.MenuCollapsed to "Imekunjwa",
    Strings.ToggleDropdownMenu to "Badilisha hali ya menyu kunjuzi",
    Strings.SnackbarDismiss to "Ondoa",
    Strings.SearchBarSearch to "Tafuta",
    Strings.SuggestionsAvailable to "Mapendekezo yaliyo hapa chini",
    Strings.DatePickerTitle to "Chagua tarehe",
    Strings.DatePickerHeadline to "Tarehe uliyochagua",
    Strings.DatePickerSwitchToYearSelection to "Teua mwaka",
    Strings.DatePickerSwitchToDaySelection to "Telezesha kidole ili uchague mwaka au gusa ili urejee kuchagua siku",
    Strings.DatePickerSwitchToNextMonth to "Nenda kwenye mwezi unaofuata",
    Strings.DatePickerSwitchToPreviousMonth to "Rudi kwenye mwezi uliotangulia",
    Strings.DatePickerNavigateToYearDescription to "Nenda kwenye mwaka %1\$s",
    Strings.DatePickerHeadlineDescription to "Ambayo umechagua: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Hamna",
    Strings.DatePickerTodayDescription to "Leo",
    Strings.DatePickerYearPickerPaneTitle to "Kiteua mwaka kimeonyeshwa",
    Strings.DateInputTitle to "Chagua tarehe",
    Strings.DateInputHeadline to "Tarehe uliyoweka",
    Strings.DateInputLabel to "Tarehe",
    Strings.DateInputHeadlineDescription to "Tarehe uliyoweka: %1\$s",
    Strings.DateInputNoInputDescription to "Hamna",
    Strings.DateInputInvalidNotAllowed to "Tarehe si sahihi: %1\$s",
    Strings.DateInputInvalidForPattern to "Tarehe hailingani na mpangilio unaotumika: %1\$s",
    Strings.DateInputInvalidYearRange to "Tarehe uliyoweka haiambatani na kipindi husika %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Badilisha uteue tarehe kwenye kalenda",
    Strings.DatePickerSwitchToInputMode to "Badilisha uandike tarehe mwenyewe",
    Strings.DatePickerScrollToShowLaterYears to "Sogeza ili uone miaka ya baadaye",
    Strings.DatePickerScrollToShowEarlierYears to "Sogeza ili uone miaka iliyopita",
    Strings.DateRangePickerTitle to "Chagua tarehe",
    Strings.DateRangePickerStartHeadline to "Tarehe ya kuanza",
    Strings.DateRangePickerEndHeadline to "Tarehe ya mwisho",
    Strings.DateRangePickerScrollToShowNextMonth to "Sogeza ili kuonyesha mwezi ujao",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Sogeza ili kuonyesha mwezi uliopita",
    Strings.DateRangePickerDayInRange to "Ipo katika kipindi",
    Strings.DateRangeInputTitle to "Weka tarehe",
    Strings.DateRangeInputInvalidRangeInput to "Kipindi ulichoweka si sahihi",
    Strings.BottomSheetPaneTitle to "Safu ya Chini",
    Strings.BottomSheetDragHandleDescription to "Aikoni ya buruta",
    Strings.BottomSheetPartialExpandDescription to "Kunja safu ya chini",
    Strings.BottomSheetDismissDescription to "Ondoa safu ya chini",
    Strings.BottomSheetExpandDescription to "Panua safu ya chini",
    Strings.TooltipPaneDescription to "Kidirisha cha vidokezo",
    Strings.TooltipLongPressLabel to "Onyesha kidirisha cha vidokezo",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Chagua AM au PM",
    Strings.TimePickerHourSelection to "Chagua saa",
    Strings.TimePickerMinuteSelection to "Chagua dakika",
    Strings.TimePickerHourSuffix to "Saa %1\$d",
    Strings.TimePicker24HourSuffix to "Saa %1\$d",
    Strings.TimePickerMinuteSuffix to "Dakika %1\$d",
    Strings.TimePickerMinute to "Dakika",
    Strings.TimePickerHour to "Saa",
    Strings.TimePickerMinuteTextField to "cha dakika",
    Strings.TimePickerHourTextField to "cha moja",
)
