/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.`is`() = mapOf(
    Strings.NavigationMenu to "Yfirlitsvalmynd",
    Strings.ExposedDropdownMenu to "Fellivalmynd",
    Strings.CloseDrawer to "Loka yfirlitsvalmynd",
    Strings.CloseSheet to "Loka blaði",
    Strings.DefaultErrorMessage to "Ógildur innsláttur",
    Strings.SliderRangeStart to "Upphaf sviðs",
    Strings.SliderRangeEnd to "Lok sviðs",
    Strings.Dialog to "Gluggi",
    Strings.MenuExpanded to "Stækkað",
    Strings.MenuCollapsed to "Minnkað",
    Strings.ToggleDropdownMenu to "Velja eða afvelja fellivalmynd",
    Strings.SnackbarDismiss to "Hunsa",
    Strings.SnackbarPaneTitle to "Viðvörun",
    Strings.SearchBarSearch to "Leit",
    Strings.SuggestionsAvailable to "Tillögur hér fyrir neðan",
    Strings.DatePickerTitle to "Velja dagsetningu",
    Strings.DatePickerHeadline to "Valin dagsetning",
    Strings.DatePickerSwitchToYearSelection to "Skipta yfir í val á ári",
    Strings.DatePickerSwitchToDaySelection to "Strjúktu til að velja ár eða ýttu til að skipta aftur yfir í að velja dag",
    Strings.DatePickerSwitchToNextMonth to "Breyta í næsta mánuð",
    Strings.DatePickerSwitchToPreviousMonth to "Breyta í fyrri mánuð",
    Strings.DatePickerNavigateToYearDescription to "Fletta til ársins %1\$s",
    Strings.DatePickerHeadlineDescription to "Núverandi val: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ekkert",
    Strings.DatePickerTodayDescription to "Í dag",
    Strings.DatePickerYearPickerPaneTitle to "Ársval birt",
    Strings.DateInputTitle to "Velja dagsetningu",
    Strings.DateInputHeadline to "Skráð dagsetning",
    Strings.DateInputLabel to "Dagsetning",
    Strings.DateInputHeadlineDescription to "Skráð dagsetning: %1\$s",
    Strings.DateInputNoInputDescription to "Ekkert",
    Strings.DateInputInvalidNotAllowed to "Dagsetning er ekki leyfileg: %1\$s",
    Strings.DateInputInvalidForPattern to "Dagsetning passar ekki við áætlað mynstur: %1\$s",
    Strings.DateInputInvalidYearRange to "Dagsetning er utan áætlaðra ára: %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Skipta yfir í innfærsluaðferð fyrir dagatal",
    Strings.DatePickerSwitchToInputMode to "Skipta yfir í textainnslátt",
    Strings.DatePickerScrollToShowLaterYears to "Flettu til að sjá síðari ár",
    Strings.DatePickerScrollToShowEarlierYears to "Flettu til að sjá fyrri ár",
    Strings.DateRangePickerTitle to "Velja dagsetningar",
    Strings.DateRangePickerStartHeadline to "Upphafsdagur",
    Strings.DateRangePickerEndHeadline to "Lokadagur",
    Strings.DateRangePickerScrollToShowNextMonth to "Flettu til að sjá næsta mánuð",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Flettu til að sjá fyrri mánuð",
    Strings.DateRangePickerDayInRange to "Innan tímabils",
    Strings.DateRangeInputTitle to "Slá inn dagsetningar",
    Strings.DateRangeInputInvalidRangeInput to "Ógilt tímabil fært inn",
    Strings.BottomSheetPaneTitle to "Blað neðst",
    Strings.BottomSheetDragHandleDescription to "Dragkló",
    Strings.BottomSheetPartialExpandDescription to "Minnka blað neðst",
    Strings.BottomSheetDismissDescription to "Hunsa blað neðst",
    Strings.BottomSheetExpandDescription to "Stækka blað neðst",
    Strings.FloatingToolbarCollapse to "Minnka tækjastiku",
    Strings.FloatingToolbarExpand to "Stækka tækjastiku",
    Strings.TooltipPaneDescription to "Ábending",
    Strings.TooltipLongPressLabel to "Sýna ábendingu",
    Strings.TimePickerPM to "eh",
    Strings.TimePickerAM to "fh",
    Strings.TimePickerPeriodToggle to "Velja f.h. eða e.h.",
    Strings.TimePickerHourSelection to "Velja klst.",
    Strings.TimePickerMinuteSelection to "Velja mínútur",
    Strings.TimePickerHourSuffix to "Kl. %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d klst.",
    Strings.TimePickerMinuteSuffix to "%1\$d mínútur",
    Strings.TimePickerMinute to "Mínúta",
    Strings.TimePickerHour to "Klukkustund",
    Strings.TimePickerMinuteTextField to "fyrir mínútur",
    Strings.TimePickerHourTextField to "fyrir klukkustund",
    Strings.TimePickerToggleKeyboard to "Skiptu yfir í textainnslátt til að slá inn tíma",
    Strings.TimePickerToggleTouch to "Skiptu yfir í klukkustillingu til að slá inn tíma",
    Strings.TimePickerDialogTitle to "Veldu tíma",
    Strings.TimeInputDialogTitle to "Sláðu inn tíma",
    Strings.CloseRail to "Loka stiku",
    Strings.WideNavigationRailPaneTitle to "Yfirlitsstika",
)
