/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.si() = mapOf(
    Strings.NavigationMenu to "සංචාලන මෙනුව",
    Strings.ExposedDropdownMenu to "පතන මෙනුව",
    Strings.CloseDrawer to "සංචාලන මෙනුව වසන්න",
    Strings.CloseSheet to "පත්‍රය වසන්න",
    Strings.DefaultErrorMessage to "වලංගු නොවන ආදානයකි",
    Strings.SliderRangeStart to "පරාස ආරම්භය",
    Strings.SliderRangeEnd to "පරාස අන්තය",
    Strings.Dialog to "සංවාදය",
    Strings.MenuExpanded to "දිග හරින ලදි",
    Strings.MenuCollapsed to "හකුළන ලදි",
    Strings.ToggleDropdownMenu to "පතන මෙනුව ටොගල් කරන්න",
    Strings.SnackbarDismiss to "අස් කරන්න",
    Strings.SnackbarPaneTitle to "ඇඟවීම",
    Strings.SearchBarSearch to "සෙවීම",
    Strings.SuggestionsAvailable to "පහත යෝජනා",
    Strings.DatePickerTitle to "දිනය තෝරන්න",
    Strings.DatePickerHeadline to "තෝරා ගත් දිනය",
    Strings.DatePickerSwitchToYearSelection to "වසරක් තේරීමට මාරු වන්න",
    Strings.DatePickerSwitchToDaySelection to "වසරක් තේරීමට ස්වයිප් කරන්න, නැතහොත් දිනක් තේරීමට ආපසු මාරු වීමට තට්ටු කරන්න",
    Strings.DatePickerSwitchToNextMonth to "ඊළඟ මාසයට වෙනස් කරන්න",
    Strings.DatePickerSwitchToPreviousMonth to "පෙර මාසයට වෙනස් කරන්න",
    Strings.DatePickerNavigateToYearDescription to "%1\$s වසර වෙත සංචලන කරන්න",
    Strings.DatePickerHeadlineDescription to "වත්මන් තේරීම: %1\$s",
    Strings.DatePickerNoSelectionDescription to "කිසිවක් නැත",
    Strings.DatePickerTodayDescription to "අද",
    Strings.DatePickerYearPickerPaneTitle to "වසර තෝරකය දෘශ්‍යමානයි",
    Strings.DateInputTitle to "දිනය තෝරන්න",
    Strings.DateInputHeadline to "ඇතුළත් කළ දිනය",
    Strings.DateInputLabel to "දිනය",
    Strings.DateInputHeadlineDescription to "ඇතුළත් කළ දිනය: %1\$s",
    Strings.DateInputNoInputDescription to "කිසිවක් නැත",
    Strings.DateInputInvalidNotAllowed to "දිනයට ඉඩ දෙනු නොලැබේ: %1\$s",
    Strings.DateInputInvalidForPattern to "දිනය අපේක්ෂිත රටාවට නොගැළපෙයි: %1\$s",
    Strings.DateInputInvalidYearRange to "දිනය %1\$s - %2\$s අපේක්ෂිත වසර පරාසයෙන් පිටත වේ",
    Strings.DatePickerSwitchToCalendarMode to "දිනදර්ශන ආදාන ප්‍රකාරයට මාරු වන්න",
    Strings.DatePickerSwitchToInputMode to "පාඨ ආදාන ප්‍රකාරයට මාරු වන්න",
    Strings.DatePickerScrollToShowLaterYears to "පසු වසර පෙන්වීමට අනුචලන කරන්න",
    Strings.DatePickerScrollToShowEarlierYears to "පෙර වසර පෙන්වීමට අනුචලන කරන්න",
    Strings.DateRangePickerTitle to "දින තෝරන්න",
    Strings.DateRangePickerStartHeadline to "ආරම්භක දිනය",
    Strings.DateRangePickerEndHeadline to "අවසාන දිනය",
    Strings.DateRangePickerScrollToShowNextMonth to "ඊළඟ මාසය පෙන්වීමට අනුචලන කරන්න",
    Strings.DateRangePickerScrollToShowPreviousMonth to "පෙර මාසය පෙන්වීමට අනුචලන කරන්න",
    Strings.DateRangePickerDayInRange to "පරාසය තුළ",
    Strings.DateRangeInputTitle to "දින ඇතුළු කරන්න",
    Strings.DateRangeInputInvalidRangeInput to "අවලංගු දින පරාස ආදානය",
    Strings.BottomSheetPaneTitle to "පහළම පත්‍රය",
    Strings.BottomSheetDragHandleDescription to "ඇදීම් හැඬලය",
    Strings.BottomSheetPartialExpandDescription to "පහළම පත්‍රය හකුළන්න",
    Strings.BottomSheetDismissDescription to "පහළම පත්‍රය අස් කරන්න",
    Strings.BottomSheetExpandDescription to "පහළම පත්‍රය දිග හරින්න",
    Strings.FloatingToolbarCollapse to "මෙවලම් තීරුව හකුළන්න",
    Strings.FloatingToolbarExpand to "මෙවලම් තීරුව පුළුල් කරන්න",
    Strings.TooltipPaneDescription to "මෙවලම් ඉඟිය",
    Strings.TooltipLongPressLabel to "මෙවලම් ඉඟිය පෙන්වන්න",
    Strings.TimePickerPM to "ප.ව.",
    Strings.TimePickerAM to "පෙ.ව.",
    Strings.TimePickerPeriodToggle to "පෙ.ව. හෝ ප.ව. තෝරන්න",
    Strings.TimePickerHourSelection to "පැය තෝරන්න",
    Strings.TimePickerMinuteSelection to "මිනිත්තු ගණන තෝරන්න",
    Strings.TimePickerHourSuffix to "%1\$dට",
    Strings.TimePicker24HourSuffix to "පැය %1\$d",
    Strings.TimePickerMinuteSuffix to "මිනිත්තු %1\$d",
    Strings.TimePickerMinute to "විනාඩි",
    Strings.TimePickerHour to "පැය",
    Strings.TimePickerMinuteTextField to "මිනිත්තු ගණනක් සඳහා",
    Strings.TimePickerHourTextField to "පැයක් සඳහා",
    Strings.TimePickerToggleKeyboard to "වේලා ආදානය සඳහා පෙළ ආදාන ප්‍රකාරය වෙත මාරු වෙන්න",
    Strings.TimePickerToggleTouch to "වේලා ආදානය සඳහා ඔරලෝසු ප්‍රකාරය වෙත මාරු වෙන්න",
    Strings.TimePickerDialogTitle to "වේලාව තෝරන්න",
    Strings.TimeInputDialogTitle to "වේලාව ඇතුළු කරන්න",
    Strings.CloseRail to "පීල්ල වසන්න",
    Strings.WideNavigationRailPaneTitle to "සංචාලන පීල්ල",
)
