/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.sq() = mapOf(
    Strings.NavigationMenu to "Menyja e navigimit",
    Strings.ExposedDropdownMenu to "Menyja me lëshim poshtë",
    Strings.CloseDrawer to "Mbyll menynë e navigimit",
    Strings.CloseSheet to "Mbyll fletën",
    Strings.DefaultErrorMessage to "Hyrje e pavlefshme",
    Strings.SliderRangeStart to "Fillimi i diapazonit",
    Strings.SliderRangeEnd to "Fundi i diapazonit",
    Strings.Dialog to "Dialogu",
    Strings.MenuExpanded to "Zgjeruar",
    Strings.MenuCollapsed to "Palosur",
    Strings.ToggleDropdownMenu to "Zgjero/palos menynë me lëshim poshtë",
    Strings.SnackbarDismiss to "Hiq",
    Strings.SnackbarPaneTitle to "Sinjalizim",
    Strings.SearchBarSearch to "Kërkimi",
    Strings.SuggestionsAvailable to "Sugjerimet më poshtë",
    Strings.DatePickerTitle to "Zgjidh datën",
    Strings.DatePickerHeadline to "Data e zgjedhur",
    Strings.DatePickerSwitchToYearSelection to "Kalo te zgjedhja e një viti",
    Strings.DatePickerSwitchToDaySelection to "Rrëshqit shpejt për të zgjedhur një vit ose trokit për të kaluar sërish te zgjedhja e ditës",
    Strings.DatePickerSwitchToNextMonth to "Ndrysho te muaji i ardhshëm",
    Strings.DatePickerSwitchToPreviousMonth to "Ndrysho te muaji i kaluar",
    Strings.DatePickerNavigateToYearDescription to "Navigo në vitin %1\$s",
    Strings.DatePickerHeadlineDescription to "Zgjedhja aktuale: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Asnjë",
    Strings.DatePickerTodayDescription to "Sot",
    Strings.DatePickerYearPickerPaneTitle to "Zgjedhësi i vitit i dukshëm",
    Strings.DateInputTitle to "Zgjidh datën",
    Strings.DateInputHeadline to "Data e futur",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Data e futur: %1\$s",
    Strings.DateInputNoInputDescription to "Asnjë",
    Strings.DateInputInvalidNotAllowed to "Data nuk lejohet: %1\$s",
    Strings.DateInputInvalidForPattern to "Data nuk përputhet me motivin e pritur: %1\$s",
    Strings.DateInputInvalidYearRange to "Data jashtë diapazonit të pritur të vitit %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Kalo te modaliteti i \"Hyrjes së kalendarit\"",
    Strings.DatePickerSwitchToInputMode to "Kalo te modaliteti i \"Hyrjes së tekstit\"",
    Strings.DatePickerScrollToShowLaterYears to "Lëviz për të shfaqur vitet e ardhshme",
    Strings.DatePickerScrollToShowEarlierYears to "Lëviz për të shfaqur vitet e mëparshme",
    Strings.DateRangePickerTitle to "Zgjidh datat",
    Strings.DateRangePickerStartHeadline to "Data e fillimit",
    Strings.DateRangePickerEndHeadline to "Data e mbarimit",
    Strings.DateRangePickerScrollToShowNextMonth to "Lëviz për të shfaqur muajin e ardhshëm",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Lëviz për të shfaqur muajin e mëparshëm",
    Strings.DateRangePickerDayInRange to "Brenda intervalit",
    Strings.DateRangeInputTitle to "Fut datat",
    Strings.DateRangeInputInvalidRangeInput to "Hyrje e pavlefshme e diapazonit të datave",
    Strings.BottomSheetPaneTitle to "Fleta e poshtme",
    Strings.BottomSheetDragHandleDescription to "Doreza e zvarritjes",
    Strings.BottomSheetPartialExpandDescription to "Palos fletën e poshtme",
    Strings.BottomSheetDismissDescription to "Hiq fletën e poshtme",
    Strings.BottomSheetExpandDescription to "Zgjero fletën e poshtme",
    Strings.FloatingToolbarCollapse to "Palos shiritin e veglave",
    Strings.FloatingToolbarExpand to "Zgjero shiritin e veglave",
    Strings.TooltipPaneDescription to "Këshilla për veglën",
    Strings.TooltipLongPressLabel to "Shfaq këshillat për veglën",
    Strings.TimePickerPM to "pasdite",
    Strings.TimePickerAM to "paradite",
    Strings.TimePickerPeriodToggle to "Zgjidh paradite ose pasdite",
    Strings.TimePickerHourSelection to "Zgjidh orën",
    Strings.TimePickerMinuteSelection to "Zgjidh minutat",
    Strings.TimePickerHourSuffix to "ora %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d orë",
    Strings.TimePickerMinuteSuffix to "%1\$d minuta",
    Strings.TimePickerMinute to "Minuta",
    Strings.TimePickerHour to "Ora",
    Strings.TimePickerMinuteTextField to "për minuta",
    Strings.TimePickerHourTextField to "për orë",
    Strings.TimePickerToggleKeyboard to "Kalo te modaliteti i hyrjes së tekstit për hyrjen e kohës",
    Strings.TimePickerToggleTouch to "Kalo te modaliteti i orës për hyrjen e kohës",
    Strings.TimePickerDialogTitle to "Zgjidh orën",
    Strings.TimeInputDialogTitle to "Fut orën",
    Strings.CloseRail to "Mbyll shinën",
    Strings.WideNavigationRailPaneTitle to "Shina e shfletimit",
)
