/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.tl() = mapOf(
    Strings.NavigationMenu to "Menu ng navigation",
    Strings.ExposedDropdownMenu to "Drop-down na menu",
    Strings.CloseDrawer to "Isara ang menu ng navigation",
    Strings.CloseSheet to "Isara ang sheet",
    Strings.DefaultErrorMessage to "Invalid na input",
    Strings.SliderRangeStart to "Simula ng range",
    Strings.SliderRangeEnd to "Katapusan ng range",
    Strings.Dialog to "Dialog",
    Strings.MenuExpanded to "Naka-expand",
    Strings.MenuCollapsed to "Naka-collapse",
    Strings.ToggleDropdownMenu to "I-toggle ang dropdown menu",
    Strings.SnackbarDismiss to "I-dismiss",
    Strings.SnackbarPaneTitle to "Alerto",
    Strings.SearchBarSearch to "Maghanap",
    Strings.SuggestionsAvailable to "Mga suhestyon sa ibaba",
    Strings.DatePickerTitle to "Pumili ng petsa",
    Strings.DatePickerHeadline to "Piniling petsa",
    Strings.DatePickerSwitchToYearSelection to "Lumipat sa pagpili ng taon",
    Strings.DatePickerSwitchToDaySelection to "Mag-swipe para pumili ng taon, o mag-tap para bumalik sa pagpili ng araw",
    Strings.DatePickerSwitchToNextMonth to "Lumipat sa susunod na buwan",
    Strings.DatePickerSwitchToPreviousMonth to "Lumipat sa nakaraang buwan",
    Strings.DatePickerNavigateToYearDescription to "Mag-navigate papunta sa taong %1\$s",
    Strings.DatePickerHeadlineDescription to "Kasalukuyang napili: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Wala",
    Strings.DatePickerTodayDescription to "Ngayon",
    Strings.DatePickerYearPickerPaneTitle to "Nakikita ang picker ng taon",
    Strings.DateInputTitle to "Pumili ng petsa",
    Strings.DateInputHeadline to "Inilagay na petsa",
    Strings.DateInputLabel to "Petsa",
    Strings.DateInputHeadlineDescription to "Inilagay na petsa: %1\$s",
    Strings.DateInputNoInputDescription to "Wala",
    Strings.DateInputInvalidNotAllowed to "Hindi pinapayagan ang petsa: %1\$s",
    Strings.DateInputInvalidForPattern to "Hindi tumutugma ang petsa sa inaasahang pattern: %1\$s",
    Strings.DateInputInvalidYearRange to "Wala ang petsa sa inaasahang hanay ng taon na %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Lumipat sa pamamaraan ng pag-input ng kalendaryo",
    Strings.DatePickerSwitchToInputMode to "Lumipat sa pamamaraan ng pag-input ng text",
    Strings.DatePickerScrollToShowLaterYears to "Mag-scroll para makita ang mga mas kamakailang taon",
    Strings.DatePickerScrollToShowEarlierYears to "Mag-scroll para ipakita ang mga mas naunang taon",
    Strings.DateRangePickerTitle to "Pumili ng mga petsa",
    Strings.DateRangePickerStartHeadline to "Petsa ng pagsisimula",
    Strings.DateRangePickerEndHeadline to "Petsa ng pagtatapos",
    Strings.DateRangePickerScrollToShowNextMonth to "Mag-scroll para ipakita ang susunod na buwan",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Mag-scroll para ipakita ang nakaraang buwan",
    Strings.DateRangePickerDayInRange to "May signal",
    Strings.DateRangeInputTitle to "Maglagay ng mga petsa",
    Strings.DateRangeInputInvalidRangeInput to "Invalid ang input na hanay ng petsa",
    Strings.BottomSheetPaneTitle to "Bottom Sheet",
    Strings.BottomSheetDragHandleDescription to "Handle sa pag-drag",
    Strings.BottomSheetPartialExpandDescription to "I-collapse ang bottom sheet",
    Strings.BottomSheetDismissDescription to "I-dismiss ang bottom sheet",
    Strings.BottomSheetExpandDescription to "Palawakin ang bottom sheet",
    Strings.FloatingToolbarCollapse to "I-collapse ang toolbar",
    Strings.FloatingToolbarExpand to "I-expand ang toolbar",
    Strings.TooltipPaneDescription to "Tooltip",
    Strings.TooltipLongPressLabel to "Ipakita ang tooltip",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Piliin ang AM o PM",
    Strings.TimePickerHourSelection to "Pumili ng oras",
    Strings.TimePickerMinuteSelection to "Pumili ng mga minuto",
    Strings.TimePickerHourSuffix to "%1\$d o\'clock",
    Strings.TimePicker24HourSuffix to "%1\$d oras",
    Strings.TimePickerMinuteSuffix to "%1\$d (na) minuto",
    Strings.TimePickerMinute to "Minuto",
    Strings.TimePickerHour to "Oras",
    Strings.TimePickerMinuteTextField to "nang ilang minuto",
    Strings.TimePickerHourTextField to "nang ilang oras",
    Strings.TimePickerToggleKeyboard to "Lumipat sa pamamaraan ng pag-input ng text para sa pag-input ng oras",
    Strings.TimePickerToggleTouch to "Lumipat sa clock mode para sa pag-input ng oras.",
    Strings.TimePickerDialogTitle to "Pumili ng Oras",
    Strings.TimeInputDialogTitle to "Maglagay ng Oras",
    Strings.CloseRail to "Isara ang rail",
    Strings.WideNavigationRailPaneTitle to "Navigation rail",
)
