/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.collection.FloatList;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.ShiftPointRange;
import androidx.compose.material3.carousel.StrategyKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u0000 -2\u00020\u0001:\u0001-BM\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\u000eJ'\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\b\b\u0002\u0010'\u001a\u00020!H\u0000\u00a2\u0006\u0002\b(J\u0013\u0010)\u001a\u00020!2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\"R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Landroidx/compose/material3/carousel/Strategy;", "", "defaultKeylines", "Landroidx/compose/material3/carousel/KeylineList;", "startKeylineSteps", "", "endKeylineSteps", "availableSpace", "", "itemSpacing", "beforeContentPadding", "afterContentPadding", "<init>", "(Landroidx/compose/material3/carousel/KeylineList;Ljava/util/List;Ljava/util/List;FFFF)V", "(Landroidx/compose/material3/carousel/KeylineList;FFFF)V", "getDefaultKeylines", "()Landroidx/compose/material3/carousel/KeylineList;", "getStartKeylineSteps", "()Ljava/util/List;", "getEndKeylineSteps", "getAvailableSpace", "()F", "getItemSpacing", "getBeforeContentPadding", "getAfterContentPadding", "startShiftDistance", "endShiftDistance", "startShiftPoints", "Landroidx/collection/FloatList;", "endShiftPoints", "itemMainAxisSize", "getItemMainAxisSize", "isValid", "", "()Z", "lastStartAndEndKeylineListSteps", "getKeylineListForScrollOffset", "scrollOffset", "maxScrollOffset", "roundToNearestStep", "getKeylineListForScrollOffset$material3", "equals", "other", "hashCode", "", "Companion", "material3"})
@StabilityInferred(parameters=0)
public final class Strategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeylineList defaultKeylines;
    @NotNull
    private final List<KeylineList> startKeylineSteps;
    @NotNull
    private final List<KeylineList> endKeylineSteps;
    private final float availableSpace;
    private final float itemSpacing;
    private final float beforeContentPadding;
    private final float afterContentPadding;
    private final float startShiftDistance;
    private final float endShiftDistance;
    @NotNull
    private final FloatList startShiftPoints;
    @NotNull
    private final FloatList endShiftPoints;
    private final boolean isValid;
    @Nullable
    private List<KeylineList> lastStartAndEndKeylineListSteps;
    public static final int $stable = 8;
    @NotNull
    private static final Strategy Empty = new Strategy(KeylineListKt.emptyKeylineList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), 0.0f, 0.0f, 0.0f, 0.0f);

    private Strategy(KeylineList defaultKeylines, List<KeylineList> startKeylineSteps, List<KeylineList> endKeylineSteps, float availableSpace, float itemSpacing, float beforeContentPadding, float afterContentPadding) {
        this.defaultKeylines = defaultKeylines;
        this.startKeylineSteps = startKeylineSteps;
        this.endKeylineSteps = endKeylineSteps;
        this.availableSpace = availableSpace;
        this.itemSpacing = itemSpacing;
        this.beforeContentPadding = beforeContentPadding;
        this.afterContentPadding = afterContentPadding;
        this.startShiftDistance = StrategyKt.access$getStartShiftDistance(this.startKeylineSteps, this.beforeContentPadding);
        this.endShiftDistance = StrategyKt.access$getEndShiftDistance(this.endKeylineSteps, this.afterContentPadding);
        this.startShiftPoints = StrategyKt.access$getStepInterpolationPoints(this.startShiftDistance, this.startKeylineSteps, true);
        this.endShiftPoints = StrategyKt.access$getStepInterpolationPoints(this.endShiftDistance, this.endKeylineSteps, false);
        this.isValid = !((Collection)this.defaultKeylines).isEmpty() && !(this.availableSpace == 0.0f) && !(this.getItemMainAxisSize() == 0.0f);
    }

    @NotNull
    public final KeylineList getDefaultKeylines() {
        return this.defaultKeylines;
    }

    @NotNull
    public final List<KeylineList> getStartKeylineSteps() {
        return this.startKeylineSteps;
    }

    @NotNull
    public final List<KeylineList> getEndKeylineSteps() {
        return this.endKeylineSteps;
    }

    public final float getAvailableSpace() {
        return this.availableSpace;
    }

    public final float getItemSpacing() {
        return this.itemSpacing;
    }

    public final float getBeforeContentPadding() {
        return this.beforeContentPadding;
    }

    public final float getAfterContentPadding() {
        return this.afterContentPadding;
    }

    public Strategy(@NotNull KeylineList defaultKeylines, float availableSpace, float itemSpacing, float beforeContentPadding, float afterContentPadding) {
        Intrinsics.checkNotNullParameter((Object)defaultKeylines, (String)"defaultKeylines");
        this(defaultKeylines, StrategyKt.access$getStartKeylineSteps(defaultKeylines, availableSpace, itemSpacing, beforeContentPadding), StrategyKt.access$getEndKeylineSteps(defaultKeylines, availableSpace, itemSpacing, afterContentPadding), availableSpace, itemSpacing, beforeContentPadding, afterContentPadding);
    }

    public final float getItemMainAxisSize() {
        return this.defaultKeylines.getFirstFocal().getSize();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public final KeylineList getKeylineListForScrollOffset$material3(float scrollOffset, float maxScrollOffset, boolean roundToNearestStep) {
        float positiveScrollOffset = Math.max(0.0f, scrollOffset);
        float startShiftOffset = this.startShiftDistance;
        float endShiftOffset = Math.max(0.0f, maxScrollOffset - this.endShiftDistance);
        boolean bl = startShiftOffset <= positiveScrollOffset ? positiveScrollOffset <= endShiftOffset : false;
        if (bl) {
            return this.defaultKeylines;
        }
        float interpolation = StrategyKt.access$lerp(1.0f, 0.0f, 0.0f, startShiftOffset, positiveScrollOffset);
        FloatList shiftPoints = this.startShiftPoints;
        List<KeylineList> steps = this.startKeylineSteps;
        if (positiveScrollOffset > endShiftOffset) {
            interpolation = StrategyKt.access$lerp(0.0f, 1.0f, endShiftOffset, maxScrollOffset, positiveScrollOffset);
            shiftPoints = this.endShiftPoints;
            steps = this.endKeylineSteps;
            if (endShiftOffset < 0.01f && this.startKeylineSteps.size() == 2 && this.endKeylineSteps.size() == 2) {
                if (this.lastStartAndEndKeylineListSteps == null) {
                    Object[] objectArray = new KeylineList[]{CollectionsKt.last(this.startKeylineSteps), CollectionsKt.last(this.endKeylineSteps)};
                    this.lastStartAndEndKeylineListSteps = CollectionsKt.listOf((Object[])objectArray);
                }
                List<KeylineList> list = this.lastStartAndEndKeylineListSteps;
                Intrinsics.checkNotNull(list);
                steps = list;
            }
        }
        ShiftPointRange shiftPointRange = StrategyKt.access$getShiftPointRange(steps.size(), shiftPoints, interpolation);
        if (roundToNearestStep) {
            int roundedStepIndex = MathKt.roundToInt((float)shiftPointRange.getSteppedInterpolation()) == 0 ? shiftPointRange.getFromStepIndex() : shiftPointRange.getToStepIndex();
            return steps.get(roundedStepIndex);
        }
        return KeylineListKt.lerp(steps.get(shiftPointRange.getFromStepIndex()), steps.get(shiftPointRange.getToStepIndex()), shiftPointRange.getSteppedInterpolation());
    }

    public static /* synthetic */ KeylineList getKeylineListForScrollOffset$material3$default(Strategy strategy, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return strategy.getKeylineListForScrollOffset$material3(f, f2, bl);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        if (!this.isValid && !((Strategy)other).isValid) {
            return true;
        }
        if (this.isValid != ((Strategy)other).isValid) {
            return false;
        }
        if (!(this.availableSpace == ((Strategy)other).availableSpace)) {
            return false;
        }
        if (!(this.itemSpacing == ((Strategy)other).itemSpacing)) {
            return false;
        }
        if (!(this.beforeContentPadding == ((Strategy)other).beforeContentPadding)) {
            return false;
        }
        if (!(this.afterContentPadding == ((Strategy)other).afterContentPadding)) {
            return false;
        }
        if (!(this.getItemMainAxisSize() == ((Strategy)other).getItemMainAxisSize())) {
            return false;
        }
        if (!(this.startShiftDistance == ((Strategy)other).startShiftDistance)) {
            return false;
        }
        if (!(this.endShiftDistance == ((Strategy)other).endShiftDistance)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startShiftPoints, (Object)((Strategy)other).startShiftPoints)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endShiftPoints, (Object)((Strategy)other).endShiftPoints)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.defaultKeylines, (Object)((Strategy)other).defaultKeylines);
    }

    public int hashCode() {
        if (!this.isValid) {
            return Boolean.hashCode(this.isValid);
        }
        int result = Boolean.hashCode(this.isValid);
        result = 31 * result + Float.hashCode(this.availableSpace);
        result = 31 * result + Float.hashCode(this.itemSpacing);
        result = 31 * result + Float.hashCode(this.beforeContentPadding);
        result = 31 * result + Float.hashCode(this.afterContentPadding);
        result = 31 * result + Float.hashCode(this.getItemMainAxisSize());
        result = 31 * result + Float.hashCode(this.startShiftDistance);
        result = 31 * result + Float.hashCode(this.endShiftDistance);
        result = 31 * result + this.startShiftPoints.hashCode();
        result = 31 * result + this.endShiftPoints.hashCode();
        result = 31 * result + this.defaultKeylines.hashCode();
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/material3/carousel/Strategy$Companion;", "", "<init>", "()V", "Empty", "Landroidx/compose/material3/carousel/Strategy;", "getEmpty", "()Landroidx/compose/material3/carousel/Strategy;", "material3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Strategy getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

