/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ja() = mapOf(
    Strings.NavigationMenu to "ナビゲーションメニュー",
    Strings.ExposedDropdownMenu to "プルダウン メニュー",
    Strings.CloseDrawer to "ナビゲーションメニューを閉じる",
    Strings.CloseSheet to "シートを閉じる",
    Strings.DefaultErrorMessage to "入力値が無効です",
    Strings.SliderRangeStart to "範囲の先頭",
    Strings.SliderRangeEnd to "範囲の末尾",
    Strings.Dialog to "ダイアログ",
    Strings.MenuExpanded to "開いています",
    Strings.MenuCollapsed to "閉じています",
    Strings.ToggleDropdownMenu to "プルダウン メニューを切り替えます",
    Strings.SnackbarDismiss to "閉じる",
    Strings.SearchBarSearch to "検索",
    Strings.SuggestionsAvailable to "検索候補は次のとおりです",
    Strings.DatePickerTitle to "日付の選択",
    Strings.DatePickerHeadline to "選択した日付",
    Strings.DatePickerSwitchToYearSelection to "年の選択に切り替え",
    Strings.DatePickerSwitchToDaySelection to "スワイプして年を選択するか、タップして日付の選択に戻ります",
    Strings.DatePickerSwitchToNextMonth to "翌月に変更",
    Strings.DatePickerSwitchToPreviousMonth to "前月に変更",
    Strings.DatePickerNavigateToYearDescription to "年に移動 %1\$s",
    Strings.DatePickerHeadlineDescription to "現在の選択: %1\$s",
    Strings.DatePickerNoSelectionDescription to "なし",
    Strings.DatePickerTodayDescription to "今日",
    Strings.DatePickerYearPickerPaneTitle to "年の選択ツールの表示",
    Strings.DateInputTitle to "日付の選択",
    Strings.DateInputHeadline to "入力された日付",
    Strings.DateInputLabel to "日付",
    Strings.DateInputHeadlineDescription to "入力された日付: %1\$s",
    Strings.DateInputNoInputDescription to "なし",
    Strings.DateInputInvalidNotAllowed to "許可されない日付: %1\$s",
    Strings.DateInputInvalidForPattern to "想定パターンと一致しない日付: %1\$s",
    Strings.DateInputInvalidYearRange to "想定される年の範囲（%1\$s～%2\$s）から日付が外れています",
    Strings.DatePickerSwitchToCalendarMode to "カレンダー入力モードに切り替え",
    Strings.DatePickerSwitchToInputMode to "テキスト入力モードに切り替え",
    Strings.DatePickerScrollToShowLaterYears to "これより後の年を表示するにはスクロールしてください",
    Strings.DatePickerScrollToShowEarlierYears to "これより前の年を表示するにはスクロールしてください",
    Strings.DateRangePickerTitle to "日付の選択",
    Strings.DateRangePickerStartHeadline to "開始日",
    Strings.DateRangePickerEndHeadline to "終了日",
    Strings.DateRangePickerScrollToShowNextMonth to "翌月を表示するにはスクロールしてください",
    Strings.DateRangePickerScrollToShowPreviousMonth to "前月を表示するにはスクロールしてください",
    Strings.DateRangePickerDayInRange to "範囲内",
    Strings.DateRangeInputTitle to "日付の入力",
    Strings.DateRangeInputInvalidRangeInput to "入力された期間は無効です",
    Strings.BottomSheetPaneTitle to "ボトムシート",
    Strings.BottomSheetDragHandleDescription to "ドラッグ ハンドル",
    Strings.BottomSheetPartialExpandDescription to "ボトムシートを折りたたみます",
    Strings.BottomSheetDismissDescription to "ボトムシートを閉じます",
    Strings.BottomSheetExpandDescription to "ボトムシートを開きます",
    Strings.TooltipPaneDescription to "ツールチップ",
    Strings.TooltipLongPressLabel to "ツールチップを表示",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "午前または午後を選択",
    Strings.TimePickerHourSelection to "時刻を選択",
    Strings.TimePickerMinuteSelection to "分を選択",
    Strings.TimePickerHourSuffix to "%1\$d 時",
    Strings.TimePicker24HourSuffix to "%1\$d 時間",
    Strings.TimePickerMinuteSuffix to "%1\$d 分",
    Strings.TimePickerMinute to "分",
    Strings.TimePickerHour to "時間",
    Strings.TimePickerMinuteTextField to "（分単位）",
    Strings.TimePickerHourTextField to "（時間単位）",
)
