/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.uk() = mapOf(
    Strings.NavigationMenu to "Меню навігації",
    Strings.ExposedDropdownMenu to "Спадне меню",
    Strings.CloseDrawer to "Закрити меню навігації",
    Strings.CloseSheet to "Закрити аркуш",
    Strings.DefaultErrorMessage to "Введено недійсні дані",
    Strings.SliderRangeStart to "Початок діапазону",
    Strings.SliderRangeEnd to "Кінець діапазону",
    Strings.Dialog to "Вікно",
    Strings.MenuExpanded to "Розгорнуто",
    Strings.MenuCollapsed to "Згорнуто",
    Strings.ToggleDropdownMenu to "Згорнути або розгорнути спадне меню",
    Strings.SnackbarDismiss to "Закрити",
    Strings.SearchBarSearch to "Пошук",
    Strings.SuggestionsAvailable to "Підказки внизу",
    Strings.DatePickerTitle to "Виберіть дату",
    Strings.DatePickerHeadline to "Вибрана дата",
    Strings.DatePickerSwitchToYearSelection to "Перейти до вибору року",
    Strings.DatePickerSwitchToDaySelection to "Проведіть пальцем по екрану, щоб вибрати рік, або торкніться, щоб повернутися до вибору дня",
    Strings.DatePickerSwitchToNextMonth to "Перейти до наступного місяця",
    Strings.DatePickerSwitchToPreviousMonth to "Перейти до попереднього місяця",
    Strings.DatePickerNavigateToYearDescription to "Перейти до %1\$s року",
    Strings.DatePickerHeadlineDescription to "Поточний вибір: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Немає",
    Strings.DatePickerTodayDescription to "Сьогодні",
    Strings.DatePickerYearPickerPaneTitle to "Показувати засіб вибору року",
    Strings.DateInputTitle to "Виберіть дату",
    Strings.DateInputHeadline to "Введена дата",
    Strings.DateInputLabel to "Дата",
    Strings.DateInputHeadlineDescription to "Введена дата: %1\$s",
    Strings.DateInputNoInputDescription to "Немає",
    Strings.DateInputInvalidNotAllowed to "Недопустима дата: %1\$s",
    Strings.DateInputInvalidForPattern to "Дата не відповідає очікуваному шаблону: %1\$s",
    Strings.DateInputInvalidYearRange to "Дата за межами очікуваного діапазону років %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Перейти в режим введення в календарі",
    Strings.DatePickerSwitchToInputMode to "Перейти в режим введення тексту",
    Strings.DatePickerScrollToShowLaterYears to "Прокрутіть, щоб відобразити пізніші роки",
    Strings.DatePickerScrollToShowEarlierYears to "Прокрутіть, щоб відобразити попередні роки",
    Strings.DateRangePickerTitle to "Виберіть дати",
    Strings.DateRangePickerStartHeadline to "Дата початку",
    Strings.DateRangePickerEndHeadline to "Дата завершення",
    Strings.DateRangePickerScrollToShowNextMonth to "Прокрутіть, щоб відобразити наступний місяць",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Прокрутіть, щоб відобразити попередній місяць",
    Strings.DateRangePickerDayInRange to "У діапазоні",
    Strings.DateRangeInputTitle to "Введіть дати",
    Strings.DateRangeInputInvalidRangeInput to "Указано недійсний діапазон дат",
    Strings.BottomSheetPaneTitle to "Нижній екран",
    Strings.BottomSheetDragHandleDescription to "Маркер переміщення",
    Strings.BottomSheetPartialExpandDescription to "Згорнути нижній екран",
    Strings.BottomSheetDismissDescription to "Закрити нижній екран",
    Strings.BottomSheetExpandDescription to "Розгорнути нижній екран",
    Strings.TooltipPaneDescription to "Спливаюча підказка",
    Strings.TooltipLongPressLabel to "Показати спливаючу підказку",
    Strings.TimePickerPM to "ПП",
    Strings.TimePickerAM to "ДП",
    Strings.TimePickerPeriodToggle to "Виберіть ДП чи ПП",
    Strings.TimePickerHourSelection to "Вибрати годину",
    Strings.TimePickerMinuteSelection to "Вибрати хвилини",
    Strings.TimePickerHourSuffix to "%1\$d год",
    Strings.TimePicker24HourSuffix to "%1\$d год",
    Strings.TimePickerMinuteSuffix to "%1\$d хв",
    Strings.TimePickerMinute to "Хвилина",
    Strings.TimePickerHour to "Година",
    Strings.TimePickerMinuteTextField to "для хвилин",
    Strings.TimePickerHourTextField to "для годин",
)
