/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.af() = mapOf(
    Strings.NavigationMenu to "Navigasiekieslys",
    Strings.ExposedDropdownMenu to "Aftrekkieslys",
    Strings.CloseDrawer to "Maak navigasiekieslys toe",
    Strings.CloseSheet to "Maak sigblad toe",
    Strings.DefaultErrorMessage to "Ongeldige invoer",
    Strings.SliderRangeStart to "Begingrens",
    Strings.SliderRangeEnd to "Eindgrens",
    Strings.Dialog to "Dialoog",
    Strings.MenuExpanded to "Uitgevou",
    Strings.MenuCollapsed to "Ingevou",
    Strings.ToggleDropdownMenu to "Wissel aftrekkieslys",
    Strings.SnackbarDismiss to "Maak toe",
    Strings.SnackbarPaneTitle to "Opletberig",
    Strings.SearchBarSearch to "Soek",
    Strings.SuggestionsAvailable to "Voorstelle hieronder",
    Strings.DatePickerTitle to "Kies datum",
    Strings.DatePickerHeadline to "Gekose datum",
    Strings.DatePickerSwitchToYearSelection to "Skakel oor na kies van ’n jaar",
    Strings.DatePickerSwitchToDaySelection to "Swiep om ’n jaar te kies of tik om terug te skakel om ’n dag te kies",
    Strings.DatePickerSwitchToNextMonth to "Verander na volgende maand",
    Strings.DatePickerSwitchToPreviousMonth to "Verander na vorige maand",
    Strings.DatePickerNavigateToYearDescription to "Gaan na jaar %1\$s",
    Strings.DatePickerHeadlineDescription to "Huidige keuse: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Geen",
    Strings.DatePickerTodayDescription to "Vandag",
    Strings.DatePickerYearPickerPaneTitle to "Jaarkieser sigbaar",
    Strings.DateInputTitle to "Kies datum",
    Strings.DateInputHeadline to "Datum wat ingevoer is",
    Strings.DateInputLabel to "Datum",
    Strings.DateInputHeadlineDescription to "Datum wat ingevoer is: %1\$s",
    Strings.DateInputNoInputDescription to "Geen",
    Strings.DateInputInvalidNotAllowed to "Datum word nie toegelaat nie: %1\$s",
    Strings.DateInputInvalidForPattern to "Datum pas nie by die verwagte patroon nie: %1\$s",
    Strings.DateInputInvalidYearRange to "Datum val buite verwagte jaardatumreeks %1\$s-%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Skakel oor na kalenderinvoermodus",
    Strings.DatePickerSwitchToInputMode to "Skakel oor na teksinvoermodus",
    Strings.DatePickerScrollToShowLaterYears to "Rollees om later jare te wys",
    Strings.DatePickerScrollToShowEarlierYears to "Rollees om vroeër jare te wys",
    Strings.DateRangePickerTitle to "Kies datums",
    Strings.DateRangePickerStartHeadline to "Begindatum",
    Strings.DateRangePickerEndHeadline to "Einddatum",
    Strings.DateRangePickerScrollToShowNextMonth to "Rollees om die volgende maand te wys",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Rollees om die vorige maand te wys",
    Strings.DateRangePickerDayInRange to "Binne datumreeks",
    Strings.DateRangeInputTitle to "Voer datums in",
    Strings.DateRangeInputInvalidRangeInput to "Ongeldige datumreeksinvoer",
    Strings.BottomSheetPaneTitle to "Onderste blad",
    Strings.BottomSheetDragHandleDescription to "Sleephandvatsel",
    Strings.BottomSheetPartialExpandDescription to "Vou onderste blad in",
    Strings.BottomSheetDismissDescription to "Maak onderste blad toe",
    Strings.BottomSheetExpandDescription to "Vou onderste blad uit",
    Strings.FloatingToolbarCollapse to "Vou nutsbalk in",
    Strings.FloatingToolbarExpand to "Vou nutsbalk uit",
    Strings.TooltipPaneDescription to "Nutswenk",
    Strings.TooltipLongPressLabel to "Wys nutswenk",
    Strings.TimePickerPM to "nm.",
    Strings.TimePickerAM to "vm.",
    Strings.TimePickerPeriodToggle to "Kies vm. of nm.",
    Strings.TimePickerHourSelection to "Kies uur",
    Strings.TimePickerMinuteSelection to "Kies minute",
    Strings.TimePickerHourSuffix to "%1\$d uur",
    Strings.TimePicker24HourSuffix to "%1\$d uur",
    Strings.TimePickerMinuteSuffix to "%1\$d minute",
    Strings.TimePickerMinute to "Minute",
    Strings.TimePickerHour to "Uur",
    Strings.TimePickerMinuteTextField to "vir minute",
    Strings.TimePickerHourTextField to "vir uur",
    Strings.TimePickerToggleKeyboard to "Skakel oor na teksinvoermodus vir die tydinvoer",
    Strings.TimePickerToggleTouch to "Skakel oor na horlosiemodus vir die tydinvoer",
    Strings.TimePickerDialogTitle to "Kies tyd",
    Strings.TimeInputDialogTitle to "Voer tyd in",
    Strings.CloseRail to "Maak spoor toe",
    Strings.WideNavigationRailPaneTitle to "Navigasiespoor",
)
