/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.`as`() = mapOf(
    Strings.NavigationMenu to "নেভিগেশ্বন মেনু",
    Strings.ExposedDropdownMenu to "ড্ৰপডাউনৰ মেনু",
    Strings.CloseDrawer to "নেভিগেশ্বন মেনু বন্ধ কৰক",
    Strings.CloseSheet to "শ্বীট বন্ধ কৰক",
    Strings.DefaultErrorMessage to "অমান্য ইনপুট",
    Strings.SliderRangeStart to "পৰিসৰৰ আৰম্ভণি",
    Strings.SliderRangeEnd to "পৰিসৰৰ সমাপ্তি",
    Strings.Dialog to "ডায়ল’গ",
    Strings.MenuExpanded to "বিস্তাৰ কৰা আছে",
    Strings.MenuCollapsed to "সংকোচন কৰা আছে",
    Strings.ToggleDropdownMenu to "ড্ৰপডাউন মেনু ট’গল কৰক",
    Strings.SnackbarDismiss to "অগ্ৰাহ্য কৰক",
    Strings.SnackbarPaneTitle to "সতৰ্কবাৰ্তা",
    Strings.SearchBarSearch to "সন্ধান কৰক",
    Strings.SuggestionsAvailable to "তলত পৰামৰ্শ দেখুওৱা হৈছে",
    Strings.DatePickerTitle to "তাৰিখ বাছনি কৰক",
    Strings.DatePickerHeadline to "বাছনি কৰা তাৰিখ",
    Strings.DatePickerSwitchToYearSelection to "বছৰ বাছনি কৰাৰ সুবিধাটোলৈ সলনি কৰক",
    Strings.DatePickerSwitchToDaySelection to "এটা বছৰ বাছনি কৰিবলৈ ছোৱাইপ কৰক অথবা এটা দিন বাছনি কৰাৰ সুবিধাটোলৈ উভতি যাবলৈ টিপক",
    Strings.DatePickerSwitchToNextMonth to "পৰৱৰ্তী মাহলৈ সলনি কৰক",
    Strings.DatePickerSwitchToPreviousMonth to "পূৰ্বৱৰ্তী মাহলৈ সলনি কৰক",
    Strings.DatePickerNavigateToYearDescription to "বৰ্ষ %1\$sলৈ নেভিগে’ট কৰক",
    Strings.DatePickerHeadlineDescription to "বৰ্তমানৰ বাছনি: %1\$s",
    Strings.DatePickerNoSelectionDescription to "নাই",
    Strings.DatePickerTodayDescription to "আজি",
    Strings.DatePickerYearPickerPaneTitle to "বছৰ বাছনিকৰ্তা দৃশ্যমান",
    Strings.DateInputTitle to "তাৰিখ বাছনি কৰক",
    Strings.DateInputHeadline to "দিয়া তাৰিখ",
    Strings.DateInputLabel to "তাৰিখ",
    Strings.DateInputHeadlineDescription to "দিয়া তাৰিখ: %1\$s",
    Strings.DateInputNoInputDescription to "নাই",
    Strings.DateInputInvalidNotAllowed to "অনুমোদিত নোহোৱা তাৰিখ: %1\$s",
    Strings.DateInputInvalidForPattern to "তাৰিখটো এই প্ৰত্যাশিত আৰ্হিটোৰ সৈতে মিলা নাই: %1\$s",
    Strings.DateInputInvalidYearRange to "তাৰিখটো প্ৰত্যাশিত বছৰৰ পৰিসৰ %1\$s - %2\$sৰ বাহিৰৰ",
    Strings.DatePickerSwitchToCalendarMode to "কেলেণ্ডাৰ ইনপুট ম’ডলৈ সলনি কৰক",
    Strings.DatePickerSwitchToInputMode to "পাঠ ইনপুট ম’ডলৈ সলনি কৰক",
    Strings.DatePickerScrollToShowLaterYears to "পাছৰ বছৰবোৰ দেখুৱাবলৈ স্ক্ৰ’ল কৰক",
    Strings.DatePickerScrollToShowEarlierYears to "আগৰ বছৰবোৰ দেখুৱাবলৈ স্ক্ৰ’ল কৰক",
    Strings.DateRangePickerTitle to "তাৰিখ বাছনি কৰক",
    Strings.DateRangePickerStartHeadline to "আৰম্ভণিৰ তাৰিখ",
    Strings.DateRangePickerEndHeadline to "সমাপ্তিৰ তাৰিখ",
    Strings.DateRangePickerScrollToShowNextMonth to "পৰৱৰ্তী মাহটো দেখুৱাবলৈ স্ক্ৰ’ল কৰক",
    Strings.DateRangePickerScrollToShowPreviousMonth to "পূৰ্বৱৰ্তী মাহটো দেখুৱাবলৈ স্ক্ৰ’ল কৰক",
    Strings.DateRangePickerDayInRange to "পৰিসৰৰ ভিতৰত আছে",
    Strings.DateRangeInputTitle to "তাৰিখ দিয়ক",
    Strings.DateRangeInputInvalidRangeInput to "অমান্য তাৰিখৰ পৰিসৰৰ ইনপুট",
    Strings.BottomSheetPaneTitle to "তলৰ শ্বীট",
    Strings.BottomSheetDragHandleDescription to "ড্ৰেগ হেণ্ডেল",
    Strings.BottomSheetPartialExpandDescription to "তলৰ শ্বীটখন সংকোচন কৰক",
    Strings.BottomSheetDismissDescription to "তলৰ শ্বীটখন অগ্ৰাহ্য কৰক",
    Strings.BottomSheetExpandDescription to "তলৰ শ্বীটখন বিস্তাৰ কৰক",
    Strings.FloatingToolbarCollapse to "টুলবাৰ সংকোচন কৰক",
    Strings.FloatingToolbarExpand to "টুলবাৰ বিস্তাৰ কৰক",
    Strings.TooltipPaneDescription to "টুলটিপ",
    Strings.TooltipLongPressLabel to "টুলটিপ দেখুৱাওক",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM অথবা PM বাছনি কৰক",
    Strings.TimePickerHourSelection to "ঘণ্টা বাছনি কৰক",
    Strings.TimePickerMinuteSelection to "মিনিট বাছনি কৰক",
    Strings.TimePickerHourSuffix to "%1\$d বাজিছে",
    Strings.TimePicker24HourSuffix to "%1\$d ঘণ্টা",
    Strings.TimePickerMinuteSuffix to "%1\$d মিনিট",
    Strings.TimePickerMinute to "মিনিট",
    Strings.TimePickerHour to "ঘণ্টা",
    Strings.TimePickerMinuteTextField to "মিনিটৰ বাবে",
    Strings.TimePickerHourTextField to "ঘণ্টাৰ বাবে",
    Strings.TimePickerToggleKeyboard to "সময়ৰ ইনপুটৰ বাবে পাঠৰ ইনপুট ম’ডলৈ সলনি কৰক",
    Strings.TimePickerToggleTouch to "সময়ৰ ইনপুটৰ বাবে ঘড়ী ম’ডলৈ যাওক",
    Strings.TimePickerDialogTitle to "সময় বাছনি কৰক",
    Strings.TimeInputDialogTitle to "সময় দিয়ক",
    Strings.CloseRail to "ৰে’ল কৰক",
    Strings.WideNavigationRailPaneTitle to "নেভিগেশ্বন ৰে’ল",
)
