/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.be() = mapOf(
    Strings.NavigationMenu to "Меню навігацыі",
    Strings.ExposedDropdownMenu to "Выпадное меню",
    Strings.CloseDrawer to "Закрыць меню навігацыі",
    Strings.CloseSheet to "Закрыць аркуш",
    Strings.DefaultErrorMessage to "Памылка ўводу",
    Strings.SliderRangeStart to "Пачатак пераліку",
    Strings.SliderRangeEnd to "Канец пераліку",
    Strings.Dialog to "Дыялогавае акно",
    Strings.MenuExpanded to "Разгорнута",
    Strings.MenuCollapsed to "Згорнута",
    Strings.ToggleDropdownMenu to "Уключыць (выключыць) выпадное меню",
    Strings.SnackbarDismiss to "Закрыць",
    Strings.SnackbarPaneTitle to "Абвестка",
    Strings.SearchBarSearch to "Пошук",
    Strings.SuggestionsAvailable to "Прапановы ўнізе",
    Strings.DatePickerTitle to "Выберыце дату",
    Strings.DatePickerHeadline to "Выбраная дата",
    Strings.DatePickerSwitchToYearSelection to "Перайсці да выбару года",
    Strings.DatePickerSwitchToDaySelection to "Правядзіце пальцам, каб выбраць год, або націсніце, каб вярнуцца да выбару даты",
    Strings.DatePickerSwitchToNextMonth to "Перайсці да наступнага месяца",
    Strings.DatePickerSwitchToPreviousMonth to "Перайсці да папярэдняга месяца",
    Strings.DatePickerNavigateToYearDescription to "Перайсці ў год %1\$s",
    Strings.DatePickerHeadlineDescription to "Бягучы выбар: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Без абмежаванняў",
    Strings.DatePickerTodayDescription to "Сёння",
    Strings.DatePickerYearPickerPaneTitle to "Бачны інструмент выбару года",
    Strings.DateInputTitle to "Выберыце дату",
    Strings.DateInputHeadline to "Уведзеная дата",
    Strings.DateInputLabel to "Дата",
    Strings.DateInputHeadlineDescription to "Уведзеная дата: %1\$s",
    Strings.DateInputNoInputDescription to "Без абмежаванняў",
    Strings.DateInputInvalidNotAllowed to "Дата забаронена: %1\$s",
    Strings.DateInputInvalidForPattern to "Дата не адпавядае ўзору: %1\$s",
    Strings.DateInputInvalidYearRange to "Дата выходзіць за дазволены дыяпазон гадоў %1\$s-%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Пераключыцца ў рэжым уводу \"Каляндар\"",
    Strings.DatePickerSwitchToInputMode to "Пераключыцца ў рэжым уводу \"Тэкст\"",
    Strings.DatePickerScrollToShowLaterYears to "Прагартайце экран, каб прагледзець пазнейшыя гады",
    Strings.DatePickerScrollToShowEarlierYears to "Прагартайце экран, каб прагледзець ранейшыя гады",
    Strings.DateRangePickerTitle to "Выберыце даты",
    Strings.DateRangePickerStartHeadline to "Дата пачатку",
    Strings.DateRangePickerEndHeadline to "Дата заканчэння",
    Strings.DateRangePickerScrollToShowNextMonth to "Прагартайце экран, каб прагледзець наступны месяц",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Прагартайце экран, каб прагледзець мінулы месяц",
    Strings.DateRangePickerDayInRange to "У межах дыяпазону",
    Strings.DateRangeInputTitle to "Увядзіце даты",
    Strings.DateRangeInputInvalidRangeInput to "Уведзены няправільны дыяпазон дат",
    Strings.BottomSheetPaneTitle to "Ніжні аркуш",
    Strings.BottomSheetDragHandleDescription to "Маркер перацягвання",
    Strings.BottomSheetPartialExpandDescription to "Згарнуць ніжні аркуш",
    Strings.BottomSheetDismissDescription to "Закрыць ніжні аркуш",
    Strings.BottomSheetExpandDescription to "Разгарнуць ніжні аркуш",
    Strings.FloatingToolbarCollapse to "Згарнуць панэль інструментаў",
    Strings.FloatingToolbarExpand to "Разгарнуць панэль інструментаў",
    Strings.TooltipPaneDescription to "Падказка",
    Strings.TooltipLongPressLabel to "Паказваць усплывальую падказку",
    Strings.TimePickerPM to "пасля паўдня",
    Strings.TimePickerAM to "да паўдня",
    Strings.TimePickerPeriodToggle to "Выберыце AM (да паўдня) або PM (пасля паўдня)",
    Strings.TimePickerHourSelection to "Выберыце гадзіны",
    Strings.TimePickerMinuteSelection to "Выберыце хвіліны",
    Strings.TimePickerHourSuffix to "%1\$d гадз",
    Strings.TimePicker24HourSuffix to "%1\$d гадз",
    Strings.TimePickerMinuteSuffix to "%1\$d хв",
    Strings.TimePickerMinute to "Хвіліны",
    Strings.TimePickerHour to "Гадзіны",
    Strings.TimePickerMinuteTextField to "хвіліны",
    Strings.TimePickerHourTextField to "гадзіны",
    Strings.TimePickerToggleKeyboard to "Пераключыцца на тэкставы рэжым уводу, каб указаць час",
    Strings.TimePickerToggleTouch to "Пераключыцца на рэжым гадзінніка, каб указаць час",
    Strings.TimePickerDialogTitle to "Выберыце час",
    Strings.TimeInputDialogTitle to "Увядзіце час",
    Strings.CloseRail to "Закрыць планку",
    Strings.WideNavigationRailPaneTitle to "Планка навігацыі",
)
