/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.mk() = mapOf(
    Strings.NavigationMenu to "Мени за навигација",
    Strings.ExposedDropdownMenu to "Паѓачко мени",
    Strings.CloseDrawer to "Затворете го менито за навигација",
    Strings.CloseSheet to "Затворете го листот",
    Strings.DefaultErrorMessage to "Неважечки запис",
    Strings.SliderRangeStart to "Почеток на опсегот",
    Strings.SliderRangeEnd to "Крај на опсегот",
    Strings.Dialog to "Дијалог",
    Strings.MenuExpanded to "Проширено",
    Strings.MenuCollapsed to "Собрано",
    Strings.ToggleDropdownMenu to "Вклучување/исклучување паѓачко мени",
    Strings.SnackbarDismiss to "Отфрли",
    Strings.SnackbarPaneTitle to "Предупредување",
    Strings.SearchBarSearch to "Пребарување",
    Strings.SuggestionsAvailable to "Предлозите се наведени подолу",
    Strings.DatePickerTitle to "Изберете датум",
    Strings.DatePickerHeadline to "Избран датум",
    Strings.DatePickerSwitchToYearSelection to "Префрли на избирање година",
    Strings.DatePickerSwitchToDaySelection to "Повлечете за да изберете година или допрете за да се вратите на избирање ден",
    Strings.DatePickerSwitchToNextMonth to "Промени на следниот месец",
    Strings.DatePickerSwitchToPreviousMonth to "Промени на претходниот месец",
    Strings.DatePickerNavigateToYearDescription to "Одете на %1\$s година",
    Strings.DatePickerHeadlineDescription to "Тековен избор: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Нема",
    Strings.DatePickerTodayDescription to "Денес",
    Strings.DatePickerYearPickerPaneTitle to "Избирачот на година е видлив",
    Strings.DateInputTitle to "Изберете датум",
    Strings.DateInputHeadline to "Внесен датум",
    Strings.DateInputLabel to "Датум",
    Strings.DateInputHeadlineDescription to "Внесен датум: %1\$s",
    Strings.DateInputNoInputDescription to "Нема",
    Strings.DateInputInvalidNotAllowed to "Датумот не е дозволен: %1\$s",
    Strings.DateInputInvalidForPattern to "Не се совпаѓа со очекуваната шема: %1\$s",
    Strings.DateInputInvalidYearRange to "Датумот не е во очекуваниот опсег на години %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Префрли на режим за внесување во календарот",
    Strings.DatePickerSwitchToInputMode to "Префрли на режим за внесување текст",
    Strings.DatePickerScrollToShowLaterYears to "Лизгајте за да ги прикажете подоцнежните години",
    Strings.DatePickerScrollToShowEarlierYears to "Лизгајте за да ги прикажете претходните години",
    Strings.DateRangePickerTitle to "Изберете датуми",
    Strings.DateRangePickerStartHeadline to "Датум на започнување",
    Strings.DateRangePickerEndHeadline to "Датум на завршување",
    Strings.DateRangePickerScrollToShowNextMonth to "Лизгајте за да се прикаже следниот месец",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Лизгајте за да се прикаже претходниот месец",
    Strings.DateRangePickerDayInRange to "Во опсег",
    Strings.DateRangeInputTitle to "Внесете датуми",
    Strings.DateRangeInputInvalidRangeInput to "Внесовте неважечки временски период",
    Strings.BottomSheetPaneTitle to "Долен лист",
    Strings.BottomSheetDragHandleDescription to "Рачка за влечење",
    Strings.BottomSheetPartialExpandDescription to "Собери го долниот лист",
    Strings.BottomSheetDismissDescription to "Отфрли го долниот лист",
    Strings.BottomSheetExpandDescription to "Прошири го долниот лист",
    Strings.FloatingToolbarCollapse to "Собери го алатникот",
    Strings.FloatingToolbarExpand to "Прошири го алатникот",
    Strings.TooltipPaneDescription to "Совет за алатка",
    Strings.TooltipLongPressLabel to "Прикажи совет за алатка",
    Strings.TimePickerPM to "попл.",
    Strings.TimePickerAM to "прет.",
    Strings.TimePickerPeriodToggle to "Изберете претпладне или попладне",
    Strings.TimePickerHourSelection to "Изберете час",
    Strings.TimePickerMinuteSelection to "Изберете минути",
    Strings.TimePickerHourSuffix to "%1\$d часот",
    Strings.TimePicker24HourSuffix to "%1\$d часа",
    Strings.TimePickerMinuteSuffix to "%1\$d минути",
    Strings.TimePickerMinute to "Минута",
    Strings.TimePickerHour to "Час",
    Strings.TimePickerMinuteTextField to "за минути",
    Strings.TimePickerHourTextField to "за час",
    Strings.TimePickerToggleKeyboard to "Префрлете се на „Режим за внесување текст“ за да внесете време",
    Strings.TimePickerToggleTouch to "Префрлете се на „Режим за внесување на часовникот“",
    Strings.TimePickerDialogTitle to "Изберете време",
    Strings.TimeInputDialogTitle to "Внесете време",
    Strings.CloseRail to "Затворање на шината",
    Strings.WideNavigationRailPaneTitle to "Шина за навигација",
)
