/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ro() = mapOf(
    Strings.NavigationMenu to "Meniu de navigare",
    Strings.ExposedDropdownMenu to "Meniu drop-down",
    Strings.CloseDrawer to "Închide meniul de navigare",
    Strings.CloseSheet to "Închide foaia",
    Strings.DefaultErrorMessage to "Intrare nevalidă",
    Strings.SliderRangeStart to "Început de interval",
    Strings.SliderRangeEnd to "Sfârșit de interval",
    Strings.Dialog to "Dialog",
    Strings.MenuExpanded to "Extins",
    Strings.MenuCollapsed to "Restrâns",
    Strings.ToggleDropdownMenu to "Comută meniul drop-down",
    Strings.SnackbarDismiss to "Închide",
    Strings.SnackbarPaneTitle to "Alertă",
    Strings.SearchBarSearch to "Caută",
    Strings.SuggestionsAvailable to "Sugestii mai jos",
    Strings.DatePickerTitle to "Selectează data",
    Strings.DatePickerHeadline to "Data selectată",
    Strings.DatePickerSwitchToYearSelection to "Comută la selectarea anului",
    Strings.DatePickerSwitchToDaySelection to "Glisează pentru a selecta un an sau atinge pentru a reveni la selectarea zilei",
    Strings.DatePickerSwitchToNextMonth to "Treci la luna următoare",
    Strings.DatePickerSwitchToPreviousMonth to "Treci la luna anterioară",
    Strings.DatePickerNavigateToYearDescription to "Navighează la anul %1\$s",
    Strings.DatePickerHeadlineDescription to "Opțiunea selectată: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Niciuna",
    Strings.DatePickerTodayDescription to "Azi",
    Strings.DatePickerYearPickerPaneTitle to "Selectorul de an este vizibil",
    Strings.DateInputTitle to "Selectează data",
    Strings.DateInputHeadline to "Data introdusă",
    Strings.DateInputLabel to "Dată",
    Strings.DateInputHeadlineDescription to "Data introdusă: %1\$s",
    Strings.DateInputNoInputDescription to "Niciuna",
    Strings.DateInputInvalidNotAllowed to "Data nu este permisă: %1\$s",
    Strings.DateInputInvalidForPattern to "Data nu corespunde modelului așteptat: %1\$s",
    Strings.DateInputInvalidYearRange to "Data este în afara intervalului de ani %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Comută la modul de introducere în calendar",
    Strings.DatePickerSwitchToInputMode to "Comută la modul de introducere a textului",
    Strings.DatePickerScrollToShowLaterYears to "Derulează pentru a afișa anii ulteriori",
    Strings.DatePickerScrollToShowEarlierYears to "Derulează pentru a afișa anii anteriori",
    Strings.DateRangePickerTitle to "Selectează datele",
    Strings.DateRangePickerStartHeadline to "Data de începere",
    Strings.DateRangePickerEndHeadline to "Data de încheiere",
    Strings.DateRangePickerScrollToShowNextMonth to "Derulează pentru a afișa luna următoare",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Derulează pentru a afișa luna anterioară",
    Strings.DateRangePickerDayInRange to "În interval",
    Strings.DateRangeInputTitle to "Introdu datele",
    Strings.DateRangeInputInvalidRangeInput to "Intervalul de date introdus nu este valid",
    Strings.BottomSheetPaneTitle to "Foaia din partea de jos",
    Strings.BottomSheetDragHandleDescription to "Ghidaj de tragere",
    Strings.BottomSheetPartialExpandDescription to "Restrânge foaia din partea de jos",
    Strings.BottomSheetDismissDescription to "Închide foaia din partea de jos",
    Strings.BottomSheetExpandDescription to "Extinde foaia din partea de jos",
    Strings.FloatingToolbarCollapse to "Restrânge bara de instrumente",
    Strings.FloatingToolbarExpand to "Extinde bara de instrumente",
    Strings.TooltipPaneDescription to "Balon explicativ",
    Strings.TooltipLongPressLabel to "Afișează balonul explicativ",
    Strings.TimePickerPM to "p.m.",
    Strings.TimePickerAM to "a.m.",
    Strings.TimePickerPeriodToggle to "Selectează AM sau PM",
    Strings.TimePickerHourSelection to "Selectează ora",
    Strings.TimePickerMinuteSelection to "Selectează minutele",
    Strings.TimePickerHourSuffix to "Ora %1\$d",
    Strings.TimePicker24HourSuffix to "Ora %1\$d",
    Strings.TimePickerMinuteSuffix to "%1\$d minute",
    Strings.TimePickerMinute to "Minut",
    Strings.TimePickerHour to "Oră",
    Strings.TimePickerMinuteTextField to "pentru minute",
    Strings.TimePickerHourTextField to "pentru oră",
    Strings.TimePickerToggleKeyboard to "Pentru a introduce ora, comută la modul de introducere a textului",
    Strings.TimePickerToggleTouch to "Pentru a introduce ora, comută la modul ceas.",
    Strings.TimePickerDialogTitle to "Selectează ora",
    Strings.TimeInputDialogTitle to "Introdu ora",
    Strings.CloseRail to "Închide bara",
    Strings.WideNavigationRailPaneTitle to "Bară de navigare",
)
