/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ru() = mapOf(
    Strings.NavigationMenu to "Меню навигации",
    Strings.ExposedDropdownMenu to "Раскрывающееся меню",
    Strings.CloseDrawer to "Закрыть меню навигации",
    Strings.CloseSheet to "Закрыть лист",
    Strings.DefaultErrorMessage to "Неправильный ввод",
    Strings.SliderRangeStart to "Начало диапазона",
    Strings.SliderRangeEnd to "Конец диапазона",
    Strings.Dialog to "Диалоговое окно",
    Strings.MenuExpanded to "Развернуто",
    Strings.MenuCollapsed to "Свернуто",
    Strings.ToggleDropdownMenu to "Показать или скрыть раскрывающееся меню",
    Strings.SnackbarDismiss to "Закрыть",
    Strings.SnackbarPaneTitle to "Оповещение",
    Strings.SearchBarSearch to "Строка поиска",
    Strings.SuggestionsAvailable to "Подсказки показаны ниже",
    Strings.DatePickerTitle to "Выберите дату",
    Strings.DatePickerHeadline to "Выбранная дата",
    Strings.DatePickerSwitchToYearSelection to "Перейти к выбору года",
    Strings.DatePickerSwitchToDaySelection to "Проведите по экрану, чтобы выбрать год, или нажмите, чтобы вернуться к выбору дня.",
    Strings.DatePickerSwitchToNextMonth to "Перейти к следующему месяцу",
    Strings.DatePickerSwitchToPreviousMonth to "Перейти к предыдущему месяцу",
    Strings.DatePickerNavigateToYearDescription to "Переход к %1\$s году",
    Strings.DatePickerHeadlineDescription to "Текущий выбор: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Нет",
    Strings.DatePickerTodayDescription to "Сегодня",
    Strings.DatePickerYearPickerPaneTitle to "Отображаемый выбор года",
    Strings.DateInputTitle to "Выберите дату",
    Strings.DateInputHeadline to "Введенная дата",
    Strings.DateInputLabel to "Дата",
    Strings.DateInputHeadlineDescription to "Введенная дата: %1\$s",
    Strings.DateInputNoInputDescription to "Нет",
    Strings.DateInputInvalidNotAllowed to "Недопустимая дата: %1\$s",
    Strings.DateInputInvalidForPattern to "Дата не соответствует допустимому шаблону: %1\$s",
    Strings.DateInputInvalidYearRange to "Дата не входит в допустимый диапазон: %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Перейти в режим выбора даты",
    Strings.DatePickerSwitchToInputMode to "Перейти в режим ввода текста",
    Strings.DatePickerScrollToShowLaterYears to "Прокрутите до более поздних лет",
    Strings.DatePickerScrollToShowEarlierYears to "Прокрутите до более ранних лет",
    Strings.DateRangePickerTitle to "Выберите даты",
    Strings.DateRangePickerStartHeadline to "Начальная дата",
    Strings.DateRangePickerEndHeadline to "Конечная дата",
    Strings.DateRangePickerScrollToShowNextMonth to "Прокрутите до следующего месяца",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Прокрутите до предыдущего месяца",
    Strings.DateRangePickerDayInRange to "День в диапазоне дат",
    Strings.DateRangeInputTitle to "Введите даты",
    Strings.DateRangeInputInvalidRangeInput to "Указан недопустимый диапазон дат.",
    Strings.BottomSheetPaneTitle to "Нижний экран",
    Strings.BottomSheetDragHandleDescription to "Маркер перемещения",
    Strings.BottomSheetPartialExpandDescription to "Свернуть нижний экран",
    Strings.BottomSheetDismissDescription to "Закрыть нижний экран",
    Strings.BottomSheetExpandDescription to "Развернуть нижний экран",
    Strings.FloatingToolbarCollapse to "Свернуть панель инструментов",
    Strings.FloatingToolbarExpand to "Развернуть панель инструментов",
    Strings.TooltipPaneDescription to "Подсказка",
    Strings.TooltipLongPressLabel to "Показать подсказку",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Выбрать AM (до полудня) или PM (после полудня)",
    Strings.TimePickerHourSelection to "Выбрать час",
    Strings.TimePickerMinuteSelection to "Выберите минуты",
    Strings.TimePickerHourSuffix to "%1\$d ч.",
    Strings.TimePicker24HourSuffix to "%1\$d ч.",
    Strings.TimePickerMinuteSuffix to "%1\$d мин.",
    Strings.TimePickerMinute to "Минуты",
    Strings.TimePickerHour to "Часы",
    Strings.TimePickerMinuteTextField to "минуты",
    Strings.TimePickerHourTextField to "часы",
    Strings.TimePickerToggleKeyboard to "Указать время, используя режим ввода текста",
    Strings.TimePickerToggleTouch to "Выбрать время, используя режим часов",
    Strings.TimePickerDialogTitle to "Выберите время",
    Strings.TimeInputDialogTitle to "Укажите время",
    Strings.CloseRail to "Закрыть боковую панель",
    Strings.WideNavigationRailPaneTitle to "Боковая панель навигации",
)
