/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.sk() = mapOf(
    Strings.NavigationMenu to "Navigačná ponuka",
    Strings.ExposedDropdownMenu to "Rozbaľovacia ponuka",
    Strings.CloseDrawer to "Zavrieť navigačnú ponuku",
    Strings.CloseSheet to "Zavrieť hárok",
    Strings.DefaultErrorMessage to "Neplatný vstup",
    Strings.SliderRangeStart to "Začiatok rozsahu",
    Strings.SliderRangeEnd to "Koniec rozsahu",
    Strings.Dialog to "Dialógové okno",
    Strings.MenuExpanded to "Rozbalené",
    Strings.MenuCollapsed to "Zbalené",
    Strings.ToggleDropdownMenu to "Prepnutie rozbaľovacieho zoznamu",
    Strings.SnackbarDismiss to "Zavrieť",
    Strings.SnackbarPaneTitle to "Upozornenie",
    Strings.SearchBarSearch to "Hľadať",
    Strings.SuggestionsAvailable to "Návrhy sú nižšie",
    Strings.DatePickerTitle to "Vybrať dátum",
    Strings.DatePickerHeadline to "Vybraný dátum",
    Strings.DatePickerSwitchToYearSelection to "Prepnúť na výber roka",
    Strings.DatePickerSwitchToDaySelection to "Potiahnutím vyberte rok alebo klepnutím prepnite späť na výber dňa",
    Strings.DatePickerSwitchToNextMonth to "Zmeniť na nasledujúci mesiac",
    Strings.DatePickerSwitchToPreviousMonth to "Zmeniť na predchádzajúci mesiac",
    Strings.DatePickerNavigateToYearDescription to "Prejsť na rok %1\$s",
    Strings.DatePickerHeadlineDescription to "Aktuálny výber: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Žiadne",
    Strings.DatePickerTodayDescription to "Dnes",
    Strings.DatePickerYearPickerPaneTitle to "Výber roka je viditeľný",
    Strings.DateInputTitle to "Vybrať dátum",
    Strings.DateInputHeadline to "Zadaný dátum",
    Strings.DateInputLabel to "Dátum",
    Strings.DateInputHeadlineDescription to "Zadaný dátum: %1\$s",
    Strings.DateInputNoInputDescription to "Žiadne",
    Strings.DateInputInvalidNotAllowed to "Nepovolený dátum: %1\$s",
    Strings.DateInputInvalidForPattern to "Dátum nezodpovedá očakávanému vzoru: %1\$s",
    Strings.DateInputInvalidYearRange to "Dátum sa nenachádza v očakávanom rozsahu rokov: %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Prepnúť na kalendárový režim vstupu",
    Strings.DatePickerSwitchToInputMode to "Prepnúť na režim zadávania textu",
    Strings.DatePickerScrollToShowLaterYears to "Posunutím si zobrazte neskoršie roky",
    Strings.DatePickerScrollToShowEarlierYears to "Posunutím si zobrazte skoršie roky",
    Strings.DateRangePickerTitle to "Vybrať dátumy",
    Strings.DateRangePickerStartHeadline to "Dátum začatia",
    Strings.DateRangePickerEndHeadline to "Dátum ukončenia",
    Strings.DateRangePickerScrollToShowNextMonth to "Posunutím si zobrazte nasledujúci mesiac",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Posunutím si zobrazte predchádzajúci mesiac",
    Strings.DateRangePickerDayInRange to "V rozsahu",
    Strings.DateRangeInputTitle to "Zadať dátumy",
    Strings.DateRangeInputInvalidRangeInput to "Neplatné zadané obdobie",
    Strings.BottomSheetPaneTitle to "Dolný hárok",
    Strings.BottomSheetDragHandleDescription to "Presúvadlo",
    Strings.BottomSheetPartialExpandDescription to "Zbaliť dolný hárok",
    Strings.BottomSheetDismissDescription to "Zavrieť dolný hárok",
    Strings.BottomSheetExpandDescription to "Rozbaliť dolný hárok",
    Strings.FloatingToolbarCollapse to "Zbaliť panel s nástrojmi",
    Strings.FloatingToolbarExpand to "Rozbaliť panel s nástrojmi",
    Strings.TooltipPaneDescription to "Popis",
    Strings.TooltipLongPressLabel to "Zobraziť popis",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Vyberte AM alebo PM",
    Strings.TimePickerHourSelection to "Vybrať hodinu",
    Strings.TimePickerMinuteSelection to "Vybrať minúty",
    Strings.TimePickerHourSuffix to "%1\$d h",
    Strings.TimePicker24HourSuffix to "%1\$d h",
    Strings.TimePickerMinuteSuffix to "%1\$d min",
    Strings.TimePickerMinute to "Minúty",
    Strings.TimePickerHour to "Hodina",
    Strings.TimePickerMinuteTextField to "minúty",
    Strings.TimePickerHourTextField to "hodiny",
    Strings.TimePickerToggleKeyboard to "Ak chcete zadať čas, prepnite na režim zadávania textu",
    Strings.TimePickerToggleTouch to "Ak chcete zadať čas, prepnite na režim hodín",
    Strings.TimePickerDialogTitle to "Vyberte čas",
    Strings.TimeInputDialogTitle to "Zadajte čas",
    Strings.CloseRail to "Zavrieť pruh",
    Strings.WideNavigationRailPaneTitle to "Navigačný pruh",
)
