/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.th() = mapOf(
    Strings.NavigationMenu to "เมนูการนำทาง",
    Strings.ExposedDropdownMenu to "เมนูแบบเลื่อนลง",
    Strings.CloseDrawer to "ปิดเมนูการนำทาง",
    Strings.CloseSheet to "ปิดชีต",
    Strings.DefaultErrorMessage to "อินพุตไม่ถูกต้อง",
    Strings.SliderRangeStart to "จุดเริ่มต้นของช่วง",
    Strings.SliderRangeEnd to "จุดสิ้นสุดของช่วง",
    Strings.Dialog to "กล่องโต้ตอบ",
    Strings.MenuExpanded to "ขยายแล้ว",
    Strings.MenuCollapsed to "ยุบแล้ว",
    Strings.ToggleDropdownMenu to "เปิด/ปิดเมนูแบบเลื่อนลง",
    Strings.SnackbarDismiss to "ปิด",
    Strings.SnackbarPaneTitle to "การแจ้งเตือน",
    Strings.SearchBarSearch to "ค้นหา",
    Strings.SuggestionsAvailable to "มีคำแนะนำที่ด้านล่าง",
    Strings.DatePickerTitle to "เลือกวันที่",
    Strings.DatePickerHeadline to "วันที่ที่เลือก",
    Strings.DatePickerSwitchToYearSelection to "เปลี่ยนไปที่การเลือกปี",
    Strings.DatePickerSwitchToDaySelection to "ปัดเพื่อเลือกปีหรือแตะเพื่อเปลี่ยนกลับไปยังการเลือกวัน",
    Strings.DatePickerSwitchToNextMonth to "เปลี่ยนไปที่เดือนถัดไป",
    Strings.DatePickerSwitchToPreviousMonth to "เปลี่ยนไปที่เดือนก่อนหน้า",
    Strings.DatePickerNavigateToYearDescription to "ไปยังปี %1\$s",
    Strings.DatePickerHeadlineDescription to "การเลือกปัจจุบัน: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ไม่มี",
    Strings.DatePickerTodayDescription to "วันนี้",
    Strings.DatePickerYearPickerPaneTitle to "แสดงตัวเลือกปี",
    Strings.DateInputTitle to "เลือกวันที่",
    Strings.DateInputHeadline to "วันที่ป้อน",
    Strings.DateInputLabel to "วันที่",
    Strings.DateInputHeadlineDescription to "วันที่ป้อน: %1\$s",
    Strings.DateInputNoInputDescription to "ไม่มี",
    Strings.DateInputInvalidNotAllowed to "ไม่อนุญาตให้ใช้วันที่นี้: %1\$s",
    Strings.DateInputInvalidForPattern to "วันที่ไม่ตรงกับรูปแบบที่คาดไว้: %1\$s",
    Strings.DateInputInvalidYearRange to "วันที่อยู่นอกเหนือจากช่วงปีที่คาดไว้ %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "สลับไปใช้โหมดป้อนข้อมูลปฏิทิน",
    Strings.DatePickerSwitchToInputMode to "สลับไปใช้โหมดการป้อนข้อความ",
    Strings.DatePickerScrollToShowLaterYears to "เลื่อนเพื่อแสดงปีหลังจากนี้",
    Strings.DatePickerScrollToShowEarlierYears to "เลื่อนเพื่อแสดงปีก่อนหน้านี้",
    Strings.DateRangePickerTitle to "เลือกวันที่",
    Strings.DateRangePickerStartHeadline to "วันที่เริ่มต้น",
    Strings.DateRangePickerEndHeadline to "วันที่สิ้นสุด",
    Strings.DateRangePickerScrollToShowNextMonth to "เลื่อนเพื่อแสดงเดือนถัดไป",
    Strings.DateRangePickerScrollToShowPreviousMonth to "เลื่อนเพื่อแสดงเดือนก่อนหน้า",
    Strings.DateRangePickerDayInRange to "อยู่ในช่วงวันที่ที่เลือก",
    Strings.DateRangeInputTitle to "ป้อนวันที่",
    Strings.DateRangeInputInvalidRangeInput to "การป้อนข้อมูลช่วงวันที่ไม่ถูกต้อง",
    Strings.BottomSheetPaneTitle to "Bottom Sheet",
    Strings.BottomSheetDragHandleDescription to "แฮนเดิลการลาก",
    Strings.BottomSheetPartialExpandDescription to "ยุบ Bottom Sheet",
    Strings.BottomSheetDismissDescription to "ปิด Bottom Sheet",
    Strings.BottomSheetExpandDescription to "ขยาย Bottom Sheet",
    Strings.FloatingToolbarCollapse to "ยุบแถบเครื่องมือ",
    Strings.FloatingToolbarExpand to "ขยายแถบเครื่องมือ",
    Strings.TooltipPaneDescription to "เคล็ดลับเครื่องมือ",
    Strings.TooltipLongPressLabel to "แสดงเคล็ดลับเครื่องมือ",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "เลือก AM หรือ PM",
    Strings.TimePickerHourSelection to "เลือกชั่วโมง",
    Strings.TimePickerMinuteSelection to "เลือกนาที",
    Strings.TimePickerHourSuffix to "%1\$d น.",
    Strings.TimePicker24HourSuffix to "%1\$d ชม.",
    Strings.TimePickerMinuteSuffix to "%1\$d นาที",
    Strings.TimePickerMinute to "นาที",
    Strings.TimePickerHour to "ชั่วโมง",
    Strings.TimePickerMinuteTextField to "สำหรับนาที",
    Strings.TimePickerHourTextField to "สำหรับชั่วโมง",
    Strings.TimePickerToggleKeyboard to "เปลี่ยนเป็นโหมดการป้อนข้อความเพื่อป้อนเวลา",
    Strings.TimePickerToggleTouch to "สลับเป็นโหมดนาฬิกาเพื่อป้อนเวลา",
    Strings.TimePickerDialogTitle to "เลือกเวลา",
    Strings.TimeInputDialogTitle to "ป้อนเวลา",
    Strings.CloseRail to "ปิดแถบข้าง",
    Strings.WideNavigationRailPaneTitle to "แถบข้างสำหรับไปยังส่วนต่างๆ",
)
