/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ur() = mapOf(
    Strings.NavigationMenu to "نیویگیشن مینیو",
    Strings.ExposedDropdownMenu to "ڈراپ ڈاؤن مینیو",
    Strings.CloseDrawer to "نیویگیشن مینیو بند کریں",
    Strings.CloseSheet to "شیٹ بند کریں",
    Strings.DefaultErrorMessage to "غلط ان پٹ",
    Strings.SliderRangeStart to "رینج کی شروعات",
    Strings.SliderRangeEnd to "رینج کا اختتام",
    Strings.Dialog to "ڈائلاگ",
    Strings.MenuExpanded to "پھیلایا گیا",
    Strings.MenuCollapsed to "سکیڑا گیا",
    Strings.ToggleDropdownMenu to "ڈراپ ڈاؤن مینیو کو ٹوگل کریں",
    Strings.SnackbarDismiss to "برخاست کریں",
    Strings.SnackbarPaneTitle to "الرٹ",
    Strings.SearchBarSearch to "تلاش کریں",
    Strings.SuggestionsAvailable to "تلاش کی تجاویز نیچے دستیاب ہیں",
    Strings.DatePickerTitle to "تاریخ منتخب کریں",
    Strings.DatePickerHeadline to "منتخب کردہ تاریخ",
    Strings.DatePickerSwitchToYearSelection to "ایک سال کا انتخاب کرنے کے لیے سوئچ کریں",
    Strings.DatePickerSwitchToDaySelection to "ایک سال منتخب کرنے کے لیے سوائپ کریں یا ایک دن منتخب کرنے کی خاطر دوبارہ سوئچ کرنے کے لیے تھپتھپائیں",
    Strings.DatePickerSwitchToNextMonth to "اگلے ماہ میں تبدیل کریں",
    Strings.DatePickerSwitchToPreviousMonth to "گزشتہ ماہ میں تبدیل کریں",
    Strings.DatePickerNavigateToYearDescription to "‏سال ‎%1\$s پر نیویگیٹ کریں",
    Strings.DatePickerHeadlineDescription to "‏موجودہ انتخاب: ‎%1\$s",
    Strings.DatePickerNoSelectionDescription to "کوئی نہیں",
    Strings.DatePickerTodayDescription to "آج",
    Strings.DatePickerYearPickerPaneTitle to "سال کا منتخب کنندہ مرئی ہے",
    Strings.DateInputTitle to "تاریخ منتخب کریں",
    Strings.DateInputHeadline to "درج کردہ تاریخ",
    Strings.DateInputLabel to "تاریخ",
    Strings.DateInputHeadlineDescription to "‏درج کردہ تاریخ: %1\$s",
    Strings.DateInputNoInputDescription to "کوئی نہیں",
    Strings.DateInputInvalidNotAllowed to "‏تاریخ کی اجازت نہیں ہے: ‎%1\$s",
    Strings.DateInputInvalidForPattern to "‏تاریخ متوقع پیٹرن سے مماثل نہیں ہے: %1\$s",
    Strings.DateInputInvalidYearRange to "‏متوقع سال کی حد ‎%1\$s‏ - %2\$s سے باہر کی تاریخ",
    Strings.DatePickerSwitchToCalendarMode to "کیلنڈر اِن پٹ موڈ پر سوئچ کریں",
    Strings.DatePickerSwitchToInputMode to "ٹیکسٹ اِن پٹ موڈ پر سوئچ کریں",
    Strings.DatePickerScrollToShowLaterYears to "بعد کے سالوں کا ڈیٹا دکھانے کے لیے اسکرول کریں",
    Strings.DatePickerScrollToShowEarlierYears to "پچھلے سالوں کا ڈیٹا دکھانے کے لیے اسکرول کریں",
    Strings.DateRangePickerTitle to "تواریخ منتخب کریں",
    Strings.DateRangePickerStartHeadline to "تاریخ آغاز",
    Strings.DateRangePickerEndHeadline to "تاریخ اختتام",
    Strings.DateRangePickerScrollToShowNextMonth to "اگلے ماہ کا ڈیٹا دکھانے کے لیے اسکرول کریں",
    Strings.DateRangePickerScrollToShowPreviousMonth to "پچھلے ماہ کا ڈیٹا دکھانے کے لیے اسکرول کریں",
    Strings.DateRangePickerDayInRange to "رینج میں ہے",
    Strings.DateRangeInputTitle to "تواریخ درج کریں",
    Strings.DateRangeInputInvalidRangeInput to "تاریخ کی حد کا غلط ان پٹ",
    Strings.BottomSheetPaneTitle to "نیچے کی شیٹ",
    Strings.BottomSheetDragHandleDescription to "گھسیٹنے کا ہینڈل",
    Strings.BottomSheetPartialExpandDescription to "نیچے کی شیٹ کو سکیڑیں",
    Strings.BottomSheetDismissDescription to "نیچے کی شیٹ کو برخاست کریں",
    Strings.BottomSheetExpandDescription to "نیچے کی شیٹ کو پھیلائیں",
    Strings.FloatingToolbarCollapse to "ٹول بار کو سکیڑیں",
    Strings.FloatingToolbarExpand to "ٹول بار کو پھیلائیں",
    Strings.TooltipPaneDescription to "ٹول ٹپ",
    Strings.TooltipLongPressLabel to "ٹول ٹپ دکھائیں",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "‏AM یا PM منتخب کریں",
    Strings.TimePickerHourSelection to "گھنٹہ منتخب کریں",
    Strings.TimePickerMinuteSelection to "منٹ منتخب کریں",
    Strings.TimePickerHourSuffix to "‏‎%1\$d بجے",
    Strings.TimePicker24HourSuffix to "‏‎%1\$d گھنٹے",
    Strings.TimePickerMinuteSuffix to "‏%1\$d منٹس",
    Strings.TimePickerMinute to "منٹ",
    Strings.TimePickerHour to "گھنٹہ",
    Strings.TimePickerMinuteTextField to "منٹ کے لیے",
    Strings.TimePickerHourTextField to "گھنٹے کے لیے",
    Strings.TimePickerToggleKeyboard to "وقت ان پٹ کے لیے ٹیکسٹ اِن پٹ موڈ پر سوئچ کریں",
    Strings.TimePickerToggleTouch to "وقت ان پٹ کے لیے گھڑی موڈ پر سوئچ کریں",
    Strings.TimePickerDialogTitle to "وقت منتخب کریں",
    Strings.TimeInputDialogTitle to "وقت درج کریں",
    Strings.CloseRail to "ریل بند کریں",
    Strings.WideNavigationRailPaneTitle to "نیوی گیشن ریل",
)
