/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.es() = mapOf(
    Strings.NavigationMenu to "Menú de navegación",
    Strings.ExposedDropdownMenu to "Menú desplegable",
    Strings.CloseDrawer to "Cerrar menú de navegación",
    Strings.CloseSheet to "Cerrar hoja",
    Strings.DefaultErrorMessage to "Entrada no válida",
    Strings.SliderRangeStart to "Inicio del intervalo",
    Strings.SliderRangeEnd to "Fin del intervalo",
    Strings.Dialog to "Cuadro de diálogo",
    Strings.MenuExpanded to "Desplegado",
    Strings.MenuCollapsed to "Contraído",
    Strings.ToggleDropdownMenu to "Mostrar/ocultar menú desplegable",
    Strings.SnackbarDismiss to "Cerrar",
    Strings.SearchBarSearch to "Buscar",
    Strings.SuggestionsAvailable to "Sugerencias a continuación",
    Strings.DatePickerTitle to "Seleccionar fecha",
    Strings.DatePickerHeadline to "Fecha seleccionada",
    Strings.DatePickerSwitchToYearSelection to "Cambiar para seleccionar un año",
    Strings.DatePickerSwitchToDaySelection to "Desliza para seleccionar un año o toca para volver a seleccionar un día",
    Strings.DatePickerSwitchToNextMonth to "Cambiar al mes siguiente",
    Strings.DatePickerSwitchToPreviousMonth to "Cambiar al mes anterior",
    Strings.DatePickerNavigateToYearDescription to "Ir al año %1\$s",
    Strings.DatePickerHeadlineDescription to "Seleccionado: %1\$s",
    Strings.DatePickerNoSelectionDescription to "No hay datos",
    Strings.DatePickerTodayDescription to "Hoy",
    Strings.DatePickerYearPickerPaneTitle to "Selector de año visible",
    Strings.DateInputTitle to "Seleccionar fecha",
    Strings.DateInputHeadline to "Fecha introducida",
    Strings.DateInputLabel to "Fecha",
    Strings.DateInputHeadlineDescription to "Fecha introducida: %1\$s",
    Strings.DateInputNoInputDescription to "No hay datos",
    Strings.DateInputInvalidNotAllowed to "Fecha no permitida: %1\$s",
    Strings.DateInputInvalidForPattern to "La fecha no coincide con el patrón esperado: %1\$s",
    Strings.DateInputInvalidYearRange to "Fecha fuera del intervalo de años previsto: %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Cambiar al modo de introducción de calendario",
    Strings.DatePickerSwitchToInputMode to "Cambiar al modo de introducción de texto",
    Strings.DatePickerScrollToShowLaterYears to "Desplázate para ver los años posteriores",
    Strings.DatePickerScrollToShowEarlierYears to "Desplázate para ver los años anteriores",
    Strings.DateRangePickerTitle to "Seleccionar fechas",
    Strings.DateRangePickerStartHeadline to "Fecha de inicio",
    Strings.DateRangePickerEndHeadline to "Fecha de finalización",
    Strings.DateRangePickerScrollToShowNextMonth to "Desplázate para ver el mes siguiente",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Desplázate para ver el mes anterior",
    Strings.DateRangePickerDayInRange to "Dentro del intervalo",
    Strings.DateRangeInputTitle to "Introducir fechas",
    Strings.DateRangeInputInvalidRangeInput to "El intervalo de fechas no es válido",
    Strings.BottomSheetPaneTitle to "Hoja inferior",
    Strings.BottomSheetDragHandleDescription to "Controlador de arrastre",
    Strings.BottomSheetPartialExpandDescription to "Contrae la hoja inferior",
    Strings.BottomSheetDismissDescription to "Cierra la hoja inferior",
    Strings.BottomSheetExpandDescription to "Despliega la hoja inferior",
    Strings.TooltipPaneDescription to "Descripción emergente",
    Strings.TooltipLongPressLabel to "Mostrar descripción emergente",
    Strings.TimePickerPM to "p. m.",
    Strings.TimePickerAM to "a. m.",
    Strings.TimePickerPeriodToggle to "Selecciona AM o PM",
    Strings.TimePickerHourSelection to "Seleccionar hora",
    Strings.TimePickerMinuteSelection to "Seleccionar minutos",
    Strings.TimePickerHourSuffix to "%1\$d en punto",
    Strings.TimePicker24HourSuffix to "%1\$d horas",
    Strings.TimePickerMinuteSuffix to "%1\$d minutos",
    Strings.TimePickerMinute to "Minutos",
    Strings.TimePickerHour to "Hora",
    Strings.TimePickerMinuteTextField to "para los minutos",
    Strings.TimePickerHourTextField to "para la hora",
)

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.esUS() = mapOf(
    Strings.NavigationMenu to "Menú de navegación",
    Strings.ExposedDropdownMenu to "Menú desplegable",
    Strings.CloseDrawer to "Cerrar el menú de navegación",
    Strings.CloseSheet to "Cerrar hoja",
    Strings.DefaultErrorMessage to "Entrada no válida",
    Strings.SliderRangeStart to "Inicio de intervalo",
    Strings.SliderRangeEnd to "Final de intervalo",
    Strings.Dialog to "Diálogo",
    Strings.MenuExpanded to "Expandido",
    Strings.MenuCollapsed to "Contraído",
    Strings.ToggleDropdownMenu to "Activar o desactivar menú desplegable",
    Strings.SnackbarDismiss to "Descartar",
    Strings.SearchBarSearch to "Buscar",
    Strings.SuggestionsAvailable to "Sugerencias a continuación",
    Strings.DatePickerTitle to "Seleccionar fecha",
    Strings.DatePickerHeadline to "Fecha seleccionada",
    Strings.DatePickerSwitchToYearSelection to "Cambiar a seleccionar un año",
    Strings.DatePickerSwitchToDaySelection to "Desliza el dedo para seleccionar un año o presiona para volver a la selección de día",
    Strings.DatePickerSwitchToNextMonth to "Cambiar al mes siguiente",
    Strings.DatePickerSwitchToPreviousMonth to "Cambiar al mes anterior",
    Strings.DatePickerNavigateToYearDescription to "Navegar al año %1\$s",
    Strings.DatePickerHeadlineDescription to "Selección actual: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ninguna",
    Strings.DatePickerTodayDescription to "Hoy",
    Strings.DatePickerYearPickerPaneTitle to "Selector de año visible",
    Strings.DateInputTitle to "Seleccionar fecha",
    Strings.DateInputHeadline to "Fecha ingresada",
    Strings.DateInputLabel to "Fecha",
    Strings.DateInputHeadlineDescription to "Fecha ingresada: %1\$s",
    Strings.DateInputNoInputDescription to "Ninguna",
    Strings.DateInputInvalidNotAllowed to "Fecha no permitida: %1\$s",
    Strings.DateInputInvalidForPattern to "La fecha no coincide con el patrón esperado: %1\$s",
    Strings.DateInputInvalidYearRange to "La fecha está fuera del rango de años esperado: %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Cambiar al modo de entrada de calendario",
    Strings.DatePickerSwitchToInputMode to "Cambiar al modo de entrada de texto",
    Strings.DatePickerScrollToShowLaterYears to "Desplázate para ver los últimos años",
    Strings.DatePickerScrollToShowEarlierYears to "Desplázate para ver los primeros años",
    Strings.DateRangePickerTitle to "Seleccionar fechas",
    Strings.DateRangePickerStartHeadline to "Fecha de inicio",
    Strings.DateRangePickerEndHeadline to "Fecha de finalización",
    Strings.DateRangePickerScrollToShowNextMonth to "Desplázate para ver el próximo mes",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Desplázate para ver el mes anterior",
    Strings.DateRangePickerDayInRange to "En el rango",
    Strings.DateRangeInputTitle to "Ingresar fechas",
    Strings.DateRangeInputInvalidRangeInput to "Se introdujo un período no válido",
    Strings.BottomSheetPaneTitle to "Hoja inferior",
    Strings.BottomSheetDragHandleDescription to "Controlador de arrastre",
    Strings.BottomSheetPartialExpandDescription to "Contraer la hoja inferior",
    Strings.BottomSheetDismissDescription to "Descartar la hoja inferior",
    Strings.BottomSheetExpandDescription to "Expandir la hoja inferior",
    Strings.TooltipPaneDescription to "Información",
    Strings.TooltipLongPressLabel to "Mostrar información",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Selecciona a.m. o p.m.",
    Strings.TimePickerHourSelection to "Seleccionar hora",
    Strings.TimePickerMinuteSelection to "Seleccionar los minutos",
    Strings.TimePickerHourSuffix to "%1\$d en punto",
    Strings.TimePicker24HourSuffix to "%1\$d horas",
    Strings.TimePickerMinuteSuffix to "%1\$d minutos",
    Strings.TimePickerMinute to "Minuto",
    Strings.TimePickerHour to "Hora",
    Strings.TimePickerMinuteTextField to "por minutos",
    Strings.TimePickerHourTextField to "por hora",
)
