/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.eu() = mapOf(
    Strings.NavigationMenu to "Nabigazio-menua",
    Strings.ExposedDropdownMenu to "Goitibeherako menua",
    Strings.CloseDrawer to "Itxi nabigazio-menua",
    Strings.CloseSheet to "Itxi orria",
    Strings.DefaultErrorMessage to "Sarrerak ez du balio",
    Strings.SliderRangeStart to "Barrutiaren hasiera",
    Strings.SliderRangeEnd to "Barrutiaren amaiera",
    Strings.Dialog to "Leihoa",
    Strings.MenuExpanded to "Zabalduta",
    Strings.MenuCollapsed to "Tolestuta",
    Strings.ToggleDropdownMenu to "Zabaldu/Tolestu goitibeherako menua",
    Strings.SnackbarDismiss to "Baztertu",
    Strings.SearchBarSearch to "Bilatu",
    Strings.SuggestionsAvailable to "Iradokizunak daude behean",
    Strings.DatePickerTitle to "Hautatu data bat",
    Strings.DatePickerHeadline to "Hautatutako data",
    Strings.DatePickerSwitchToYearSelection to "Joan urte-hautatzailera",
    Strings.DatePickerSwitchToDaySelection to "Pasatu hatza urte bat hautatzeko. Bestela, sakatu hau eguna hautatzeko pantailara itzultzeko.",
    Strings.DatePickerSwitchToNextMonth to "Aldatu hurrengo hilabetera",
    Strings.DatePickerSwitchToPreviousMonth to "Aldatu aurreko hilabetera",
    Strings.DatePickerNavigateToYearDescription to "Joan %1\$s. urtera",
    Strings.DatePickerHeadlineDescription to "Oraingo hautapena: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Bat ere ez",
    Strings.DatePickerTodayDescription to "Gaur",
    Strings.DatePickerYearPickerPaneTitle to "Urte-hautatzailea ikusgai dago",
    Strings.DateInputTitle to "Hautatu data bat",
    Strings.DateInputHeadline to "Idatzitako data",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Idatzitako data: %1\$s",
    Strings.DateInputNoInputDescription to "Bat ere ez",
    Strings.DateInputInvalidNotAllowed to "Ez da onartzen data: %1\$s",
    Strings.DateInputInvalidForPattern to "Data ez dator bat espero den ereduarekin: %1\$s",
    Strings.DateInputInvalidYearRange to "Espero den urte tartetik (%1\$s-%2\$s) kanpo dago data",
    Strings.DatePickerSwitchToCalendarMode to "Aldatu egutegiaren idazketa-metodora",
    Strings.DatePickerSwitchToInputMode to "Aldatu testua idazteko modura",
    Strings.DatePickerScrollToShowLaterYears to "Egin gora/behera etorkizuneko urteak erakusteko",
    Strings.DatePickerScrollToShowEarlierYears to "Egin gora/behera iraganeko urteak erakusteko",
    Strings.DateRangePickerTitle to "Hautatu datak",
    Strings.DateRangePickerStartHeadline to "Hasiera-data",
    Strings.DateRangePickerEndHeadline to "Amaiera-data",
    Strings.DateRangePickerScrollToShowNextMonth to "Egin gora/behera hurrengo hilabetea erakusteko",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Egin gora/behera aurreko hilabetea erakusteko",
    Strings.DateRangePickerDayInRange to "Barrutian",
    Strings.DateRangeInputTitle to "Idatzi datak",
    Strings.DateRangeInputInvalidRangeInput to "Idatzitako data tarteak ez du balio",
    Strings.BottomSheetPaneTitle to "Pantailaren behealdean ainguratutako orria",
    Strings.BottomSheetDragHandleDescription to "Arrastatzeko kontrol-puntua",
    Strings.BottomSheetPartialExpandDescription to "Tolestu pantailaren behealdean ainguratutako orria",
    Strings.BottomSheetDismissDescription to "Baztertu pantailaren behealdean ainguratutako orria",
    Strings.BottomSheetExpandDescription to "Zabaldu pantailaren behealdean ainguratutako orria",
    Strings.TooltipPaneDescription to "Aholkua",
    Strings.TooltipLongPressLabel to "Erakutsi aholkua",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Hautatu AM edo PM",
    Strings.TimePickerHourSelection to "Hautatu ordua",
    Strings.TimePickerMinuteSelection to "Hautatu minutuak",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d",
    Strings.TimePickerMinuteSuffix to "%1\$d minutu",
    Strings.TimePickerMinute to "Minutua",
    Strings.TimePickerHour to "Ordua",
    Strings.TimePickerMinuteTextField to "minutuetarako",
    Strings.TimePickerHourTextField to "ordurako",
)
