/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.kn() = mapOf(
    Strings.NavigationMenu to "ನ್ಯಾವಿಗೇಶನ್‌ ಮೆನು",
    Strings.ExposedDropdownMenu to "ಡ್ರಾಪ್‌ಡೌನ್ ಮೆನು",
    Strings.CloseDrawer to "ನ್ಯಾವಿಗೇಷನ್‌ ಮೆನು ಮುಚ್ಚಿರಿ",
    Strings.CloseSheet to "ಶೀಟ್ ಮುಚ್ಚಿರಿ",
    Strings.DefaultErrorMessage to "ಅಮಾನ್ಯ ಇನ್‌ಪುಟ್",
    Strings.SliderRangeStart to "ಶ್ರೇಣಿಯ ಪ್ರಾರಂಭ",
    Strings.SliderRangeEnd to "ಶ್ರೇಣಿಯ ಅಂತ್ಯ",
    Strings.Dialog to "ಡೈಲಾಗ್",
    Strings.MenuExpanded to "ವಿಸ್ತರಿಸಲಾಗಿದೆ",
    Strings.MenuCollapsed to "ಕುಗ್ಗಿಸಲಾಗಿದೆ",
    Strings.ToggleDropdownMenu to "ಡ್ರಾಪ್‌ಡೌನ್ ಮೆನುವನ್ನು ಟಾಗಲ್ ಮಾಡಿ",
    Strings.SnackbarDismiss to "ವಜಾಗೊಳಿಸಿ",
    Strings.SearchBarSearch to "ಹುಡುಕಿ",
    Strings.SuggestionsAvailable to "ಸಲಹೆಗಳನ್ನು ಕೆಳಗೆ ನೀಡಲಾಗಿದೆ",
    Strings.DatePickerTitle to "ದಿನಾಂಕ ಆಯ್ಕೆಮಾಡಿ",
    Strings.DatePickerHeadline to "ಆಯ್ಕೆಮಾಡಲಾದ ದಿನಾಂಕ",
    Strings.DatePickerSwitchToYearSelection to "ವರ್ಷವನ್ನು ಆಯ್ಕೆ ಮಾಡಲು ಬದಲಿಸಿ",
    Strings.DatePickerSwitchToDaySelection to "ವರ್ಷವನ್ನು ಆಯ್ಕೆಮಾಡಲು ಸ್ವೈಪ್ ಮಾಡಿ ಅಥವಾ ದಿನವನ್ನು ಆಯ್ಕೆಮಾಡಲು ಹಿಂತಿರುಗಲು ಟ್ಯಾಪ್ ಮಾಡಿ",
    Strings.DatePickerSwitchToNextMonth to "ಮುಂದಿನ ತಿಂಗಳಿಗೆ ಬದಲಿಸಿ",
    Strings.DatePickerSwitchToPreviousMonth to "ಹಿಂದಿನ ತಿಂಗಳಿಗೆ ಬದಲಿಸಿ",
    Strings.DatePickerNavigateToYearDescription to "%1\$s ವರ್ಷಕ್ಕೆ ನ್ಯಾವಿಗೇಟ್ ಮಾಡಿ",
    Strings.DatePickerHeadlineDescription to "ಪ್ರಸ್ತುತ ಆಯ್ಕೆ: %1\$s",
    Strings.DatePickerNoSelectionDescription to "ಯಾವುದೂ ಅಲ್ಲ",
    Strings.DatePickerTodayDescription to "ಇಂದು",
    Strings.DatePickerYearPickerPaneTitle to "ವರ್ಷದ ಪಿಕರ್ ಗೋಚರಿಸುತ್ತದೆ",
    Strings.DateInputTitle to "ದಿನಾಂಕ ಆಯ್ಕೆಮಾಡಿ",
    Strings.DateInputHeadline to "ನಮೂದಿಸಿದ ದಿನಾಂಕ",
    Strings.DateInputLabel to "ದಿನಾಂಕ",
    Strings.DateInputHeadlineDescription to "ನಮೂದಿಸಿದ ದಿನಾಂಕ: %1\$s",
    Strings.DateInputNoInputDescription to "ಯಾವುದೂ ಅಲ್ಲ",
    Strings.DateInputInvalidNotAllowed to "ದಿನಾಂಕವನ್ನು ಅನುಮತಿಸಲಾಗುವುದಿಲ್ಲ: %1\$s",
    Strings.DateInputInvalidForPattern to "ನಿರೀಕ್ಷಿಸಿದ ಪ್ಯಾಟರ್ನ್‌ನೊಂದಿಗೆ ದಿನಾಂಕ ಹೊಂದಾಣಿಕೆಯಾಗುತ್ತಿಲ್ಲ: %1\$s",
    Strings.DateInputInvalidYearRange to "ದಿನಾಂಕವು ನಿರೀಕ್ಷಿಸಿದ ವರ್ಷದ ವ್ಯಾಪ್ತಿಯನ್ನು ಮೀರಿದೆ %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "ಕ್ಯಾಲೆಂಡರ್ ಇನ್‌ಪುಟ್ ಮೋಡ್‌ಗೆ ಬದಲಿಸಿ",
    Strings.DatePickerSwitchToInputMode to "ಪಠ್ಯ ಇನ್‌ಪುಟ್ ಮೋಡ್‌ಗೆ ಬದಲಿಸಿ",
    Strings.DatePickerScrollToShowLaterYears to "ನಂತರದ ವರ್ಷಗಳನ್ನು ತೋರಿಸಲು ಸ್ಕ್ರಾಲ್ ಮಾಡಿ",
    Strings.DatePickerScrollToShowEarlierYears to "ಹಿಂದಿನ ವರ್ಷಗಳನ್ನು ತೋರಿಸಲು ಸ್ಕ್ರಾಲ್‌ ಮಾಡಿ",
    Strings.DateRangePickerTitle to "ದಿನಾಂಕಗಳನ್ನು ಆಯ್ಕೆಮಾಡಿ",
    Strings.DateRangePickerStartHeadline to "ಪ್ರಾರಂಭ ದಿನಾಂಕ",
    Strings.DateRangePickerEndHeadline to "ಅಂತಿಮ ದಿನಾಂಕ",
    Strings.DateRangePickerScrollToShowNextMonth to "ಮುಂದಿನ ತಿಂಗಳನ್ನು ತೋರಿಸಲು ಸ್ಕ್ರಾಲ್ ಮಾಡಿ",
    Strings.DateRangePickerScrollToShowPreviousMonth to "ಹಿಂದಿನ ತಿಂಗಳನ್ನು ತೋರಿಸಲು ಸ್ಕ್ರಾಲ್‌ ಮಾಡಿ",
    Strings.DateRangePickerDayInRange to "ವ್ಯಾಪ್ತಿಯಲ್ಲಿದೆ",
    Strings.DateRangeInputTitle to "ದಿನಾಂಕಗಳನ್ನು ನಮೂದಿಸಿ",
    Strings.DateRangeInputInvalidRangeInput to "ದಿನಾಂಕ ವ್ಯಾಪ್ತಿಯ ಇನ್‌ಪುಟ್ ಅಮಾನ್ಯವಾಗಿದೆ",
    Strings.BottomSheetPaneTitle to "ಕೆಳಭಾಗದ ಶೀಟ್",
    Strings.BottomSheetDragHandleDescription to "ಹ್ಯಾಂಡಲ್ ಡ್ರ್ಯಾಗ್ ಮಾಡಿ",
    Strings.BottomSheetPartialExpandDescription to "ಕೆಳಭಾಗದ ಶೀಟ್ ಅನ್ನು ಕುಗ್ಗಿಸಿ",
    Strings.BottomSheetDismissDescription to "ಕೆಳಭಾಗದ ಶೀಟ್ ಅನ್ನು ವಜಾಗೊಳಿಸಿ",
    Strings.BottomSheetExpandDescription to "ಕೆಳಭಾಗದ ಶೀಟ್ ಅನ್ನು ವಿಸ್ತರಿಸಿ",
    Strings.TooltipPaneDescription to "ಟೂಲ್‌ಟಿಪ್",
    Strings.TooltipLongPressLabel to "ಟೂಲ್‌ಟಿಪ್ ಅನ್ನು ತೋರಿಸಿ",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM ಅಥವಾ PM ಆಯ್ಕೆಮಾಡಿ",
    Strings.TimePickerHourSelection to "ಸಮಯವನ್ನು ಆಯ್ಕೆಮಾಡಿ",
    Strings.TimePickerMinuteSelection to "ನಿಮಿಷಗಳನ್ನು ಆಯ್ಕೆಮಾಡಿ",
    Strings.TimePickerHourSuffix to "%1\$d ಓ ಕ್ಲಾಕ್",
    Strings.TimePicker24HourSuffix to "%1\$d ಗಂಟೆ",
    Strings.TimePickerMinuteSuffix to "%1\$d ನಿಮಿಷಗಳು",
    Strings.TimePickerMinute to "ನಿಮಿಷ",
    Strings.TimePickerHour to "ಗಂಟೆ",
    Strings.TimePickerMinuteTextField to "ನಿಮಿಷಗಳವರೆಗೆ",
    Strings.TimePickerHourTextField to "ಗಂಟೆಯವರೆಗೆ",
)
