/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ar() = mapOf(
    Strings.NavigationMenu to "قائمة تنقل",
    Strings.ExposedDropdownMenu to "قائمة منسدلة",
    Strings.CloseDrawer to "إغلاق قائمة التنقل",
    Strings.CloseSheet to "إغلاق الورقة",
    Strings.DefaultErrorMessage to "إدخال غير صالح",
    Strings.SliderRangeStart to "بداية النطاق",
    Strings.SliderRangeEnd to "نهاية النطاق",
    Strings.Dialog to "مربّع حوار",
    Strings.MenuExpanded to "موسَّعة",
    Strings.MenuCollapsed to "مصغَّرة",
    Strings.ToggleDropdownMenu to "توسيع القائمة المنسدلة أو تصغيرها",
    Strings.SnackbarDismiss to "إغلاق",
    Strings.SnackbarPaneTitle to "تنبيه",
    Strings.SearchBarSearch to "شريط بحث",
    Strings.SuggestionsAvailable to "إليك الاقتراحات",
    Strings.DatePickerTitle to "اختيار تاريخ",
    Strings.DatePickerHeadline to "التاريخ المحدَّد",
    Strings.DatePickerSwitchToYearSelection to "التبديل لاختيار سنة",
    Strings.DatePickerSwitchToDaySelection to "مرِّر سريعًا لتحديد سنة، أو انقر للرجوع إلى تحديد يوم.",
    Strings.DatePickerSwitchToNextMonth to "التغيير إلى الشهر التالي",
    Strings.DatePickerSwitchToPreviousMonth to "التغيير إلى الشهر السابق",
    Strings.DatePickerNavigateToYearDescription to "‏الانتقال إلى سنة %1\$s",
    Strings.DatePickerHeadlineDescription to "‏الاختيار الحالي: %1\$s",
    Strings.DatePickerNoSelectionDescription to "بدون تاريخ",
    Strings.DatePickerTodayDescription to "اليوم",
    Strings.DatePickerYearPickerPaneTitle to "أداة اختيار السنوات مرئية",
    Strings.DateInputTitle to "اختيار تاريخ",
    Strings.DateInputHeadline to "التاريخ الذي تم إدخاله",
    Strings.DateInputLabel to "التاريخ",
    Strings.DateInputHeadlineDescription to "‏التاريخ الذي تم إدخاله: %1\$s",
    Strings.DateInputNoInputDescription to "بدون تاريخ",
    Strings.DateInputInvalidNotAllowed to "‏التاريخ غير مسموح به: %1\$s",
    Strings.DateInputInvalidForPattern to "‏لا يتوافق التاريخ مع النمط المتوقَّع: %1\$s",
    Strings.DateInputInvalidYearRange to "‏التاريخ خارج نطاق السنوات المتوقَّع: ‎%1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "التبديل إلى وضع \"الإدخال في التقويم\"",
    Strings.DatePickerSwitchToInputMode to "التبديل إلى \"وضع إدخال النص\"",
    Strings.DatePickerScrollToShowLaterYears to "انتقِل للأسفل أو للأعلى لإظهار السنوات التالية.",
    Strings.DatePickerScrollToShowEarlierYears to "انتقِل للأسفل أو للأعلى لإظهار السنوات السابقة.",
    Strings.DateRangePickerTitle to "اختيار التواريخ",
    Strings.DateRangePickerStartHeadline to "تاريخ البدء",
    Strings.DateRangePickerEndHeadline to "تاريخ الانتهاء",
    Strings.DateRangePickerScrollToShowNextMonth to "انتقِل للأسفل أو للأعلى لإظهار الشهر التالي.",
    Strings.DateRangePickerScrollToShowPreviousMonth to "انتقِل للأسفل أو للأعلى لإظهار الشهر السابق.",
    Strings.DateRangePickerDayInRange to "في النطاق",
    Strings.DateRangeInputTitle to "إدخال التواريخ",
    Strings.DateRangeInputInvalidRangeInput to "إدخال نطاق زمني غير صالح",
    Strings.BottomSheetPaneTitle to "بطاقة سفلية",
    Strings.BottomSheetDragHandleDescription to "مقبض السحب",
    Strings.BottomSheetPartialExpandDescription to "تصغير البطاقة السفلية",
    Strings.BottomSheetDismissDescription to "إغلاق البطاقة السفلية",
    Strings.BottomSheetExpandDescription to "توسيع البطاقة السفلية",
    Strings.FloatingToolbarCollapse to "تصغير شريط الأدوات",
    Strings.FloatingToolbarExpand to "توسيع شريط الأدوات",
    Strings.TooltipPaneDescription to "تلميح",
    Strings.TooltipLongPressLabel to "إظهار التلميح",
    Strings.TimePickerPM to "م",
    Strings.TimePickerAM to "ص",
    Strings.TimePickerPeriodToggle to "يُرجى اختيار \"ص\" أو \"م\".",
    Strings.TimePickerHourSelection to "اختيار الساعة",
    Strings.TimePickerMinuteSelection to "اختيار الدقائق",
    Strings.TimePickerHourSuffix to "‏الساعة %1\$d",
    Strings.TimePicker24HourSuffix to "‏%1\$d ساعة",
    Strings.TimePickerMinuteSuffix to "‏%1\$d دقيقة",
    Strings.TimePickerMinute to "دقيقة",
    Strings.TimePickerHour to "ساعة",
    Strings.TimePickerMinuteTextField to "الدقائق",
    Strings.TimePickerHourTextField to "الساعات",
    Strings.TimePickerToggleKeyboard to "التبديل إلى وضع إدخال النص لإدخال الوقت",
    Strings.TimePickerToggleTouch to "التبديل إلى وضع الساعة لإدخال الوقت",
    Strings.TimePickerDialogTitle to "اختيار الوقت",
    Strings.TimeInputDialogTitle to "إدخال الوقت",
    Strings.CloseRail to "إغلاق الشريط",
    Strings.WideNavigationRailPaneTitle to "شريط التنقّل",
)
