/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.da() = mapOf(
    Strings.NavigationMenu to "Navigationsmenu",
    Strings.ExposedDropdownMenu to "Rullemenu",
    Strings.CloseDrawer to "Luk navigationsmenuen",
    Strings.CloseSheet to "Luk arket",
    Strings.DefaultErrorMessage to "Ugyldigt input",
    Strings.SliderRangeStart to "Startinterval",
    Strings.SliderRangeEnd to "Slutinterval",
    Strings.Dialog to "Dialogboks",
    Strings.MenuExpanded to "Udvidet",
    Strings.MenuCollapsed to "Skjult",
    Strings.ToggleDropdownMenu to "Skift visningen af rullemenuen",
    Strings.SnackbarDismiss to "Afvis",
    Strings.SnackbarPaneTitle to "Underretning",
    Strings.SearchBarSearch to "Søg",
    Strings.SuggestionsAvailable to "Forslag nedenfor",
    Strings.DatePickerTitle to "Vælg dato",
    Strings.DatePickerHeadline to "Valgt dato",
    Strings.DatePickerSwitchToYearSelection to "Skift til valg af år",
    Strings.DatePickerSwitchToDaySelection to "Stryg for at vælge et år, eller tryk for at skifte tilbage til datovælgeren",
    Strings.DatePickerSwitchToNextMonth to "Skift til næste måned",
    Strings.DatePickerSwitchToPreviousMonth to "Skift til forrige måned",
    Strings.DatePickerNavigateToYearDescription to "Gå til år %1\$s",
    Strings.DatePickerHeadlineDescription to "Aktuelt valg: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ingen",
    Strings.DatePickerTodayDescription to "I dag",
    Strings.DatePickerYearPickerPaneTitle to "Årsvælgeren er synlig",
    Strings.DateInputTitle to "Vælg dato",
    Strings.DateInputHeadline to "Angivet dato",
    Strings.DateInputLabel to "Dato",
    Strings.DateInputHeadlineDescription to "Angivet dato: %1\$s",
    Strings.DateInputNoInputDescription to "Ingen",
    Strings.DateInputInvalidNotAllowed to "Datoen er ikke tilladt: %1\$s",
    Strings.DateInputInvalidForPattern to "Datoen svarer ikke til det forventede format: %1\$s",
    Strings.DateInputInvalidYearRange to "Datoen er uden for det forventede årsinterval: %1\$s-%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Skift til input-tilstand for kalender",
    Strings.DatePickerSwitchToInputMode to "Skift til input-tilstand for tekst",
    Strings.DatePickerScrollToShowLaterYears to "Rul for at se senere år",
    Strings.DatePickerScrollToShowEarlierYears to "Rul for at se tidligere år",
    Strings.DateRangePickerTitle to "Vælg datoer",
    Strings.DateRangePickerStartHeadline to "Startdato",
    Strings.DateRangePickerEndHeadline to "Slutdato",
    Strings.DateRangePickerScrollToShowNextMonth to "Rul for at se næste måned",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Rul for at se forrige måned",
    Strings.DateRangePickerDayInRange to "Inden for de valgte dage",
    Strings.DateRangeInputTitle to "Angiv datoer",
    Strings.DateRangeInputInvalidRangeInput to "Det angivne datointerval er ugyldigt",
    Strings.BottomSheetPaneTitle to "Felt i bunden",
    Strings.BottomSheetDragHandleDescription to "Håndtag",
    Strings.BottomSheetPartialExpandDescription to "Skjul felt i bunden",
    Strings.BottomSheetDismissDescription to "Luk felt i bunden",
    Strings.BottomSheetExpandDescription to "Udvid felt i bunden",
    Strings.FloatingToolbarCollapse to "Skjul værktøjslinjen",
    Strings.FloatingToolbarExpand to "Udvid værktøjslinjen",
    Strings.TooltipPaneDescription to "Værktøjstip",
    Strings.TooltipLongPressLabel to "Se værktøjstip",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Vælg AM eller PM",
    Strings.TimePickerHourSelection to "Vælg time",
    Strings.TimePickerMinuteSelection to "Vælg minutter",
    Strings.TimePickerHourSuffix to "kl. %1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d timer",
    Strings.TimePickerMinuteSuffix to "%1\$d minutter",
    Strings.TimePickerMinute to "Minut",
    Strings.TimePickerHour to "Time",
    Strings.TimePickerMinuteTextField to "til minutter",
    Strings.TimePickerHourTextField to "til timer",
    Strings.TimePickerToggleKeyboard to "Skift til input-tilstand for tekst for at angive tidspunkt",
    Strings.TimePickerToggleTouch to "Skift til urtilstand for at angive tidspunkt",
    Strings.TimePickerDialogTitle to "Vælg tidspunkt",
    Strings.TimeInputDialogTitle to "Angiv tidspunkt",
    Strings.CloseRail to "Luk bjælke",
    Strings.WideNavigationRailPaneTitle to "Navigationsbjælke",
)
