/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.gu() = mapOf(
    Strings.NavigationMenu to "નૅવિગેશન મેનૂ",
    Strings.ExposedDropdownMenu to "ડ્રૉપડાઉન મેનૂ",
    Strings.CloseDrawer to "નૅવિગેશન મેનૂ બંધ કરો",
    Strings.CloseSheet to "શીટ બંધ કરો",
    Strings.DefaultErrorMessage to "અમાન્ય ઇનપુટ",
    Strings.SliderRangeStart to "રેંજની શરૂઆત",
    Strings.SliderRangeEnd to "રેંજની સમાપ્તિ",
    Strings.Dialog to "સંવાદ",
    Strings.MenuExpanded to "મોટી કરેલી",
    Strings.MenuCollapsed to "નાની કરેલી",
    Strings.ToggleDropdownMenu to "ડ્રૉપડાઉન મેનૂ ટૉગલ કરો",
    Strings.SnackbarDismiss to "છોડી દો",
    Strings.SnackbarPaneTitle to "અલર્ટ",
    Strings.SearchBarSearch to "શોધો",
    Strings.SuggestionsAvailable to "સૂચનો નીચે છે",
    Strings.DatePickerTitle to "તારીખ પસંદ કરો",
    Strings.DatePickerHeadline to "પસંદ કરેલી તારીખ",
    Strings.DatePickerSwitchToYearSelection to "વર્ષ પસંદ કરવાના વિકલ્પ પર સ્વિચ કરો",
    Strings.DatePickerSwitchToDaySelection to "વર્ષ પસંદ કરવા માટે સ્વાઇપ કરો અથવા દિવસની પસંદગી પર પાછા સ્વિચ કરવા માટે ટૅપ કરો",
    Strings.DatePickerSwitchToNextMonth to "બદલીને આગલો મહિનો પસંદ કરો",
    Strings.DatePickerSwitchToPreviousMonth to "બદલીને પાછલો મહિનો પસંદ કરો",
    Strings.DatePickerNavigateToYearDescription to "વર્ષ %1\$s પર નૅવિગેટ કરો",
    Strings.DatePickerHeadlineDescription to "હાલની પસંદગી: %1\$s",
    Strings.DatePickerNoSelectionDescription to "એકપણ નહીં",
    Strings.DatePickerTodayDescription to "આજે",
    Strings.DatePickerYearPickerPaneTitle to "વર્ષ માટેનું પિકર દૃશ્યમાન છે",
    Strings.DateInputTitle to "તારીખ પસંદ કરો",
    Strings.DateInputHeadline to "દાખલ કરેલી તારીખ",
    Strings.DateInputLabel to "તારીખ",
    Strings.DateInputHeadlineDescription to "દાખલ કરેલી તારીખ: %1\$s",
    Strings.DateInputNoInputDescription to "એકપણ નહીં",
    Strings.DateInputInvalidNotAllowed to "આ તારીખની મંજૂરી નથી: %1\$s",
    Strings.DateInputInvalidForPattern to "તારીખ અપેક્ષિત પૅટર્ન સાથે મેળ ખાતી નથી: %1\$s",
    Strings.DateInputInvalidYearRange to "અપેક્ષિત વર્ષની શ્રેણી %1\$s - %2\$sની બહારની તારીખ",
    Strings.DatePickerSwitchToCalendarMode to "કૅલેન્ડર ઇનપુટ મોડ પર સ્વિચ કરો",
    Strings.DatePickerSwitchToInputMode to "ટેક્સ્ટ ઇનપુટ મોડ પર સ્વિચ કરો",
    Strings.DatePickerScrollToShowLaterYears to "પછીના વર્ષો બતાવવા માટે સ્ક્રોલ કરો",
    Strings.DatePickerScrollToShowEarlierYears to "અગાઉના વર્ષો બતાવવા માટે સ્ક્રોલ કરો",
    Strings.DateRangePickerTitle to "તારીખો પસંદ કરો",
    Strings.DateRangePickerStartHeadline to "પ્રારંભ તારીખ",
    Strings.DateRangePickerEndHeadline to "સમાપ્તિ તારીખ",
    Strings.DateRangePickerScrollToShowNextMonth to "આગલો મહિનો બતાવવા માટે સ્ક્રોલ કરો",
    Strings.DateRangePickerScrollToShowPreviousMonth to "પાછલો મહિનો બતાવવા માટે સ્ક્રોલ કરો",
    Strings.DateRangePickerDayInRange to "રેન્જમાં છે",
    Strings.DateRangeInputTitle to "તારીખો દાખલ કરો",
    Strings.DateRangeInputInvalidRangeInput to "તારીખની શ્રેણીનું અમાન્ય ઇનપુટ",
    Strings.BottomSheetPaneTitle to "બોટમ શીટ",
    Strings.BottomSheetDragHandleDescription to "ઑબ્જેક્ટ ખેંચવાનું હૅન્ડલ",
    Strings.BottomSheetPartialExpandDescription to "બોટમ શીટ નાની કરો",
    Strings.BottomSheetDismissDescription to "બોટમ શીટ છોડી દો",
    Strings.BottomSheetExpandDescription to "બોટમ શીટ મોટી કરો",
    Strings.FloatingToolbarCollapse to "ટૂલબાર નાનો કરો",
    Strings.FloatingToolbarExpand to "ટૂલબાર મોટો કરો",
    Strings.TooltipPaneDescription to "ટૂલટિપ",
    Strings.TooltipLongPressLabel to "ટૂલટિપ બતાવો",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM કે PM પસંદ કરો",
    Strings.TimePickerHourSelection to "કલાક પસંદ કરો",
    Strings.TimePickerMinuteSelection to "મિનિટ પસંદ કરો",
    Strings.TimePickerHourSuffix to "%1\$d વાગ્યે",
    Strings.TimePicker24HourSuffix to "%1\$d કલાક",
    Strings.TimePickerMinuteSuffix to "%1\$d મિનિટ",
    Strings.TimePickerMinute to "મિનિટ",
    Strings.TimePickerHour to "કલાક",
    Strings.TimePickerMinuteTextField to "મિનિટ માટે",
    Strings.TimePickerHourTextField to "કલાક માટે",
    Strings.TimePickerToggleKeyboard to "સમય દાખલ કરવા માટે ટેક્સ્ટ ઇનપુટ મોડ પર સ્વિચ કરો",
    Strings.TimePickerToggleTouch to "સમય દાખલ કરવા માટે ક્લૉક મોડ પર સ્વિચ કરો",
    Strings.TimePickerDialogTitle to "સમય પસંદ કરો",
    Strings.TimeInputDialogTitle to "સમય દાખલ કરો",
    Strings.CloseRail to "રેલ બંધ કરો",
    Strings.WideNavigationRailPaneTitle to "નૅવિગેશન રેલ",
)
