/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.my() = mapOf(
    Strings.NavigationMenu to "လမ်းညွှန် မီနူး",
    Strings.ExposedDropdownMenu to "ဆွဲချမီနူး",
    Strings.CloseDrawer to "လမ်းညွှန် မီနူး ပိတ်ရန်",
    Strings.CloseSheet to "စာမျက်နှာ ပိတ်ရန်",
    Strings.DefaultErrorMessage to "ထည့်သွင်းမှု မမှန်ကန်ပါ",
    Strings.SliderRangeStart to "အပိုင်းအခြား အစ",
    Strings.SliderRangeEnd to "အပိုင်းအခြား အဆုံး",
    Strings.Dialog to "ဒိုင်ယာလော့",
    Strings.MenuExpanded to "ချဲ့ထားသည်",
    Strings.MenuCollapsed to "ချုံ့ထားသည်",
    Strings.ToggleDropdownMenu to "ဆွဲချမီနူးကို ပြောင်းရန်",
    Strings.SnackbarDismiss to "ပယ်ရန်",
    Strings.SnackbarPaneTitle to "သတိပေးချက်",
    Strings.SearchBarSearch to "ရှာရန်",
    Strings.SuggestionsAvailable to "အကြံပြုချက်များသည် အောက်တွင်ရှိသည်",
    Strings.DatePickerTitle to "ရက်စွဲရွေးရန်",
    Strings.DatePickerHeadline to "ရွေးထားသည့် ရက်စွဲ",
    Strings.DatePickerSwitchToYearSelection to "နှစ်ရွေးခြင်းသို့ ပြောင်းရန်",
    Strings.DatePickerSwitchToDaySelection to "ခုနှစ်ရွေးချယ်ရန် ပွတ်ဆွဲပါ (သို့) ရက်ရွေးချယ်ခြင်းသို့ ပြန်ရန် တို့ပါ",
    Strings.DatePickerSwitchToNextMonth to "နောက်လသို့ ပြောင်းရန်",
    Strings.DatePickerSwitchToPreviousMonth to "ယခင်လသို့ ပြောင်းရန်",
    Strings.DatePickerNavigateToYearDescription to "%1\$s ခုနှစ်သို့ သွားရန်",
    Strings.DatePickerHeadlineDescription to "လက်ရှိ ရွေးချယ်မှု- %1\$s",
    Strings.DatePickerNoSelectionDescription to "မရှိ",
    Strings.DatePickerTodayDescription to "ယနေ့",
    Strings.DatePickerYearPickerPaneTitle to "ခုနှစ်ရွေးချယ်ရေးစနစ်ကို မြင်ရသည်",
    Strings.DateInputTitle to "ရက်စွဲရွေးရန်",
    Strings.DateInputHeadline to "ထည့်ထားသော ရက်စွဲ",
    Strings.DateInputLabel to "ရက်စွဲ",
    Strings.DateInputHeadlineDescription to "ထည့်ထားသော ရက်စွဲ- %1\$s",
    Strings.DateInputNoInputDescription to "မရှိ",
    Strings.DateInputInvalidNotAllowed to "ရက်စွဲကို ခွင့်ပြုမထားပါ- %1\$s",
    Strings.DateInputInvalidForPattern to "ရက်စွဲသည် မျှော်မှန်းထားသော ပုံစံနှင့် မကိုက်ညီပါ- %1\$s",
    Strings.DateInputInvalidYearRange to "ရက်စွဲသည် မျှော်မှန်းထားသော နှစ်အပိုင်းအခြား %1\$s - %2\$s တွင် မပါဝင်ပါ",
    Strings.DatePickerSwitchToCalendarMode to "ပြက္ခဒိန် လက်ကွက်ထည့်သွင်းနည်းသို့ ပြောင်းရန်",
    Strings.DatePickerSwitchToInputMode to "စာရိုက်နည်းသို့ ပြောင်းရန်",
    Strings.DatePickerScrollToShowLaterYears to "နောက်ပိုင်းနှစ်များ ပြရန် လှိမ့်ပါ",
    Strings.DatePickerScrollToShowEarlierYears to "ယခင်နှစ်များ ပြရန် လှိမ့်ပါ",
    Strings.DateRangePickerTitle to "ရက်စွဲများရွေးပါ",
    Strings.DateRangePickerStartHeadline to "စတင်ရက်",
    Strings.DateRangePickerEndHeadline to "ပြီးဆုံးရက်",
    Strings.DateRangePickerScrollToShowNextMonth to "လာမည့်လကို ပြရန် လှိမ့်ပါ",
    Strings.DateRangePickerScrollToShowPreviousMonth to "ယခင်လကို ပြရန် လှိမ့်ပါ",
    Strings.DateRangePickerDayInRange to "အပိုင်းအခြားအတွင်း",
    Strings.DateRangeInputTitle to "ရက်စွဲများထည့်ပါ",
    Strings.DateRangeInputInvalidRangeInput to "ဒေတာအပိုင်းအခြား ထည့်သွင်းမှု မမှန်ပါ",
    Strings.BottomSheetPaneTitle to "အောက်ခြေအပိုဆောင်း စာမျက်နှာ",
    Strings.BottomSheetDragHandleDescription to "ဖိဆွဲအထိန်း",
    Strings.BottomSheetPartialExpandDescription to "အောက်ခြေအပိုဆောင်း စာမျက်နှာကို ချုံ့သည်",
    Strings.BottomSheetDismissDescription to "အောက်ခြေအပိုဆောင်း စာမျက်နှာကို ပယ်သည်",
    Strings.BottomSheetExpandDescription to "အောက်ခြေအပိုဆောင်း စာမျက်နှာကို ချဲ့သည်",
    Strings.FloatingToolbarCollapse to "ကိရိယာဘား ချုံ့ရန်",
    Strings.FloatingToolbarExpand to "ကိရိယာဘား ချဲ့ရန်",
    Strings.TooltipPaneDescription to "အကြံပြုချက်ပြ ပေါ့အပ် ဝင်းဒိုး",
    Strings.TooltipLongPressLabel to "အကြံပြုချက်ပြ ပေါ့အပ်ဝင်းဒိုး ပြရန်",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "AM (သို့) PM ရွေးရန်",
    Strings.TimePickerHourSelection to "နာရီ ရွေးရန်",
    Strings.TimePickerMinuteSelection to "မိနစ်များရွေးပါ",
    Strings.TimePickerHourSuffix to "%1\$d နာရီ",
    Strings.TimePicker24HourSuffix to "%1\$d နာရီ",
    Strings.TimePickerMinuteSuffix to "%1\$d မိနစ်",
    Strings.TimePickerMinute to "မိနစ်",
    Strings.TimePickerHour to "နာရီ",
    Strings.TimePickerMinuteTextField to "မိနစ်ကြာ",
    Strings.TimePickerHourTextField to "နာရီကြာ",
    Strings.TimePickerToggleKeyboard to "အချိန်ထည့်သွင်းမှုအတွက် စာရိုက်နည်းသို့ ပြောင်းရန်",
    Strings.TimePickerToggleTouch to "အချိန်ထည့်သွင်းမှုအတွက် နာရီမုဒ်သို့ ပြောင်းရန်",
    Strings.TimePickerDialogTitle to "အချိန်ရွေးပါ",
    Strings.TimeInputDialogTitle to "အချိန်ထည့်ပါ",
    Strings.CloseRail to "ဘားပိတ်ရန်",
    Strings.WideNavigationRailPaneTitle to "လမ်းကြောင်းပြဘား",
)
