/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.sr() = mapOf(
    Strings.NavigationMenu to "Мени за навигацију",
    Strings.ExposedDropdownMenu to "Падајући мени",
    Strings.CloseDrawer to "Затвори мени за навигацију",
    Strings.CloseSheet to "Затворите табелу",
    Strings.DefaultErrorMessage to "Унос је неважећи",
    Strings.SliderRangeStart to "Почетак опсега",
    Strings.SliderRangeEnd to "Крај опсега",
    Strings.Dialog to "Дијалог",
    Strings.MenuExpanded to "Проширено је",
    Strings.MenuCollapsed to "Скупљено је",
    Strings.ToggleDropdownMenu to "Прекидач за падајући мени",
    Strings.SnackbarDismiss to "Одбаци",
    Strings.SnackbarPaneTitle to "Обавештење",
    Strings.SearchBarSearch to "Претрага",
    Strings.SuggestionsAvailable to "Предлози су у наставку",
    Strings.DatePickerTitle to "Изаберите датум",
    Strings.DatePickerHeadline to "Изабрани датум",
    Strings.DatePickerSwitchToYearSelection to "Пређите на избор године",
    Strings.DatePickerSwitchToDaySelection to "Превуците да бисте изабрали годину или додирните да бисте се вратили на избор дана",
    Strings.DatePickerSwitchToNextMonth to "Пређите на следећи месец",
    Strings.DatePickerSwitchToPreviousMonth to "Пређите на претходни месец",
    Strings.DatePickerNavigateToYearDescription to "Идите на годину: %1\$s",
    Strings.DatePickerHeadlineDescription to "Актуелни избор: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ништа",
    Strings.DatePickerTodayDescription to "Данас",
    Strings.DatePickerYearPickerPaneTitle to "Видљив бирач година",
    Strings.DateInputTitle to "Изаберите датум",
    Strings.DateInputHeadline to "Унети датум",
    Strings.DateInputLabel to "Датум",
    Strings.DateInputHeadlineDescription to "Унети датум: %1\$s",
    Strings.DateInputNoInputDescription to "Ништа",
    Strings.DateInputInvalidNotAllowed to "Датум није дозвољен: %1\$s",
    Strings.DateInputInvalidForPattern to "Датум не одговара очекиваном шаблону: %1\$s",
    Strings.DateInputInvalidYearRange to "Датум је изван очекиваног опсега година %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Пређите на режим уноса у Календару",
    Strings.DatePickerSwitchToInputMode to "Пређите на режим уноса текста",
    Strings.DatePickerScrollToShowLaterYears to "Скролујте да би се приказале касније године",
    Strings.DatePickerScrollToShowEarlierYears to "Скролујте да би се приказале раније године",
    Strings.DateRangePickerTitle to "Изаберите датуме",
    Strings.DateRangePickerStartHeadline to "Датум почетка",
    Strings.DateRangePickerEndHeadline to "Датум завршетка",
    Strings.DateRangePickerScrollToShowNextMonth to "Померајте да би се приказао следећи месец",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Померајте да би се приказао претходни месец",
    Strings.DateRangePickerDayInRange to "У опсегу",
    Strings.DateRangeInputTitle to "Унесите датуме",
    Strings.DateRangeInputInvalidRangeInput to "Унос опсега датума је неважећи",
    Strings.BottomSheetPaneTitle to "Доња табела",
    Strings.BottomSheetDragHandleDescription to "Идентификатор за превлачење",
    Strings.BottomSheetPartialExpandDescription to "Скупите доњу табелу",
    Strings.BottomSheetDismissDescription to "Одбаците доњу табелу",
    Strings.BottomSheetExpandDescription to "Проширите доњу табелу",
    Strings.FloatingToolbarCollapse to "Скупите траку с алаткама",
    Strings.FloatingToolbarExpand to "Проширите траку с алаткама",
    Strings.TooltipPaneDescription to "Објашњење",
    Strings.TooltipLongPressLabel to "Прикажите објашњење",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Изаберите пре подне или по подне",
    Strings.TimePickerHourSelection to "Изаберите сат",
    Strings.TimePickerMinuteSelection to "Изаберите минуте",
    Strings.TimePickerHourSuffix to "%1\$d с",
    Strings.TimePicker24HourSuffix to "%1\$d с",
    Strings.TimePickerMinuteSuffix to "%1\$d мин",
    Strings.TimePickerMinute to "Минут",
    Strings.TimePickerHour to "Сат",
    Strings.TimePickerMinuteTextField to "за минуте",
    Strings.TimePickerHourTextField to "за сате",
    Strings.TimePickerToggleKeyboard to "Пређите у режим уноса текста ради уноса времена",
    Strings.TimePickerToggleTouch to "Пређите у режим сата ради уноса времена",
    Strings.TimePickerDialogTitle to "Изаберите време",
    Strings.TimeInputDialogTitle to "Унесите време",
    Strings.CloseRail to "Затворите траку",
    Strings.WideNavigationRailPaneTitle to "Трака за навигацију",
)
