/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.GroupInfo;
import androidx.compose.runtime.JoinedKey;
import androidx.compose.runtime.KeyInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0004J\u0016\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0006J\u001e\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006J\u0016\u0010-\u001a\u00020'2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006J\u000e\u0010.\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0004J\u0016\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J\u000e\u00102\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0004R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012RW\u0010\u0013\u001a>\u0012\u0004\u0012\u00020\u0001\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\u0014j\b\u0012\u0004\u0012\u00020\u0004`\u00150\u000ej\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\u0014j\b\u0012\u0004\u0012\u00020\u0004`\u0015`\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Landroidx/compose/runtime/Pending;", "", "keyInfos", "", "Landroidx/compose/runtime/KeyInfo;", "startIndex", "", "(Ljava/util/List;I)V", "groupIndex", "getGroupIndex", "()I", "setGroupIndex", "(I)V", "groupInfos", "Ljava/util/HashMap;", "Landroidx/compose/runtime/GroupInfo;", "Lkotlin/collections/HashMap;", "getKeyInfos", "()Ljava/util/List;", "keyMap", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getKeyMap", "()Ljava/util/HashMap;", "keyMap$delegate", "Lkotlin/Lazy;", "getStartIndex", "used", "", "getUsed", "usedKeys", "getNext", "key", "dataKey", "nodePositionOf", "keyInfo", "recordUsed", "", "registerInsert", "", "insertIndex", "registerMoveNode", "from", "to", "count", "registerMoveSlot", "slotPositionOf", "updateNodeCount", "group", "newCount", "updatedNodeCountOf", "runtime"})
final class Pending {
    @NotNull
    private final List<KeyInfo> keyInfos;
    private final int startIndex;
    private int groupIndex;
    @NotNull
    private final List<KeyInfo> usedKeys;
    @NotNull
    private final HashMap<Integer, GroupInfo> groupInfos;
    @NotNull
    private final Lazy keyMap$delegate;

    /*
     * WARNING - void declaration
     */
    public Pending(@NotNull List<KeyInfo> keyInfos, int startIndex) {
        void $this$groupInfos_u24lambda_u2d1;
        Intrinsics.checkNotNullParameter(keyInfos, (String)"keyInfos");
        this.keyInfos = keyInfos;
        this.startIndex = startIndex;
        if (!(this.startIndex >= 0)) {
            boolean $i$a$-require-Pending$22 = false;
            String $i$a$-require-Pending$22 = "Invalid start index";
            throw new IllegalArgumentException($i$a$-require-Pending$22.toString());
        }
        this.usedKeys = new ArrayList();
        Pending $i$a$-require-Pending$22 = this;
        Pending pending = this;
        boolean bl = false;
        int runningNodeIndex = 0;
        HashMap result2 = new HashMap();
        int n = $this$groupInfos_u24lambda_u2d1.keyInfos.size();
        for (int index = 0; index < n; ++index) {
            KeyInfo keyInfo = $this$groupInfos_u24lambda_u2d1.keyInfos.get(index);
            ((Map)result2).put(keyInfo.getLocation(), new GroupInfo(index, runningNodeIndex, keyInfo.getNodes()));
            runningNodeIndex += keyInfo.getNodes();
        }
        pending.groupInfos = result2;
        this.keyMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashMap<Object, LinkedHashSet<KeyInfo>>>(this){
            final /* synthetic */ Pending this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HashMap<Object, LinkedHashSet<KeyInfo>> invoke() {
                HashMap hashMap = ComposerKt.access$multiMap();
                Pending pending = this.this$0;
                HashMap it = hashMap;
                boolean bl = false;
                int n = pending.getKeyInfos().size();
                for (int index = 0; index < n; ++index) {
                    KeyInfo keyInfo = pending.getKeyInfos().get(index);
                    ComposerKt.access$put(it, ComposerKt.access$getJoinedKey(keyInfo), keyInfo);
                }
                return hashMap;
            }
        }));
    }

    @NotNull
    public final List<KeyInfo> getKeyInfos() {
        return this.keyInfos;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getGroupIndex() {
        return this.groupIndex;
    }

    public final void setGroupIndex(int n) {
        this.groupIndex = n;
    }

    @NotNull
    public final HashMap<Object, LinkedHashSet<KeyInfo>> getKeyMap() {
        Lazy lazy = this.keyMap$delegate;
        return (HashMap)lazy.getValue();
    }

    @Nullable
    public final KeyInfo getNext(int key, @Nullable Object dataKey) {
        Object joinedKey = dataKey != null ? new JoinedKey(key, dataKey) : Integer.valueOf(key);
        return (KeyInfo)ComposerKt.access$pop(this.getKeyMap(), joinedKey);
    }

    public final boolean recordUsed(@NotNull KeyInfo keyInfo) {
        Intrinsics.checkNotNullParameter((Object)keyInfo, (String)"keyInfo");
        return this.usedKeys.add(keyInfo);
    }

    @NotNull
    public final List<KeyInfo> getUsed() {
        return this.usedKeys;
    }

    public final void registerMoveSlot(int from, int to) {
        block5: {
            block4: {
                if (from <= to) break block4;
                Collection<GroupInfo> collection = this.groupInfos.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"groupInfos.values");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GroupInfo group = (GroupInfo)element$iv;
                    boolean bl = false;
                    int position = group.getSlotIndex();
                    if (position == from) {
                        group.setSlotIndex(to);
                        continue;
                    }
                    boolean bl2 = to <= position ? position < from : false;
                    if (!bl2) continue;
                    group.setSlotIndex(position + 1);
                }
                break block5;
            }
            if (to <= from) break block5;
            Collection<GroupInfo> collection = this.groupInfos.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"groupInfos.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GroupInfo group = (GroupInfo)element$iv;
                boolean bl = false;
                int position = group.getSlotIndex();
                if (position == from) {
                    group.setSlotIndex(to);
                    continue;
                }
                boolean bl3 = from + 1 <= position ? position < to : false;
                if (!bl3) continue;
                group.setSlotIndex(position - 1);
            }
        }
    }

    public final void registerMoveNode(int from, int to, int count) {
        block5: {
            block4: {
                if (from <= to) break block4;
                Collection<GroupInfo> collection = this.groupInfos.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"groupInfos.values");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GroupInfo group = (GroupInfo)element$iv;
                    boolean bl = false;
                    int position = group.getNodeIndex();
                    boolean bl2 = from <= position ? position < from + count : false;
                    if (bl2) {
                        group.setNodeIndex(to + (position - from));
                        continue;
                    }
                    boolean bl3 = to <= position ? position < from : false;
                    if (!bl3) continue;
                    group.setNodeIndex(position + count);
                }
                break block5;
            }
            if (to <= from) break block5;
            Collection<GroupInfo> collection = this.groupInfos.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"groupInfos.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GroupInfo group = (GroupInfo)element$iv;
                boolean bl = false;
                int position = group.getNodeIndex();
                boolean bl4 = from <= position ? position < from + count : false;
                if (bl4) {
                    group.setNodeIndex(to + (position - from));
                    continue;
                }
                boolean bl5 = from + 1 <= position ? position < to : false;
                if (!bl5) continue;
                group.setNodeIndex(position - count);
            }
        }
    }

    public final void registerInsert(@NotNull KeyInfo keyInfo, int insertIndex) {
        Intrinsics.checkNotNullParameter((Object)keyInfo, (String)"keyInfo");
        ((Map)this.groupInfos).put(keyInfo.getLocation(), new GroupInfo(-1, insertIndex, 0));
    }

    public final boolean updateNodeCount(int group, int newCount) {
        GroupInfo groupInfo = this.groupInfos.get(group);
        if (groupInfo != null) {
            int index = groupInfo.getNodeIndex();
            int difference = newCount - groupInfo.getNodeCount();
            groupInfo.setNodeCount(newCount);
            if (difference != 0) {
                Collection<GroupInfo> collection = this.groupInfos.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"groupInfos.values");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int newIndex;
                    GroupInfo childGroupInfo = (GroupInfo)element$iv;
                    boolean bl = false;
                    if (childGroupInfo.getNodeIndex() < index || Intrinsics.areEqual((Object)childGroupInfo, (Object)groupInfo) || (newIndex = childGroupInfo.getNodeIndex() + difference) < 0) continue;
                    childGroupInfo.setNodeIndex(newIndex);
                }
            }
            return true;
        }
        return false;
    }

    public final int slotPositionOf(@NotNull KeyInfo keyInfo) {
        Intrinsics.checkNotNullParameter((Object)keyInfo, (String)"keyInfo");
        GroupInfo groupInfo = this.groupInfos.get(keyInfo.getLocation());
        return groupInfo != null ? groupInfo.getSlotIndex() : -1;
    }

    public final int nodePositionOf(@NotNull KeyInfo keyInfo) {
        Intrinsics.checkNotNullParameter((Object)keyInfo, (String)"keyInfo");
        GroupInfo groupInfo = this.groupInfos.get(keyInfo.getLocation());
        return groupInfo != null ? groupInfo.getNodeIndex() : -1;
    }

    public final int updatedNodeCountOf(@NotNull KeyInfo keyInfo) {
        Intrinsics.checkNotNullParameter((Object)keyInfo, (String)"keyInfo");
        GroupInfo groupInfo = this.groupInfos.get(keyInfo.getLocation());
        return groupInfo != null ? groupInfo.getNodeCount() : keyInfo.getNodes();
    }
}

