/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.KeyInfo;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020\u0006J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020=J\u000e\u0010?\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0006J\u0006\u0010@\u001a\u00020=J\u0006\u0010A\u001a\u00020=J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CJO\u0010E\u001a\u00020=2\u0006\u0010F\u001a\u00020\u000628\u0010G\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(;\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\bI\u0012\b\bJ\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020=0HH\u0000\u00a2\u0006\u0002\bLJ\u0010\u0010M\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u0010\u0010N\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020\u0006J\u0018\u0010N\u001a\u0004\u0018\u00010\u00012\u0006\u0010F\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u00109\u001a\u00020:J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010O\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010P\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0006J\b\u0010Q\u001a\u0004\u0018\u00010\u0001J\u0010\u0010R\u001a\u0004\u0018\u00010\u00012\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010S\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010T\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010U\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0006J\u0006\u0010V\u001a\u00020\u0006J\u0006\u0010W\u001a\u00020=J\u0006\u0010X\u001a\u00020=J\u0006\u0010Y\u001a\u00020=J\b\u0010Z\u001a\u00020[H\u0016J\u0016\u0010\\\u001a\u0004\u0018\u00010\u0001*\u00020!2\u0006\u0010;\u001a\u00020\u0006H\u0002J\u0016\u0010R\u001a\u0004\u0018\u00010\u0001*\u00020!2\u0006\u0010;\u001a\u00020\u0006H\u0002J\u0016\u0010]\u001a\u0004\u0018\u00010\u0001*\u00020!2\u0006\u0010;\u001a\u00020\u0006H\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\tR\u0011\u0010\u001c\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\tR\u0011\u0010\u001e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\tR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0011\u0010(\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\tR\u001e\u0010+\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\tR\u0011\u0010-\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\tR\u0011\u0010/\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\tR\u0011\u00101\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\tR\u0018\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000104X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00105R\u000e\u00106\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006^"}, d2={"Landroidx/compose/runtime/SlotReader;", "", "table", "Landroidx/compose/runtime/SlotTable;", "(Landroidx/compose/runtime/SlotTable;)V", "<set-?>", "", "currentEnd", "getCurrentEnd", "()I", "currentGroup", "getCurrentGroup", "currentSlot", "currentSlotEnd", "emptyCount", "groupAux", "getGroupAux", "()Ljava/lang/Object;", "groupEnd", "getGroupEnd", "groupKey", "getGroupKey", "groupNode", "getGroupNode", "groupObjectKey", "getGroupObjectKey", "groupSize", "getGroupSize", "groupSlotCount", "getGroupSlotCount", "groupSlotIndex", "getGroupSlotIndex", "groups", "", "groupsSize", "inEmpty", "", "getInEmpty", "()Z", "isGroupEnd", "isNode", "nodeCount", "getNodeCount", "parent", "getParent", "parentNodes", "getParentNodes", "size", "getSize", "slot", "getSlot", "slots", "", "[Ljava/lang/Object;", "slotsSize", "getTable$runtime", "()Landroidx/compose/runtime/SlotTable;", "anchor", "Landroidx/compose/runtime/Anchor;", "index", "beginEmpty", "", "close", "containsMark", "endEmpty", "endGroup", "extractKeys", "", "Landroidx/compose/runtime/KeyInfo;", "forEachData", "group", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "data", "forEachData$runtime", "get", "groupGet", "hasMark", "hasObjectKey", "next", "node", "parentOf", "reposition", "restoreParent", "skipGroup", "skipToGroupEnd", "startGroup", "startNode", "toString", "", "aux", "objectKey", "runtime"})
public final class SlotReader {
    @NotNull
    private final SlotTable table;
    @NotNull
    private final int[] groups;
    private final int groupsSize;
    @NotNull
    private final Object[] slots;
    private final int slotsSize;
    private int currentGroup;
    private int currentEnd;
    private int parent;
    private int emptyCount;
    private int currentSlot;
    private int currentSlotEnd;

    public SlotReader(@NotNull SlotTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.groups = this.table.getGroups();
        this.groupsSize = this.table.getGroupsSize();
        this.slots = this.table.getSlots();
        this.slotsSize = this.table.getSlotsSize();
        this.currentEnd = this.groupsSize;
        this.parent = -1;
    }

    @NotNull
    public final SlotTable getTable$runtime() {
        return this.table;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getCurrentEnd() {
        return this.currentEnd;
    }

    public final int getParent() {
        return this.parent;
    }

    public final int getSize() {
        return this.groupsSize;
    }

    public final int getSlot() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final int parent(int index) {
        return SlotTableKt.access$parentAnchor(this.groups, index);
    }

    public final boolean isNode() {
        return SlotTableKt.access$isNode(this.groups, this.currentGroup);
    }

    public final boolean isNode(int index) {
        return SlotTableKt.access$isNode(this.groups, index);
    }

    public final int getNodeCount() {
        return SlotTableKt.access$nodeCount(this.groups, this.currentGroup);
    }

    public final int nodeCount(int index) {
        return SlotTableKt.access$nodeCount(this.groups, index);
    }

    @Nullable
    public final Object node(int index) {
        return SlotTableKt.access$isNode(this.groups, index) ? this.node(this.groups, index) : null;
    }

    public final boolean isGroupEnd() {
        return this.getInEmpty() || this.currentGroup == this.currentEnd;
    }

    public final boolean getInEmpty() {
        return this.emptyCount > 0;
    }

    public final int getGroupSize() {
        return SlotTableKt.access$groupSize(this.groups, this.currentGroup);
    }

    public final int groupSize(int index) {
        return SlotTableKt.access$groupSize(this.groups, index);
    }

    public final int getGroupEnd() {
        return this.currentEnd;
    }

    public final int groupEnd(int index) {
        return index + SlotTableKt.access$groupSize(this.groups, index);
    }

    public final int getGroupKey() {
        return this.currentGroup < this.currentEnd ? SlotTableKt.access$key(this.groups, this.currentGroup) : 0;
    }

    public final int groupKey(int index) {
        return SlotTableKt.access$key(this.groups, index);
    }

    public final int getGroupSlotIndex() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final boolean hasObjectKey(int index) {
        return SlotTableKt.access$hasObjectKey(this.groups, index);
    }

    @Nullable
    public final Object getGroupObjectKey() {
        return this.currentGroup < this.currentEnd ? this.objectKey(this.groups, this.currentGroup) : null;
    }

    @Nullable
    public final Object groupObjectKey(int index) {
        return this.objectKey(this.groups, index);
    }

    @Nullable
    public final Object getGroupAux() {
        return this.currentGroup < this.currentEnd ? this.aux(this.groups, this.currentGroup) : Integer.valueOf(0);
    }

    @Nullable
    public final Object groupAux(int index) {
        return this.aux(this.groups, index);
    }

    @Nullable
    public final Object getGroupNode() {
        return this.currentGroup < this.currentEnd ? this.node(this.groups, this.currentGroup) : null;
    }

    public final int groupKey(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return anchor.getValid() ? SlotTableKt.access$key(this.groups, this.table.anchorIndex(anchor)) : 0;
    }

    public final boolean hasMark(int index) {
        return SlotTableKt.access$hasMark(this.groups, index);
    }

    public final boolean containsMark(int index) {
        return SlotTableKt.access$containsMark(this.groups, index);
    }

    public final int getParentNodes() {
        return this.parent >= 0 ? SlotTableKt.access$nodeCount(this.groups, this.parent) : 0;
    }

    public final int parentOf(int index) {
        if (!(index >= 0 && index < this.groupsSize)) {
            boolean bl = false;
            String string = "Invalid group index " + index;
            throw new IllegalArgumentException(string.toString());
        }
        return SlotTableKt.access$parentAnchor(this.groups, index);
    }

    public final int getGroupSlotCount() {
        int current = this.currentGroup;
        int start2 = SlotTableKt.access$slotAnchor(this.groups, current);
        int next2 = current + 1;
        int end2 = next2 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, next2) : this.slotsSize;
        return end2 - start2;
    }

    @Nullable
    public final Object get(int index) {
        int slotIndex = this.currentSlot + index;
        boolean bl = false;
        return slotIndex < this.currentSlotEnd ? this.slots[slotIndex] : Composer.Companion.getEmpty();
    }

    @Nullable
    public final Object groupGet(int index) {
        return this.groupGet(this.currentGroup, index);
    }

    @Nullable
    public final Object groupGet(int group, int index) {
        int start2 = SlotTableKt.access$slotAnchor(this.groups, group);
        int next2 = group + 1;
        int end2 = next2 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, next2) : this.slotsSize;
        int address = start2 + index;
        return address < end2 ? this.slots[address] : Composer.Companion.getEmpty();
    }

    @Nullable
    public final Object next() {
        if (this.emptyCount > 0 || this.currentSlot >= this.currentSlotEnd) {
            return Composer.Companion.getEmpty();
        }
        int n = this.currentSlot;
        this.currentSlot = n + 1;
        return this.slots[n];
    }

    public final void beginEmpty() {
        int n = this.emptyCount;
        this.emptyCount = n + 1;
    }

    public final void endEmpty() {
        if (!(this.emptyCount > 0)) {
            boolean bl = false;
            String string = "Unbalanced begin/end empty";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.emptyCount;
        this.emptyCount = n + -1;
    }

    public final void close() {
        this.table.close$runtime(this);
    }

    public final void startGroup() {
        if (this.emptyCount <= 0) {
            if (!(SlotTableKt.access$parentAnchor(this.groups, this.currentGroup) == this.parent)) {
                boolean bl = false;
                String string = "Invalid slot table detected";
                throw new IllegalArgumentException(string.toString());
            }
            this.parent = this.currentGroup;
            this.currentEnd = this.currentGroup + SlotTableKt.access$groupSize(this.groups, this.currentGroup);
            int n = this.currentGroup;
            this.currentGroup = n + 1;
            int current = n;
            this.currentSlot = SlotTableKt.access$slotAnchor(this.groups, current);
            this.currentSlotEnd = current >= this.groupsSize - 1 ? this.slotsSize : SlotTableKt.access$dataAnchor(this.groups, current + 1);
        }
    }

    public final void startNode() {
        if (this.emptyCount <= 0) {
            if (!SlotTableKt.access$isNode(this.groups, this.currentGroup)) {
                boolean bl = false;
                String string = "Expected a node group";
                throw new IllegalArgumentException(string.toString());
            }
            this.startGroup();
        }
    }

    public final int skipGroup() {
        if (!(this.emptyCount == 0)) {
            boolean bl = false;
            String string = "Cannot skip while in an empty region";
            throw new IllegalArgumentException(string.toString());
        }
        int count = SlotTableKt.access$isNode(this.groups, this.currentGroup) ? 1 : SlotTableKt.access$nodeCount(this.groups, this.currentGroup);
        this.currentGroup += SlotTableKt.access$groupSize(this.groups, this.currentGroup);
        return count;
    }

    public final void skipToGroupEnd() {
        if (!(this.emptyCount == 0)) {
            boolean bl = false;
            String string = "Cannot skip the enclosing group while in an empty region";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentGroup = this.currentEnd;
    }

    public final void reposition(int index) {
        int parent;
        if (!(this.emptyCount == 0)) {
            boolean bl = false;
            String string = "Cannot reposition while in an empty region";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentGroup = index;
        this.parent = parent = index < this.groupsSize ? SlotTableKt.access$parentAnchor(this.groups, index) : -1;
        this.currentEnd = parent < 0 ? this.groupsSize : parent + SlotTableKt.access$groupSize(this.groups, parent);
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void restoreParent(int index) {
        int newCurrentEnd = index + SlotTableKt.access$groupSize(this.groups, index);
        int current = this.currentGroup;
        if (!(current >= index && current <= newCurrentEnd)) {
            boolean bl = false;
            String string = "Index " + index + " is not a parent of " + current;
            throw new IllegalArgumentException(string.toString());
        }
        this.parent = index;
        this.currentEnd = newCurrentEnd;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void endGroup() {
        if (this.emptyCount == 0) {
            int parent;
            if (!(this.currentGroup == this.currentEnd)) {
                boolean bl = false;
                String string = "endGroup() not called at the end of a group";
                throw new IllegalArgumentException(string.toString());
            }
            this.parent = parent = SlotTableKt.access$parentAnchor(this.groups, this.parent);
            this.currentEnd = parent < 0 ? this.groupsSize : parent + SlotTableKt.access$groupSize(this.groups, parent);
        }
    }

    @NotNull
    public final List<KeyInfo> extractKeys() {
        List result2 = new ArrayList();
        if (this.emptyCount > 0) {
            return result2;
        }
        int index = 0;
        for (int childIndex = this.currentGroup; childIndex < this.currentEnd; childIndex += SlotTableKt.access$groupSize(this.groups, childIndex)) {
            result2.add(new KeyInfo(SlotTableKt.access$key(this.groups, childIndex), this.objectKey(this.groups, childIndex), childIndex, SlotTableKt.access$isNode(this.groups, childIndex) ? 1 : SlotTableKt.access$nodeCount(this.groups, childIndex), index++));
        }
        return result2;
    }

    public final void forEachData$runtime(int group, @NotNull Function2<? super Integer, Object, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int start2 = SlotTableKt.access$slotAnchor(this.groups, group);
        int end2 = group + 1 < this.table.getGroupsSize() ? SlotTableKt.access$dataAnchor(this.table.getGroups(), group + 1) : this.table.getSlotsSize();
        for (int index = start2; index < end2; ++index) {
            block.invoke((Object)(index - start2), this.slots[index]);
        }
    }

    @NotNull
    public String toString() {
        return "SlotReader(current=" + this.currentGroup + ", key=" + this.getGroupKey() + ", parent=" + this.parent + ", end=" + this.currentEnd + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        ArrayList<Anchor> arrayList = this.table.getAnchors$runtime();
        int effectiveSize$iv = this.groupsSize;
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index);
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            Object e = $this$getOrAdd$iv.get(location$iv);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(location)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    public static /* synthetic */ Anchor anchor$default(SlotReader slotReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotReader.currentGroup;
        }
        return slotReader.anchor(n);
    }

    private final Object node(int[] $this$node, int index) {
        return SlotTableKt.access$isNode($this$node, index) ? this.slots[SlotTableKt.access$nodeIndex($this$node, index)] : Composer.Companion.getEmpty();
    }

    private final Object aux(int[] $this$aux, int index) {
        return SlotTableKt.access$hasAux($this$aux, index) ? this.slots[SlotTableKt.access$auxIndex($this$aux, index)] : Composer.Companion.getEmpty();
    }

    private final Object objectKey(int[] $this$objectKey, int index) {
        return SlotTableKt.access$hasObjectKey($this$objectKey, index) ? this.slots[SlotTableKt.access$objectKeyIndex($this$objectKey, index)] : null;
    }
}

