/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.ActualJvm_jvmKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u0005H\u0002JD\u0010\u001d\u001a\u00020\u001e26\u0010\u001f\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u001e0 H\u0086\b\u00f8\u0001\u0000J\u0018\u0010$\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u0016J\u0006\u0010'\u001a\u00020\u0016J\u0013\u0010(\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J/\u0010)\u001a\u00020\u001e2!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00160*H\u0086\b\u00f8\u0001\u0000J\u001e\u0010+\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010,R$\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\bX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0006R$\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\bX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006-"}, d2={"Landroidx/compose/runtime/collection/IdentityArrayMap;", "Key", "", "Value", "capacity", "", "(I)V", "keys", "", "getKeys$runtime", "()[Ljava/lang/Object;", "setKeys$runtime", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "size", "getSize$runtime", "()I", "setSize$runtime", "values", "getValues$runtime", "setValues$runtime", "contains", "", "key", "(Ljava/lang/Object;)Z", "find", "findExactIndex", "midIndex", "keyHash", "forEach", "", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "isNotEmpty", "remove", "removeValueIf", "Lkotlin/Function1;", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "runtime"})
public final class IdentityArrayMap<Key, Value> {
    @NotNull
    private Object[] keys;
    @NotNull
    private Object[] values;
    private int size;

    public IdentityArrayMap(int capacity) {
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
    }

    public /* synthetic */ IdentityArrayMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    @NotNull
    public final Object[] getKeys$runtime() {
        return this.keys;
    }

    public final void setKeys$runtime(@NotNull Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
        this.keys = objectArray;
    }

    @NotNull
    public final Object[] getValues$runtime() {
        return this.values;
    }

    public final void setValues$runtime(@NotNull Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
        this.values = objectArray;
    }

    public final int getSize$runtime() {
        return this.size;
    }

    public final void setSize$runtime(int n) {
        this.size = n;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isNotEmpty() {
        return this.size > 0;
    }

    public final boolean contains(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.find(key) >= 0;
    }

    @Nullable
    public final Value get(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        return (Value)(index >= 0 ? this.values[index] : null);
    }

    public final void set(@NotNull Key key, Value value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        if (index >= 0) {
            this.values[index] = value;
        } else {
            int insertIndex = -(index + 1);
            boolean resize = this.size == this.keys.length;
            Object[] destKeys = resize ? new Object[this.size * 2] : this.keys;
            ArraysKt.copyInto((Object[])this.keys, (Object[])destKeys, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
            if (resize) {
                ArraysKt.copyInto$default((Object[])this.keys, (Object[])destKeys, (int)0, (int)0, (int)insertIndex, (int)6, null);
            }
            destKeys[insertIndex] = key;
            this.keys = destKeys;
            Object[] destValues = resize ? new Object[this.size * 2] : this.values;
            ArraysKt.copyInto((Object[])this.values, (Object[])destValues, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
            if (resize) {
                ArraysKt.copyInto$default((Object[])this.values, (Object[])destValues, (int)0, (int)0, (int)insertIndex, (int)6, null);
            }
            destValues[insertIndex] = value;
            this.values = destValues;
            int n = this.size;
            this.size = n + 1;
        }
    }

    public final boolean remove(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        if (index >= 0) {
            int size = this.size;
            Object[] keys = this.keys;
            Object[] values = this.values;
            ArraysKt.copyInto((Object[])keys, (Object[])keys, (int)index, (int)(index + 1), (int)size);
            ArraysKt.copyInto((Object[])values, (Object[])values, (int)index, (int)(index + 1), (int)size);
            int newSize = size - 1;
            keys[newSize] = null;
            values[newSize] = null;
            this.size = newSize;
            return true;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function1<? super Value, Boolean> block) {
        int index;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$removeValueIf = false;
        int current = 0;
        int n = this.getSize$runtime();
        for (index = 0; index < n; ++index) {
            Object value = this.getValues$runtime()[index];
            if (((Boolean)block.invoke(value)).booleanValue()) continue;
            if (current != index) {
                this.getKeys$runtime()[current] = this.getKeys$runtime()[index];
                this.getValues$runtime()[current] = value;
            }
            ++current;
        }
        if (this.getSize$runtime() > current) {
            n = this.getSize$runtime();
            for (index = current; index < n; ++index) {
                this.getKeys$runtime()[index] = null;
                this.getValues$runtime()[index] = null;
            }
            this.setSize$runtime(current);
        }
    }

    public final void forEach(@NotNull Function2<? super Key, ? super Value, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach = false;
        int n = this.getSize$runtime();
        for (int index = 0; index < n; ++index) {
            Object object = this.getKeys$runtime()[index];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type Key of androidx.compose.runtime.collection.IdentityArrayMap");
            }
            block.invoke(object, this.getValues$runtime()[index]);
        }
    }

    private final int find(Object key) {
        int keyIdentity = ActualJvm_jvmKt.identityHashCode(key);
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midKey = this.keys[mid];
            int midKeyHash = ActualJvm_jvmKt.identityHashCode(midKey);
            if (midKeyHash < keyIdentity) {
                low = mid + 1;
                continue;
            }
            if (midKeyHash > keyIdentity) {
                high = mid - 1;
                continue;
            }
            if (key == midKey) {
                return mid;
            }
            return this.findExactIndex(mid, key, keyIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object key, int keyHash) {
        int i;
        for (i = midIndex - 1; -1 < i; --i) {
            Object k = this.keys[i];
            if (k == key) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(k) != keyHash) break;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            Object k = this.keys[i];
            if (k == key) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(k) == keyHash) continue;
            return -(i + 1);
        }
        return -(this.size + 1);
    }

    public IdentityArrayMap() {
        this(0, 1, null);
    }
}

