/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.internal;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.RecomposeScope;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.ComposableLambdaN;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.FunctionN;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\u0013\"\u0004\u0018\u00010\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\tR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/runtime/internal/ComposableLambdaNImpl;", "Landroidx/compose/runtime/internal/ComposableLambdaN;", "key", "", "tracked", "", "arity", "(IZI)V", "_block", "", "getArity", "()I", "getKey", "scope", "Landroidx/compose/runtime/RecomposeScope;", "scopes", "", "invoke", "args", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "realParamCount", "params", "trackRead", "", "composer", "Landroidx/compose/runtime/Composer;", "trackWrite", "update", "block", "runtime"})
@Stable
public final class ComposableLambdaNImpl
implements ComposableLambdaN {
    private final int key;
    private final boolean tracked;
    private final int arity;
    @Nullable
    private Object _block;
    @Nullable
    private RecomposeScope scope;
    @Nullable
    private List<RecomposeScope> scopes;

    public ComposableLambdaNImpl(int key, boolean tracked, int arity) {
        this.key = key;
        this.tracked = tracked;
        this.arity = arity;
    }

    public final int getKey() {
        return this.key;
    }

    public int getArity() {
        return this.arity;
    }

    private final void trackWrite() {
        if (this.tracked) {
            List<RecomposeScope> scopes;
            RecomposeScope scope = this.scope;
            if (scope != null) {
                scope.invalidate();
                this.scope = null;
            }
            if ((scopes = this.scopes) != null) {
                int n = scopes.size();
                for (int index = 0; index < n; ++index) {
                    RecomposeScope item = scopes.get(index);
                    item.invalidate();
                }
                scopes.clear();
            }
        }
    }

    private final void trackRead(Composer composer) {
        RecomposeScope scope;
        if (this.tracked && (scope = composer.getRecomposeScope()) != null) {
            composer.recordUsed(scope);
            RecomposeScope lastScope = this.scope;
            if (ComposableLambdaKt.replacableWith(lastScope, scope)) {
                this.scope = scope;
            } else {
                List<RecomposeScope> lastScopes = this.scopes;
                if (lastScopes == null) {
                    List newScopes;
                    this.scopes = newScopes = (List)new ArrayList();
                    newScopes.add(scope);
                } else {
                    int n = lastScopes.size();
                    for (int index = 0; index < n; ++index) {
                        RecomposeScope scopeAtIndex = lastScopes.get(index);
                        if (!ComposableLambdaKt.replacableWith(scopeAtIndex, scope)) continue;
                        lastScopes.set(index, scope);
                        return;
                    }
                    lastScopes.add(scope);
                }
            }
        }
    }

    public final void update(@NotNull Object block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (!Intrinsics.areEqual((Object)block, (Object)this._block)) {
            boolean oldBlockNull = this._block == null;
            this._block = (FunctionN)block;
            if (!oldBlockNull) {
                this.trackWrite();
            }
        }
    }

    private final int realParamCount(int params) {
        int realParams = params;
        --realParams;
        --realParams;
        int changedParams = 1;
        while (changedParams * 10 < realParams) {
            --realParams;
            ++changedParams;
        }
        return realParams;
    }

    @Nullable
    public Object invoke(Object ... args) {
        Object result2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            int realParams = this.realParamCount(args.length);
            Object object = args[realParams];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.compose.runtime.Composer");
            }
            Composer c = (Composer)object;
            Collection $this$toTypedArray$iv = ArraysKt.slice((Object[])args, (IntRange)RangesKt.until((int)0, (int)(args.length - 1)));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Object[] allArgsButLast = objectArray;
            Object object2 = args[args.length - 1];
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            int lastChanged = (Integer)object2;
            c = c.startRestartGroup(this.key);
            this.trackRead(c);
            int dirty = lastChanged | (c.changed(this) ? ComposableLambdaKt.differentBits(realParams) : ComposableLambdaKt.sameBits(realParams));
            Object object3 = this._block;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.jvm.functions.FunctionN<*>");
            }
            FunctionN functionN = (FunctionN)object3;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread((Object)allArgsButLast);
            spreadBuilder.add((Object)dirty);
            result2 = functionN.invoke(spreadBuilder.toArray(new Object[spreadBuilder.size()]));
            ScopeUpdateScope scopeUpdateScope = c.endRestartGroup();
            if (scopeUpdateScope == null) break block4;
            scopeUpdateScope.updateScope((Function2<? super Composer, ? super Integer, Unit>)((Function2)new Function2<Composer, Integer, Unit>(args, realParams, this){
                final /* synthetic */ Object[] $args;
                final /* synthetic */ int $realParams;
                final /* synthetic */ ComposableLambdaNImpl this$0;
                {
                    this.$args = $args;
                    this.$realParams = $realParams;
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull Composer nc, int n) {
                    Intrinsics.checkNotNullParameter((Object)nc, (String)"nc");
                    Collection $this$toTypedArray$iv = ArraysKt.slice((Object[])this.$args, (IntRange)RangesKt.until((int)0, (int)this.$realParams));
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    if (objectArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    Object[] params = objectArray;
                    Object object = this.$args[this.$realParams + 1];
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    int changed = (Integer)object;
                    Collection $this$toTypedArray$iv2 = ArraysKt.slice((Object[])this.$args, (IntRange)RangesKt.until((int)(this.$realParams + 2), (int)this.$args.length));
                    boolean $i$f$toTypedArray2 = false;
                    Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                    Object[] objectArray2 = thisCollection$iv2.toArray(new Object[0]);
                    if (objectArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    Object[] changedN = objectArray2;
                    SpreadBuilder spreadBuilder = new SpreadBuilder(4);
                    spreadBuilder.addSpread((Object)params);
                    spreadBuilder.add((Object)nc);
                    spreadBuilder.add((Object)(changed | 1));
                    spreadBuilder.addSpread((Object)changedN);
                    this.this$0.invoke(spreadBuilder.toArray(new Object[spreadBuilder.size()]));
                }
            }));
        }
        return result2;
    }
}

