/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.ActualJvm_jvmKt;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\fJ&\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0\u001fH\u0086\b\u00f8\u0001\u0000J\u0012\u0010 \u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\fH\u0002J&\u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020%0\u001fH\u0086\b\u00f8\u0001\u0000J\u0011\u0010'\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0001H\u0086\u0002J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0001J&\u0010)\u001a\u00020%2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0\u001fH\u0086\b\u00f8\u0001\u0000R.\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0016\n\u0002\u0010\n\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00138\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Landroidx/compose/runtime/collection/IdentityArrayIntMap;", "", "()V", "keys", "", "getKeys$annotations", "getKeys", "()[Ljava/lang/Object;", "setKeys", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "size", "", "getSize$annotations", "getSize", "()I", "setSize", "(I)V", "values", "", "getValues$annotations", "getValues", "()[I", "setValues", "([I)V", "add", "key", "value", "any", "", "predicate", "Lkotlin/Function2;", "find", "findExactIndex", "midIndex", "valueHash", "forEach", "", "block", "get", "remove", "removeValueIf", "runtime"})
public final class IdentityArrayIntMap {
    private int size;
    @NotNull
    private Object[] keys = new Object[4];
    @NotNull
    private int[] values = new int[4];

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @PublishedApi
    public static /* synthetic */ void getSize$annotations() {
    }

    @NotNull
    public final Object[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@NotNull Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
        this.keys = objectArray;
    }

    @PublishedApi
    public static /* synthetic */ void getKeys$annotations() {
    }

    @NotNull
    public final int[] getValues() {
        return this.values;
    }

    public final void setValues(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.values = nArray;
    }

    @PublishedApi
    public static /* synthetic */ void getValues$annotations() {
    }

    public final int get(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int index = this.find(key);
        if (index < 0) {
            throw new IllegalStateException("Key not found".toString());
        }
        return this.values[index];
    }

    public final int add(@NotNull Object key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int index = 0;
        if (this.size > 0) {
            index = this.find(key);
            if (index >= 0) {
                int previousValue = this.values[index];
                this.values[index] = value;
                return previousValue;
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        if (this.size == this.keys.length) {
            Object[] newKeys = new Object[this.keys.length * 2];
            int[] newValues = new int[this.keys.length * 2];
            ArraysKt.copyInto((Object[])this.keys, (Object[])newKeys, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
            ArraysKt.copyInto((int[])this.values, (int[])newValues, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
            ArraysKt.copyInto$default((Object[])this.keys, (Object[])newKeys, (int)0, (int)0, (int)insertIndex, (int)6, null);
            ArraysKt.copyInto$default((int[])this.values, (int[])newValues, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.keys = newKeys;
            this.values = newValues;
        } else {
            ArraysKt.copyInto((Object[])this.keys, (Object[])this.keys, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
            ArraysKt.copyInto((int[])this.values, (int[])this.values, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
        }
        this.keys[insertIndex] = key;
        this.values[insertIndex] = value;
        int n = this.size;
        this.size = n + 1;
        return -1;
    }

    public final boolean remove(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int index = this.find(key);
        if (index >= 0) {
            if (index < this.size - 1) {
                ArraysKt.copyInto((Object[])this.keys, (Object[])this.keys, (int)index, (int)(index + 1), (int)this.size);
                ArraysKt.copyInto((int[])this.values, (int[])this.values, (int)index, (int)(index + 1), (int)this.size);
            }
            int n = this.size;
            this.size = n + -1;
            this.keys[this.size] = null;
            return true;
        }
        return false;
    }

    public final void removeValueIf(@NotNull Function2<Object, ? super Integer, Boolean> predicate) {
        int i;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeValueIf = false;
        int destinationIndex = 0;
        int n = this.getSize();
        for (i = 0; i < n; ++i) {
            Object key;
            Intrinsics.checkNotNull((Object)this.getKeys()[i], (String)"null cannot be cast to non-null type kotlin.Any");
            int value = this.getValues()[i];
            if (((Boolean)predicate.invoke(key, (Object)value)).booleanValue()) continue;
            if (destinationIndex != i) {
                this.getKeys()[destinationIndex] = key;
                this.getValues()[destinationIndex] = value;
            }
            ++destinationIndex;
        }
        n = this.getSize();
        for (i = destinationIndex; i < n; ++i) {
            this.getKeys()[i] = null;
        }
        this.setSize(destinationIndex);
    }

    public final boolean any(@NotNull Function2<Object, ? super Integer, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$any = false;
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            Object object = this.getKeys()[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            if (!((Boolean)predicate.invoke(object, (Object)this.getValues()[i])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public final void forEach(@NotNull Function2<Object, ? super Integer, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach = false;
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            Object object = this.getKeys()[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            block.invoke(object, (Object)this.getValues()[i]);
        }
    }

    private final int find(Object key) {
        int low = 0;
        int high = this.size - 1;
        int valueIdentity = ActualJvm_jvmKt.identityHashCode(key);
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = this.keys[mid];
            int midIdentity = ActualJvm_jvmKt.identityHashCode(midVal);
            if (midIdentity < valueIdentity) {
                low = mid + 1;
                continue;
            }
            if (midIdentity > valueIdentity) {
                high = mid - 1;
                continue;
            }
            if (midVal == key) {
                return mid;
            }
            return this.findExactIndex(mid, key, valueIdentity);
        }
        return -(low + 1);
    }

    private final int findExactIndex(int midIndex, Object value, int valueHash) {
        int i;
        for (i = midIndex - 1; -1 < i; --i) {
            Object v = this.keys[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) != valueHash) break;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            Object v = this.keys[i];
            if (v == value) {
                return i;
            }
            if (ActualJvm_jvmKt.identityHashCode(v) == valueHash) continue;
            return -(i + 1);
        }
        return -(this.size + 1);
    }
}

