/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.reflect;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.reflect.ComposableInfo;
import androidx.compose.runtime.reflect.ComposableMethodKt;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0003J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\bH\u0016J:\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\f\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Landroidx/compose/runtime/reflect/ComposableMethod;", "", "method", "Ljava/lang/reflect/Method;", "composableInfo", "Landroidx/compose/runtime/reflect/ComposableInfo;", "(Ljava/lang/reflect/Method;Landroidx/compose/runtime/reflect/ComposableInfo;)V", "parameterCount", "", "getParameterCount", "()I", "parameters", "", "Ljava/lang/reflect/Parameter;", "getParameters", "()[Ljava/lang/reflect/Parameter;", "asMethod", "equals", "", "other", "hashCode", "invoke", "composer", "Landroidx/compose/runtime/Composer;", "instance", "args", "(Landroidx/compose/runtime/Composer;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposableMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableMethod.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1549#2:214\n1620#2,3:215\n1804#2,4:218\n*S KotlinDebug\n*F\n+ 1 ComposableMethod.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n*L\n137#1:214\n137#1:215,3\n138#1:218,4\n*E\n"})
public final class ComposableMethod {
    @NotNull
    private final Method method;
    @NotNull
    private final ComposableInfo composableInfo;
    public static final int $stable = 8;

    public ComposableMethod(@NotNull Method method, @NotNull ComposableInfo composableInfo) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)composableInfo, (String)"composableInfo");
        this.method = method;
        this.composableInfo = composableInfo;
    }

    @NotNull
    public final Method asMethod() {
        return this.method;
    }

    public final int getParameterCount() {
        return this.composableInfo.getRealParamsCount();
    }

    @NotNull
    public final Parameter[] getParameters() {
        Parameter[] parameterArray = this.method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"method.parameters");
        Object[] objectArray = parameterArray;
        int n = 0;
        int n2 = this.composableInfo.getRealParamsCount();
        return (Parameter[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object invoke(@NotNull Composer composer, @Nullable Object instance, Object ... args) {
        int mask;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ComposableInfo composableInfo = this.composableInfo;
        int realParamsCount = composableInfo.component2();
        int changedParams = composableInfo.component3();
        int defaultParams = composableInfo.component4();
        int totalParams = this.method.getParameterTypes().length;
        int changedStartIndex = realParamsCount + 1;
        int defaultStartIndex = changedStartIndex + changedParams;
        Integer[] integerArray = new Integer[defaultParams];
        for (int i = 0; i < defaultParams; ++i) {
            void $this$foldIndexed$iv;
            void initial$iv;
            Collection<Integer> collection;
            void $this$mapTo$iv$iv22;
            void $this$map$iv;
            int n2 = i;
            int start2 = n2 * 31;
            int end2 = Math.min(start2 + 31, realParamsCount);
            Iterable iterable = (Iterable)RangesKt.until((int)start2, (int)end2);
            n = n2;
            objectArray = integerArray;
            boolean $i$f$map22 = false;
            void var20_26 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv22.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it >= args.length || args[it] == null ? 1 : 0);
            }
            collection = (List)destination$iv$iv;
            List useDefault = collection;
            Iterable $i$f$map22 = useDefault;
            boolean $this$mapTo$iv$iv22 = false;
            boolean $i$f$foldIndexed = false;
            int index$iv = 0;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$foldIndexed$iv) {
                void default_;
                void mask2;
                int n4;
                if ((n4 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n5 = ((Number)element$iv).intValue();
                void var28_38 = accumulator$iv;
                int i2 = n4;
                boolean bl = false;
                accumulator$iv = mask2 | default_ << i2;
            }
            void var33_43 = accumulator$iv;
            mask = var33_43;
            objectArray[n] = mask;
        }
        Integer[] defaultsMasks = integerArray;
        Object[] objectArray2 = new Object[totalParams];
        for (int i = 0; i < totalParams; ++i) {
            Object object;
            int n6;
            int n7 = i;
            Object[] objectArray3 = objectArray2;
            int n8 = n6 = n7;
            boolean bl = 0 <= n6 ? n6 < realParamsCount : false;
            if (bl) {
                Object[] objectArray4 = args;
                if (n7 >= 0 && n7 <= ArraysKt.getLastIndex((Object[])objectArray4)) {
                    object = objectArray4[n7];
                } else {
                    mask = n7;
                    n = n8;
                    objectArray = objectArray3;
                    boolean bl2 = false;
                    Class<?> clazz = this.method.getParameterTypes()[n7];
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"method.parameterTypes[idx]");
                    Object object2 = ComposableMethodKt.access$getDefaultValue(clazz);
                    objectArray3 = objectArray;
                    n8 = n;
                    object = object2;
                }
            } else if (n6 == realParamsCount) {
                object = composer;
            } else if (n6 == changedStartIndex) {
                object = 1;
            } else {
                boolean bl3 = changedStartIndex + 1 <= n6 ? n6 < defaultStartIndex : false;
                if (bl3) {
                    object = 0;
                } else {
                    boolean bl4 = defaultStartIndex <= n6 ? n6 < totalParams : false;
                    if (bl4) {
                        object = defaultsMasks[n7 - defaultStartIndex];
                    } else {
                        throw new IllegalStateException("Unexpected index".toString());
                    }
                }
            }
            objectArray3[n8] = object;
        }
        Object[] arguments = objectArray2;
        return this.method.invoke(instance, Arrays.copyOf(arguments, arguments.length));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ComposableMethod ? Intrinsics.areEqual((Object)this.method, (Object)((ComposableMethod)other).method) : false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

