/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.reflect;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.reflect.ComposableInfo;
import androidx.compose.runtime.reflect.ComposableMethodKt;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0003J:\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000e\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Landroidx/compose/runtime/reflect/ComposableMethod;", "", "method", "Ljava/lang/reflect/Method;", "composableInfo", "Landroidx/compose/runtime/reflect/ComposableInfo;", "<init>", "(Ljava/lang/reflect/Method;Landroidx/compose/runtime/reflect/ComposableInfo;)V", "asMethod", "parameterCount", "", "getParameterCount", "()I", "parameters", "", "Ljava/lang/reflect/Parameter;", "getParameters", "()[Ljava/lang/reflect/Parameter;", "parameterTypes", "Ljava/lang/Class;", "getParameterTypes", "()[Ljava/lang/Class;", "invoke", "composer", "Landroidx/compose/runtime/Composer;", "instance", "args", "(Landroidx/compose/runtime/Composer;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "equals", "", "other", "hashCode", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposableMethod.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableMethod.jvm.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1557#2:207\n1628#2,3:208\n1812#2,4:211\n1#3:215\n*S KotlinDebug\n*F\n+ 1 ComposableMethod.jvm.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n*L\n126#1:207\n126#1:208,3\n127#1:211,4\n*E\n"})
public final class ComposableMethod {
    @NotNull
    private final Method method;
    @NotNull
    private final ComposableInfo composableInfo;
    public static final int $stable = 8;

    public ComposableMethod(@NotNull Method method, @NotNull ComposableInfo composableInfo) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)composableInfo, (String)"composableInfo");
        this.method = method;
        this.composableInfo = composableInfo;
    }

    @NotNull
    public final Method asMethod() {
        return this.method;
    }

    public final int getParameterCount() {
        return this.composableInfo.getRealParamsCount();
    }

    @NotNull
    public final Parameter[] getParameters() {
        Parameter[] parameterArray = this.method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Object[] objectArray = parameterArray;
        int n = 0;
        int n2 = this.composableInfo.getRealParamsCount();
        return (Parameter[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
    }

    @NotNull
    public final Class<?>[] getParameterTypes() {
        Class<?>[] classArray = this.method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
        Object[] objectArray = classArray;
        int n = 0;
        int n2 = this.composableInfo.getRealParamsCount();
        return (Class[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object invoke(@NotNull Composer composer, @Nullable Object instance, Object ... args) {
        int mask;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ComposableInfo composableInfo = this.composableInfo;
        int realParamsCount = composableInfo.component2();
        int changedParams = composableInfo.component3();
        int defaultParams = composableInfo.component4();
        int totalParams = this.method.getParameterTypes().length;
        int changedStartIndex = realParamsCount + 1;
        int defaultStartIndex = changedStartIndex + changedParams;
        Integer[] integerArray = new Integer[defaultParams];
        for (int i = 0; i < defaultParams; ++i) {
            void $this$foldIndexed$iv;
            void initial$iv;
            Collection<Integer> collection;
            void $this$mapTo$iv$iv22;
            void $this$map$iv;
            int n2 = i;
            int start = n2 * 31;
            int end = Math.min(start + 31, realParamsCount);
            Iterable iterable = (Iterable)RangesKt.until((int)start, (int)end);
            n = n2;
            objectArray = integerArray;
            boolean $i$f$map22 = false;
            void var20_26 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv22.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it >= args.length || args[it] == null ? 1 : 0);
            }
            collection = (List)destination$iv$iv;
            List useDefault = collection;
            Iterable $i$f$map22 = useDefault;
            boolean $this$mapTo$iv$iv22 = false;
            boolean $i$f$foldIndexed = false;
            int index$iv = 0;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$foldIndexed$iv) {
                void default_;
                void mask2;
                int n4;
                if ((n4 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n5 = ((Number)element$iv).intValue();
                void var28_38 = accumulator$iv;
                int i2 = n4;
                boolean bl = false;
                accumulator$iv = mask2 | default_ << i2;
            }
            void var33_43 = accumulator$iv;
            mask = var33_43;
            objectArray[n] = mask;
        }
        Integer[] defaultsMasks = integerArray;
        Object[] objectArray2 = new Object[totalParams];
        for (int i = 0; i < totalParams; ++i) {
            Object object;
            int n6;
            int n7 = i;
            Object[] objectArray3 = objectArray2;
            int n8 = n6 = n7;
            boolean bl = 0 <= n6 ? n6 < realParamsCount : false;
            if (bl) {
                Object[] objectArray4 = args;
                boolean bl2 = 0 <= n7 ? n7 < objectArray4.length : false;
                if (bl2) {
                    object = objectArray4[n7];
                } else {
                    mask = n7;
                    n = n8;
                    objectArray = objectArray3;
                    boolean bl3 = false;
                    Class<?> clazz = this.method.getParameterTypes()[n7];
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"get(...)");
                    Object object2 = ComposableMethodKt.access$getDefaultValue(clazz);
                    objectArray3 = objectArray;
                    n8 = n;
                    object = object2;
                }
            } else if (n6 == realParamsCount) {
                object = composer;
            } else if (n6 == changedStartIndex) {
                object = 0;
            } else {
                boolean bl4 = changedStartIndex + 1 <= n6 ? n6 < defaultStartIndex : false;
                if (bl4) {
                    object = 0;
                } else {
                    boolean bl5 = defaultStartIndex <= n6 ? n6 < totalParams : false;
                    if (bl5) {
                        object = defaultsMasks[n7 - defaultStartIndex];
                    } else {
                        throw new IllegalStateException("Unexpected index".toString());
                    }
                }
            }
            objectArray3[n8] = object;
        }
        Object[] arguments = objectArray2;
        return this.method.invoke(instance, Arrays.copyOf(arguments, arguments.length));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ComposableMethod ? Intrinsics.areEqual((Object)this.method, (Object)((ComposableMethod)other).method) : false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

