/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidedValue;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.awt.ComposeLayer;
import androidx.compose.ui.awt.LocalLayerContainer_desktopKt;
import androidx.compose.ui.window.WindowExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipComponent;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\tH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\tH\u0016J(\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)H\u0016J\u001e\u0010-\u001a\u00020\t2\u0011\u0010\u0007\u001a\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010.R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000f\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR0\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Landroidx/compose/ui/awt/ComposePanel;", "Ljavax/swing/JLayeredPane;", "()V", "clipMap", "", "Ljava/awt/Component;", "Lorg/jetbrains/skiko/ClipComponent;", "content", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "Lkotlin/jvm/functions/Function2;", "value", "Landroidx/compose/ui/window/WindowExceptionHandler;", "exceptionHandler", "getExceptionHandler$annotations", "getExceptionHandler", "()Landroidx/compose/ui/window/WindowExceptionHandler;", "setExceptionHandler", "(Landroidx/compose/ui/window/WindowExceptionHandler;)V", "layer", "Landroidx/compose/ui/awt/ComposeLayer;", "getLayer$ui", "()Landroidx/compose/ui/awt/ComposeLayer;", "setLayer$ui", "(Landroidx/compose/ui/awt/ComposeLayer;)V", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "add", "component", "addNotify", "getPreferredSize", "Ljava/awt/Dimension;", "initContent", "remove", "removeNotify", "requestFocus", "setBounds", "x", "", "y", "width", "height", "setContent", "(Lkotlin/jvm/functions/Function2;)V", "ui"})
@StabilityInferred(parameters=0)
public final class ComposePanel
extends JLayeredPane {
    @Nullable
    private ComposeLayer layer;
    @NotNull
    private final Map<Component, ClipComponent> clipMap;
    @Nullable
    private Function2<? super Composer, ? super Integer, Unit> content;
    @Nullable
    private WindowExceptionHandler exceptionHandler;
    public static final int $stable = 8;

    public ComposePanel() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "ComposePanel should be created inside AWT Event Dispatch Thread (use SwingUtilities.invokeLater).\nCreating from another thread isn't supported.";
            throw new IllegalStateException(string.toString());
        }
        this.setBackground(Color.white);
        this.setLayout(null);
        this.clipMap = new LinkedHashMap();
    }

    @Nullable
    public final ComposeLayer getLayer$ui() {
        return this.layer;
    }

    public final void setLayer$ui(@Nullable ComposeLayer composeLayer) {
        this.layer = composeLayer;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        ComposeLayer composeLayer = this.layer;
        if (composeLayer != null) {
            SkiaLayer skiaLayer = composeLayer.getComponent();
            if (skiaLayer != null) {
                skiaLayer.setSize(width, height);
            }
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.isPreferredSizeSet()) {
            dimension = super.getPreferredSize();
        } else {
            ComposeLayer composeLayer = this.layer;
            if (composeLayer == null) {
                dimension = null;
            } else {
                SkiaLayer skiaLayer = composeLayer.getComponent();
                dimension = skiaLayer == null ? null : skiaLayer.getPreferredSize();
            }
        }
        return dimension;
    }

    public final void setContent(@NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.content = content;
        this.initContent();
    }

    @Nullable
    public final WindowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void setExceptionHandler(@Nullable WindowExceptionHandler value2) {
        this.exceptionHandler = value2;
        ComposeLayer composeLayer = this.layer;
        if (composeLayer != null) {
            composeLayer.setExceptionHandler(value2);
        }
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getExceptionHandler$annotations() {
    }

    private final void initContent() {
        if (this.layer != null && this.content != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            ComposeLayer.setContent$default(composeLayer, null, null, (Function2)ComposableLambdaKt.composableLambdaInstance((int)-985531887, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this){
                final /* synthetic */ ComposePanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @Composable
                public final void invoke(@Nullable Composer $composer, int $changed) {
                    ComposerKt.sourceInformation((Composer)$composer, (String)"C80@2916L138:ComposePanel.desktop.kt#ccs55x");
                    if (($changed & 0xB ^ 2) != 0 || !$composer.getSkipping()) {
                        ProvidedValue[] providedValueArray = new ProvidedValue[]{LocalLayerContainer_desktopKt.getLocalLayerContainer().provides((Object)this.this$0)};
                        Function2 function2 = ComposePanel.access$getContent$p(this.this$0);
                        Intrinsics.checkNotNull((Object)function2);
                        CompositionLocalKt.CompositionLocalProvider((ProvidedValue[])providedValueArray, (Function2)function2, (Composer)$composer, (int)8);
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }), 3, null);
        }
    }

    @Override
    @NotNull
    public Component add(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.layer == null) {
            return component;
        }
        ClipComponent clipComponent = new ClipComponent(component);
        this.clipMap.put(component, clipComponent);
        ComposeLayer composeLayer = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer);
        composeLayer.getComponent().getClipComponents().add(clipComponent);
        Component component2 = super.add(component, 0);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"super.add(component, Integer.valueOf(0))");
        return component2;
    }

    @Override
    public void remove(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ComposeLayer composeLayer = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer);
        List list = composeLayer.getComponent().getClipComponents();
        ClipComponent clipComponent = this.clipMap.get(component);
        Intrinsics.checkNotNull((Object)clipComponent);
        list.remove(clipComponent);
        this.clipMap.remove(component);
        super.remove(component);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addNotify() {
        void $this$addNotify_u24lambda_u2d1;
        ComposeLayer composeLayer;
        super.addNotify();
        ComposeLayer composeLayer2 = composeLayer = new ComposeLayer();
        ComposePanel composePanel = this;
        boolean bl = false;
        $this$addNotify_u24lambda_u2d1.getComponent().setSize(this.getWidth(), this.getHeight());
        $this$addNotify_u24lambda_u2d1.setExceptionHandler(this.getExceptionHandler());
        composePanel.layer = composeLayer;
        this.initContent();
        ComposeLayer composeLayer3 = this.layer;
        Intrinsics.checkNotNull((Object)composeLayer3);
        super.add((Component)composeLayer3.getComponent(), 1);
    }

    @Override
    public void removeNotify() {
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            composeLayer.dispose();
            ComposeLayer composeLayer2 = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer2);
            super.remove((Component)composeLayer2.getComponent());
        }
        super.removeNotify();
    }

    @Override
    public void requestFocus() {
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            composeLayer.getComponent().requestFocus();
        }
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        GraphicsApi graphicsApi;
        if (this.layer != null) {
            ComposeLayer composeLayer = this.layer;
            Intrinsics.checkNotNull((Object)composeLayer);
            graphicsApi = composeLayer.getComponent().getRenderApi();
        } else {
            graphicsApi = GraphicsApi.UNKNOWN;
        }
        return graphicsApi;
    }

    public static final /* synthetic */ Function2 access$getContent$p(ComposePanel $this) {
        return $this.content;
    }
}

