/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.focus.FocusManager;
import androidx.compose.ui.focus.FocusManagerKt;
import androidx.compose.ui.focus.FocusModifier;
import androidx.compose.ui.focus.FocusModifierKt;
import androidx.compose.ui.focus.FocusOrderModifierKt;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.focus.FocusTransactionsKt;
import androidx.compose.ui.focus.FocusTraversalKt;
import androidx.compose.ui.node.ModifiedFocusNode;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0010J\u001d\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0010J\u0006\u0010\u001a\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/focus/FocusManagerImpl;", "Landroidx/compose/ui/focus/FocusManager;", "focusModifier", "Landroidx/compose/ui/focus/FocusModifier;", "(Landroidx/compose/ui/focus/FocusModifier;)V", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "setLayoutDirection", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "modifier", "Landroidx/compose/ui/Modifier;", "getModifier", "()Landroidx/compose/ui/Modifier;", "clearFocus", "", "force", "", "fetchUpdatedFocusProperties", "moveFocus", "focusDirection", "Landroidx/compose/ui/focus/FocusDirection;", "moveFocus-3ESFkO8", "(I)Z", "releaseFocus", "takeFocus", "ui"})
public final class FocusManagerImpl
implements FocusManager {
    @NotNull
    private final FocusModifier focusModifier;
    public LayoutDirection layoutDirection;

    public FocusManagerImpl(@NotNull FocusModifier focusModifier2) {
        Intrinsics.checkNotNullParameter((Object)focusModifier2, (String)"focusModifier");
        this.focusModifier = focusModifier2;
    }

    public /* synthetic */ FocusManagerImpl(FocusModifier focusModifier2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            focusModifier2 = new FocusModifier(FocusStateImpl.Inactive, null, 2, null);
        }
        this(focusModifier2);
    }

    @NotNull
    public final Modifier getModifier() {
        return FocusModifierKt.focusTarget(Modifier.Companion, this.focusModifier);
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        LayoutDirection layoutDirection = this.layoutDirection;
        if (layoutDirection != null) {
            return layoutDirection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutDirection");
        return null;
    }

    public final void setLayoutDirection(@NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"<set-?>");
        this.layoutDirection = layoutDirection;
    }

    public final void takeFocus() {
        if (this.focusModifier.getFocusState() == FocusStateImpl.Inactive) {
            this.focusModifier.setFocusState(FocusStateImpl.Active);
        }
    }

    public final void releaseFocus() {
        FocusTransactionsKt.clearFocus(this.focusModifier.getFocusNode(), true);
    }

    @Override
    public void clearFocus(boolean force) {
        FocusStateImpl rootInitialState = this.focusModifier.getFocusState();
        if (FocusTransactionsKt.clearFocus(this.focusModifier.getFocusNode(), force)) {
            FocusStateImpl focusStateImpl;
            switch (WhenMappings.$EnumSwitchMapping$0[rootInitialState.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    focusStateImpl = FocusStateImpl.Active;
                    break;
                }
                case 4: 
                case 5: {
                    focusStateImpl = FocusStateImpl.Deactivated;
                    break;
                }
                case 6: {
                    focusStateImpl = FocusStateImpl.Inactive;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.focusModifier.setFocusState(focusStateImpl);
        }
    }

    @Override
    public boolean moveFocus-3ESFkO8(int focusDirection) {
        ModifiedFocusNode modifiedFocusNode = FocusTraversalKt.findActiveFocusNode(this.focusModifier.getFocusNode());
        if (modifiedFocusNode == null) {
            return false;
        }
        ModifiedFocusNode source = modifiedFocusNode;
        FocusRequester nextFocusRequester = FocusOrderModifierKt.customFocusSearch--OM-vw8(source, focusDirection, this.getLayoutDirection());
        if (!Intrinsics.areEqual((Object)nextFocusRequester, (Object)FocusRequester.Companion.getDefault())) {
            nextFocusRequester.requestFocus();
            return true;
        }
        ModifiedFocusNode destination = FocusTraversalKt.focusSearch--OM-vw8(this.focusModifier.getFocusNode(), focusDirection, this.getLayoutDirection());
        if (Intrinsics.areEqual((Object)destination, (Object)source)) {
            return false;
        }
        if (destination == null) {
            if (this.focusModifier.getFocusState().getHasFocus() && !this.focusModifier.getFocusState().isFocused()) {
                boolean bl;
                int n = focusDirection;
                if (FocusDirection.equals-impl0(n, FocusDirection.Companion.getNext-dhqQ-8s()) ? true : FocusDirection.equals-impl0(n, FocusDirection.Companion.getPrevious-dhqQ-8s())) {
                    this.clearFocus(false);
                    bl = this.focusModifier.getFocusState().isFocused() ? this.moveFocus-3ESFkO8(focusDirection) : false;
                } else {
                    bl = false;
                }
                return bl;
            }
            return false;
        }
        if (destination.findParentFocusNode$ui() == null) {
            boolean bl = false;
            String string = "Move focus landed at the root.";
            throw new IllegalStateException(string.toString());
        }
        FocusTransactionsKt.requestFocus(destination);
        return true;
    }

    public final void fetchUpdatedFocusProperties() {
        FocusManagerKt.access$updateProperties(this.focusModifier.getFocusNode());
    }

    public FocusManagerImpl() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FocusStateImpl.values().length];
            nArray[FocusStateImpl.Active.ordinal()] = 1;
            nArray[FocusStateImpl.ActiveParent.ordinal()] = 2;
            nArray[FocusStateImpl.Captured.ordinal()] = 3;
            nArray[FocusStateImpl.Deactivated.ordinal()] = 4;
            nArray[FocusStateImpl.DeactivatedParent.ordinal()] = 5;
            nArray[FocusStateImpl.Inactive.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

