/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.focus;

import androidx.compose.ui.focus.FocusManager;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.node.ModifiedFocusNode;
import androidx.compose.ui.node.Owner;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u0004*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\t\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"activateNode", "", "Landroidx/compose/ui/node/ModifiedFocusNode;", "captureFocus", "", "clearChildFocus", "clearFocus", "forcedClear", "deactivateNode", "freeFocus", "grantFocus", "grantFocusToChild", "childNode", "requestFocus", "requestFocusForChild", "requestFocusForOwner", "ui"})
public final class FocusTransactionsKt {
    public static final void requestFocus(@NotNull ModifiedFocusNode $this$requestFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$requestFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$requestFocus.getFocusState().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                $this$requestFocus.sendOnFocusEvent($this$requestFocus.getFocusState());
                break;
            }
            case 5: {
                if (!FocusTransactionsKt.clearChildFocus($this$requestFocus)) break;
                FocusTransactionsKt.grantFocus($this$requestFocus);
                break;
            }
            case 6: {
                ModifiedFocusNode focusParent = $this$requestFocus.findParentFocusNode$ui();
                if (focusParent != null) {
                    FocusTransactionsKt.requestFocusForChild(focusParent, $this$requestFocus);
                    break;
                }
                if (!FocusTransactionsKt.requestFocusForOwner($this$requestFocus)) break;
                FocusTransactionsKt.grantFocus($this$requestFocus);
            }
        }
    }

    public static final void activateNode(@NotNull ModifiedFocusNode $this$activateNode) {
        Intrinsics.checkNotNullParameter((Object)$this$activateNode, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$activateNode.getFocusState().ordinal()]) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                $this$activateNode.setFocusState(FocusStateImpl.Inactive);
                break;
            }
            case 4: {
                $this$activateNode.setFocusState(FocusStateImpl.ActiveParent);
            }
        }
    }

    public static final void deactivateNode(@NotNull ModifiedFocusNode $this$deactivateNode) {
        Intrinsics.checkNotNullParameter((Object)$this$deactivateNode, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$deactivateNode.getFocusState().ordinal()]) {
            case 5: {
                $this$deactivateNode.setFocusState(FocusStateImpl.DeactivatedParent);
                break;
            }
            case 1: 
            case 2: {
                Owner owner = $this$deactivateNode.getLayoutNode$ui().getOwner$ui();
                if (owner != null) {
                    FocusManager focusManager = owner.getFocusManager();
                    if (focusManager != null) {
                        focusManager.clearFocus(true);
                    }
                }
                $this$deactivateNode.setFocusState(FocusStateImpl.Deactivated);
                break;
            }
            case 6: {
                $this$deactivateNode.setFocusState(FocusStateImpl.Deactivated);
            }
        }
    }

    public static final boolean captureFocus(@NotNull ModifiedFocusNode $this$captureFocus) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$captureFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$captureFocus.getFocusState().ordinal()]) {
            case 1: {
                $this$captureFocus.setFocusState(FocusStateImpl.Captured);
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean freeFocus(@NotNull ModifiedFocusNode $this$freeFocus) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$freeFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$freeFocus.getFocusState().ordinal()]) {
            case 2: {
                $this$freeFocus.setFocusState(FocusStateImpl.Active);
                bl = true;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean clearFocus(@NotNull ModifiedFocusNode $this$clearFocus, boolean forcedClear) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$clearFocus, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$clearFocus.getFocusState().ordinal()]) {
            case 1: {
                $this$clearFocus.setFocusState(FocusStateImpl.Inactive);
                bl = true;
                break;
            }
            case 5: {
                if (FocusTransactionsKt.clearChildFocus($this$clearFocus)) {
                    $this$clearFocus.setFocusState(FocusStateImpl.Inactive);
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if (FocusTransactionsKt.clearChildFocus($this$clearFocus)) {
                    $this$clearFocus.setFocusState(FocusStateImpl.Deactivated);
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (forcedClear) {
                    $this$clearFocus.setFocusState(FocusStateImpl.Inactive);
                }
                bl = forcedClear;
                break;
            }
            case 3: 
            case 6: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean clearFocus$default(ModifiedFocusNode modifiedFocusNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FocusTransactionsKt.clearFocus(modifiedFocusNode, bl);
    }

    private static final void grantFocus(ModifiedFocusNode $this$grantFocus) {
        FocusStateImpl focusStateImpl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$grantFocus.getFocusState().ordinal()]) {
            case 1: 
            case 5: 
            case 6: {
                focusStateImpl = FocusStateImpl.Active;
                break;
            }
            case 2: {
                focusStateImpl = FocusStateImpl.Captured;
                break;
            }
            case 3: 
            case 4: {
                throw new IllegalStateException("Granting focus to a deactivated node.".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$grantFocus.setFocusState(focusStateImpl);
    }

    private static final boolean grantFocusToChild(ModifiedFocusNode $this$grantFocusToChild, ModifiedFocusNode childNode) {
        FocusTransactionsKt.grantFocus(childNode);
        $this$grantFocusToChild.setFocusedChild(childNode);
        return true;
    }

    private static final boolean clearChildFocus(ModifiedFocusNode $this$clearChildFocus) {
        boolean bl;
        ModifiedFocusNode modifiedFocusNode = $this$clearChildFocus.getFocusedChild();
        if (modifiedFocusNode == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (FocusTransactionsKt.clearFocus$default(modifiedFocusNode, false, 1, null)) {
            $this$clearChildFocus.setFocusedChild(null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean requestFocusForChild(ModifiedFocusNode $this$requestFocusForChild, ModifiedFocusNode childNode) {
        boolean bl;
        if (!$this$requestFocusForChild.focusableChildren(false).contains(childNode)) {
            throw new IllegalStateException("Non child node cannot request focus.".toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$this$requestFocusForChild.getFocusState().ordinal()]) {
            case 1: {
                $this$requestFocusForChild.setFocusState(FocusStateImpl.ActiveParent);
                bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                break;
            }
            case 5: {
                if (FocusTransactionsKt.clearChildFocus($this$requestFocusForChild)) {
                    bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if ($this$requestFocusForChild.getFocusedChild() == null) {
                    bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                    break;
                }
                if (FocusTransactionsKt.clearChildFocus($this$requestFocusForChild)) {
                    bl = FocusTransactionsKt.grantFocusToChild($this$requestFocusForChild, childNode);
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                ModifiedFocusNode focusParent = $this$requestFocusForChild.findParentFocusNode$ui();
                if (focusParent == null && FocusTransactionsKt.requestFocusForOwner($this$requestFocusForChild)) {
                    $this$requestFocusForChild.setFocusState(FocusStateImpl.Active);
                    bl = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                    break;
                }
                if (focusParent != null && FocusTransactionsKt.requestFocusForChild(focusParent, $this$requestFocusForChild)) {
                    bl = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                void var2_3;
                FocusTransactionsKt.activateNode($this$requestFocusForChild);
                boolean childGrantedFocus = FocusTransactionsKt.requestFocusForChild($this$requestFocusForChild, childNode);
                FocusTransactionsKt.deactivateNode($this$requestFocusForChild);
                bl = var2_3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean requestFocusForOwner(ModifiedFocusNode $this$requestFocusForOwner) {
        Owner owner = $this$requestFocusForOwner.getLayoutNode$ui().getOwner$ui();
        Boolean bl = owner == null ? null : Boolean.valueOf(owner.requestFocus());
        if (bl == null) {
            throw new IllegalStateException("Owner not initialized.".toString());
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FocusStateImpl.values().length];
            nArray[FocusStateImpl.Active.ordinal()] = 1;
            nArray[FocusStateImpl.Captured.ordinal()] = 2;
            nArray[FocusStateImpl.Deactivated.ordinal()] = 3;
            nArray[FocusStateImpl.DeactivatedParent.ordinal()] = 4;
            nArray[FocusStateImpl.ActiveParent.ordinal()] = 5;
            nArray[FocusStateImpl.Inactive.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

