/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.nestedscroll;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.input.nestedscroll.NestedScrollConnection;
import androidx.compose.ui.input.nestedscroll.NestedScrollDelegatingWrapperKt;
import androidx.compose.ui.input.nestedscroll.NestedScrollDispatcher;
import androidx.compose.ui.input.nestedscroll.NestedScrollModifier;
import androidx.compose.ui.input.nestedscroll.ParentWrapperNestedScrollConnection;
import androidx.compose.ui.node.DelegatingLayoutNodeWrapper;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeWrapper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0000H\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\u0016\u0010\"\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0018H\u0002J\b\u0010%\u001a\u00020\u001eH\u0016J\u0012\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010(\u001a\u00020\u001eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\t\u001a\u0004\u0018\u00010\u0019@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Landroidx/compose/ui/input/nestedscroll/NestedScrollDelegatingWrapper;", "Landroidx/compose/ui/node/DelegatingLayoutNodeWrapper;", "Landroidx/compose/ui/input/nestedscroll/NestedScrollModifier;", "wrapped", "Landroidx/compose/ui/node/LayoutNodeWrapper;", "nestedScrollModifier", "(Landroidx/compose/ui/node/LayoutNodeWrapper;Landroidx/compose/ui/input/nestedscroll/NestedScrollModifier;)V", "childScrollConnection", "Landroidx/compose/ui/input/nestedscroll/ParentWrapperNestedScrollConnection;", "value", "Lkotlin/Function0;", "Lkotlinx/coroutines/CoroutineScope;", "coroutineScopeEvaluation", "getCoroutineScopeEvaluation", "()Lkotlin/jvm/functions/Function0;", "setCoroutineScopeEvaluation", "(Lkotlin/jvm/functions/Function0;)V", "lastModifier", "modifier", "getModifier", "()Landroidx/compose/ui/input/nestedscroll/NestedScrollModifier;", "setModifier", "(Landroidx/compose/ui/input/nestedscroll/NestedScrollModifier;)V", "nestedScrollChildrenResult", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;", "parentConnection", "setParentConnection", "(Landroidx/compose/ui/input/nestedscroll/NestedScrollConnection;)V", "attach", "", "detach", "findNextNestedScrollWrapper", "findPreviousNestedScrollWrapper", "loopChildrenForNestedScroll", "children", "Landroidx/compose/ui/node/LayoutNode;", "onModifierChanged", "refreshChildrenWithParentConnection", "newParent", "refreshSelfIfNeeded", "ui"})
public final class NestedScrollDelegatingWrapper
extends DelegatingLayoutNodeWrapper<NestedScrollModifier> {
    @Nullable
    private NestedScrollConnection parentConnection;
    @Nullable
    private NestedScrollModifier lastModifier;
    @NotNull
    private final ParentWrapperNestedScrollConnection childScrollConnection;
    @NotNull
    private final MutableVector<NestedScrollDelegatingWrapper> nestedScrollChildrenResult;

    public NestedScrollDelegatingWrapper(@NotNull LayoutNodeWrapper wrapped, @NotNull NestedScrollModifier nestedScrollModifier) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)nestedScrollModifier, (String)"nestedScrollModifier");
        super(wrapped, (Modifier.Element)nestedScrollModifier);
        NestedScrollConnection nestedScrollConnection = this.parentConnection;
        if (nestedScrollConnection == null) {
            nestedScrollConnection = NestedScrollDelegatingWrapperKt.access$getNoOpConnection$p();
        }
        this.childScrollConnection = new ParentWrapperNestedScrollConnection(nestedScrollConnection, nestedScrollModifier.getConnection());
        int capacity$iv = 16;
        boolean $i$f$MutableVector = false;
        this.nestedScrollChildrenResult = new MutableVector((Object[])new NestedScrollDelegatingWrapper[capacity$iv], 0);
    }

    private final void setParentConnection(NestedScrollConnection value2) {
        this.getModifier().getDispatcher().setParent$ui(value2);
        NestedScrollConnection nestedScrollConnection = value2;
        if (nestedScrollConnection == null) {
            nestedScrollConnection = NestedScrollDelegatingWrapperKt.access$getNoOpConnection$p();
        }
        this.childScrollConnection.setParent(nestedScrollConnection);
        this.parentConnection = value2;
    }

    private final Function0<CoroutineScope> getCoroutineScopeEvaluation() {
        return this.getModifier().getDispatcher().getCalculateNestedScrollScope$ui();
    }

    private final void setCoroutineScopeEvaluation(Function0<? extends CoroutineScope> value2) {
        this.getModifier().getDispatcher().setCalculateNestedScrollScope$ui(value2);
    }

    @Override
    public void onModifierChanged() {
        super.onModifierChanged();
        this.childScrollConnection.setSelf(this.getModifier().getConnection());
        this.getModifier().getDispatcher().setParent$ui(this.parentConnection);
        this.refreshSelfIfNeeded();
    }

    @Override
    @NotNull
    public NestedScrollModifier getModifier() {
        return (NestedScrollModifier)super.getModifier();
    }

    @Override
    public void setModifier(@NotNull NestedScrollModifier value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.lastModifier = (NestedScrollModifier)super.getModifier();
        super.setModifier((Modifier.Element)value2);
    }

    @Override
    public void attach() {
        super.attach();
        this.refreshSelfIfNeeded();
    }

    @Override
    public void detach() {
        super.detach();
        this.refreshChildrenWithParentConnection(this.parentConnection);
        this.lastModifier = null;
    }

    @Override
    @NotNull
    public NestedScrollDelegatingWrapper findPreviousNestedScrollWrapper() {
        return this;
    }

    @Override
    @NotNull
    public NestedScrollDelegatingWrapper findNextNestedScrollWrapper() {
        return this;
    }

    private final void refreshSelfIfNeeded() {
        boolean modifierChanged;
        NestedScrollModifier localLastModifier = this.lastModifier;
        boolean bl = modifierChanged = localLastModifier == null || localLastModifier.getConnection() != this.getModifier().getConnection() || localLastModifier.getDispatcher() != this.getModifier().getDispatcher();
        if (modifierChanged && this.isAttached()) {
            NestedScrollDelegatingWrapper parent2;
            NestedScrollDelegatingWrapper nestedScrollDelegatingWrapper = parent2 = super.findPreviousNestedScrollWrapper();
            this.setParentConnection((NestedScrollConnection)(nestedScrollDelegatingWrapper == null ? null : nestedScrollDelegatingWrapper.childScrollConnection));
            NestedScrollDelegatingWrapper nestedScrollDelegatingWrapper2 = parent2;
            Object object = nestedScrollDelegatingWrapper2 == null ? null : nestedScrollDelegatingWrapper2.getCoroutineScopeEvaluation();
            if (object == null) {
                object = this.getCoroutineScopeEvaluation();
            }
            this.setCoroutineScopeEvaluation((Function0<? extends CoroutineScope>)object);
            this.refreshChildrenWithParentConnection(this.childScrollConnection);
            this.lastModifier = this.getModifier();
        }
    }

    private final void refreshChildrenWithParentConnection(NestedScrollConnection newParent) {
        NestedScrollDelegatingWrapper nestedScrollDelegatingWrapper;
        MutableVector<NestedScrollDelegatingWrapper> this_$iv;
        this.nestedScrollChildrenResult.clear();
        NestedScrollDelegatingWrapper nextNestedScrollWrapper = this.getWrapped$ui().findNextNestedScrollWrapper();
        if (nextNestedScrollWrapper != null) {
            this.nestedScrollChildrenResult.add((Object)nextNestedScrollWrapper);
        } else {
            this.loopChildrenForNestedScroll(this.getLayoutNode$ui().get_children$ui());
        }
        if (this.nestedScrollChildrenResult.isNotEmpty()) {
            MutableVector<NestedScrollDelegatingWrapper> mutableVector = this.nestedScrollChildrenResult;
            int index$iv = 0;
            boolean $i$f$get = false;
            nestedScrollDelegatingWrapper = (NestedScrollDelegatingWrapper)this_$iv.getContent()[index$iv];
        } else {
            nestedScrollDelegatingWrapper = null;
        }
        NestedScrollDelegatingWrapper outerChild = nestedScrollDelegatingWrapper;
        this_$iv = this.nestedScrollChildrenResult;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                NestedScrollDelegatingWrapper it = (NestedScrollDelegatingWrapper)content$iv[i$iv];
                boolean bl = false;
                it.setParentConnection(newParent);
                it.setCoroutineScopeEvaluation((Function0<? extends CoroutineScope>)(newParent != null ? (Function0)new Function0<CoroutineScope>(this){
                    final /* synthetic */ NestedScrollDelegatingWrapper this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final CoroutineScope invoke() {
                        return (CoroutineScope)NestedScrollDelegatingWrapper.access$getCoroutineScopeEvaluation(this.this$0).invoke();
                    }
                } : (Function0)new Function0<CoroutineScope>(outerChild){
                    final /* synthetic */ NestedScrollDelegatingWrapper $outerChild;
                    {
                        this.$outerChild = $outerChild;
                        super(0);
                    }

                    @Nullable
                    public final CoroutineScope invoke() {
                        Object object;
                        NestedScrollDelegatingWrapper nestedScrollDelegatingWrapper = this.$outerChild;
                        if (nestedScrollDelegatingWrapper == null) {
                            object = null;
                        } else {
                            NestedScrollModifier nestedScrollModifier = nestedScrollDelegatingWrapper.getModifier();
                            if (nestedScrollModifier == null) {
                                object = null;
                            } else {
                                NestedScrollDispatcher nestedScrollDispatcher = nestedScrollModifier.getDispatcher();
                                object = nestedScrollDispatcher == null ? null : nestedScrollDispatcher.getOriginNestedScrollScope$ui();
                            }
                        }
                        return object;
                    }
                }));
            } while (++i$iv < size$iv);
        }
    }

    private final void loopChildrenForNestedScroll(MutableVector<LayoutNode> children) {
        MutableVector<LayoutNode> this_$iv = children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                LayoutNode child = (LayoutNode)content$iv[i$iv];
                boolean bl = false;
                NestedScrollDelegatingWrapper nestedScrollChild = child.getOuterLayoutNodeWrapper$ui().findNextNestedScrollWrapper();
                if (nestedScrollChild != null) {
                    this.nestedScrollChildrenResult.add((Object)nestedScrollChild);
                    continue;
                }
                this.loopChildrenForNestedScroll(child.get_children$ui());
            } while (++i$iv < size$iv);
        }
    }

    public static final /* synthetic */ Function0 access$getCoroutineScopeEvaluation(NestedScrollDelegatingWrapper $this) {
        return $this.getCoroutineScopeEvaluation();
    }
}

