/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.input.pointer.util.PointAtTime;
import androidx.compose.ui.input.pointer.util.PolynomialFit;
import androidx.compose.ui.input.pointer.util.VelocityEstimate;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import androidx.compose.ui.unit.VelocityKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u0012\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "", "()V", "index", "", "samples", "", "Landroidx/compose/ui/input/pointer/util/PointAtTime;", "[Landroidx/compose/ui/input/pointer/util/PointAtTime;", "addPosition", "", "timeMillis", "", "position", "Landroidx/compose/ui/geometry/Offset;", "addPosition-Uv8p0NA", "(JJ)V", "calculateVelocity", "Landroidx/compose/ui/unit/Velocity;", "calculateVelocity-9UxMQ8M", "()J", "getVelocityEstimate", "Landroidx/compose/ui/input/pointer/util/VelocityEstimate;", "resetTracking", "ui"})
@StabilityInferred(parameters=0)
public final class VelocityTracker {
    @NotNull
    private final PointAtTime[] samples;
    private int index;
    public static final int $stable = 8;

    public VelocityTracker() {
        int n = 0;
        PointAtTime[] pointAtTimeArray = new PointAtTime[20];
        VelocityTracker velocityTracker = this;
        while (n < 20) {
            int n2 = n++;
            pointAtTimeArray[n2] = null;
        }
        velocityTracker.samples = pointAtTimeArray;
    }

    public final void addPosition-Uv8p0NA(long timeMillis, long position) {
        this.index = (this.index + 1) % 20;
        this.samples[this.index] = new PointAtTime(position, timeMillis, null);
    }

    public final long calculateVelocity-9UxMQ8M() {
        long estimate = this.getVelocityEstimate().getPixelsPerSecond-F1C5BW0();
        return VelocityKt.Velocity((float)Offset.getX-impl((long)estimate), (float)Offset.getY-impl((long)estimate));
    }

    public final void resetTracking() {
        ArraysKt.fill$default((Object[])this.samples, null, (int)0, (int)0, (int)6, null);
    }

    private final VelocityEstimate getVelocityEstimate() {
        PointAtTime newestSample;
        List x = new ArrayList();
        List y = new ArrayList();
        List time = new ArrayList();
        int sampleCount = 0;
        int index = this.index;
        PointAtTime pointAtTime = this.samples[index];
        if (pointAtTime == null) {
            return VelocityEstimate.Companion.getNone();
        }
        PointAtTime previousSample = newestSample = pointAtTime;
        PointAtTime oldestSample = newestSample;
        while (this.samples[index] != null) {
            PointAtTime sample;
            float age = newestSample.getTime() - sample.getTime();
            float delta = Math.abs(sample.getTime() - previousSample.getTime());
            previousSample = sample;
            if (age > 100.0f || delta > 40.0f) break;
            oldestSample = sample;
            long position = sample.getPoint-F1C5BW0();
            x.add(Float.valueOf(Offset.getX-impl((long)position)));
            y.add(Float.valueOf(Offset.getY-impl((long)position)));
            time.add(Float.valueOf(-age));
            index = (index == 0 ? 20 : index) - 1;
            if (++sampleCount < 20) continue;
        }
        if (sampleCount >= 3) {
            try {
                PolynomialFit xFit = VelocityTrackerKt.polyFitLeastSquares(time, x, 2);
                PolynomialFit yFit = VelocityTrackerKt.polyFitLeastSquares(time, y, 2);
                float xSlope = ((Number)xFit.getCoefficients().get(1)).floatValue();
                float ySlope = ((Number)yFit.getCoefficients().get(1)).floatValue();
                return new VelocityEstimate(OffsetKt.Offset((float)(xSlope * (float)1000), (float)(ySlope * (float)1000)), xFit.getConfidence() * yFit.getConfidence(), newestSample.getTime() - oldestSample.getTime(), Offset.minus-MK-Hz9U((long)newestSample.getPoint-F1C5BW0(), (long)oldestSample.getPoint-F1C5BW0()), null);
            }
            catch (IllegalArgumentException exception) {
                return VelocityEstimate.Companion.getNone();
            }
        }
        return new VelocityEstimate(Offset.Companion.getZero-F1C5BW0(), 1.0f, newestSample.getTime() - oldestSample.getTime(), Offset.minus-MK-Hz9U((long)newestSample.getPoint-F1C5BW0(), (long)oldestSample.getPoint-F1C5BW0()), null);
    }
}

