/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.Matrix;
import androidx.compose.ui.input.pointer.util.PolynomialFit;
import androidx.compose.ui.input.pointer.util.Vector;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"AssumePointerMoveStoppedMilliseconds", "", "DefaultWeight", "", "HistorySize", "HorizonMilliseconds", "MinSampleSize", "polyFitLeastSquares", "Landroidx/compose/ui/input/pointer/util/PolynomialFit;", "x", "", "y", "degree", "addPointerInputChange", "", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "ui"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HistorySize = 20;
    private static final int HorizonMilliseconds = 100;
    private static final int MinSampleSize = 3;
    private static final float DefaultWeight = 1.0f;

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size();
        while (n < n2) {
            HistoricalChange item$iv;
            int index$iv = n++;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            $this$addPointerInputChange.addPosition-Uv8p0NA(it.getUptimeMillis(), it.getPosition-F1C5BW0());
        }
        $this$addPointerInputChange.addPosition-Uv8p0NA(event.getUptimeMillis(), event.getPosition-F1C5BW0());
    }

    @NotNull
    public static final PolynomialFit polyFitLeastSquares(@NotNull List<Float> x, @NotNull List<Float> y, int degree) {
        int h;
        int dot2;
        int j;
        int it;
        int n;
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        if (degree < 1) {
            throw new IllegalArgumentException("The degree must be at positive integer");
        }
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("x and y must be the same length");
        }
        if (x.isEmpty()) {
            throw new IllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= x.size() ? x.size() - 1 : degree;
        int n2 = degree + 1;
        ArrayList<Float> arrayList = new ArrayList<Float>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = n4 = (n = n3++);
            ArrayList<Float> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Float.valueOf(0.0f));
        }
        List coefficients = arrayList;
        int m = x.size();
        int n6 = truncatedDegree + 1;
        Matrix a = new Matrix(n6, m);
        n = 0;
        while (n < m) {
            int h2 = n++;
            a.set(0, h2, 1.0f);
            it = 1;
            while (it < n6) {
                int i = it++;
                a.set(i, h2, a.get(i - 1, h2) * ((Number)x.get(h2)).floatValue());
            }
        }
        Matrix q = new Matrix(n6, m);
        Matrix r = new Matrix(n6, n6);
        it = 0;
        while (it < n6) {
            j = it++;
            int n7 = 0;
            while (n7 < m) {
                int h3 = n7++;
                q.set(j, h3, a.get(j, h3));
            }
            n7 = 0;
            while (n7 < j) {
                int i = n7++;
                float dot2 = q.getRow(j).times(q.getRow(i));
                int n8 = 0;
                while (n8 < m) {
                    int h4 = n8++;
                    q.set(j, h4, q.get(j, h4) - dot2 * q.get(i, h4));
                }
            }
            float norm = q.getRow(j).norm();
            if ((double)norm < 1.0E-6) {
                throw new IllegalArgumentException("Vectors are linearly dependent or zero so no solution. TODO(shepshapard), actually determine what this means");
            }
            float inverseNorm = 1.0f / norm;
            dot2 = 0;
            while (dot2 < m) {
                h = dot2++;
                q.set(j, h, q.get(j, h) * inverseNorm);
            }
            dot2 = 0;
            while (dot2 < n6) {
                int i;
                r.set(j, i, (i = dot2++) < j ? 0.0f : q.getRow(j).times(a.getRow(i)));
            }
        }
        Vector wy = new Vector(m);
        j = 0;
        while (j < m) {
            int h5 = j++;
            wy.set(h5, ((Number)y.get(h5)).floatValue() * 1.0f);
        }
        j = n6 - 1;
        if (0 <= j) {
            do {
                int i = j--;
                coefficients.set(i, Float.valueOf(q.getRow(i).times(wy)));
                int inverseNorm = n6 - 1;
                dot2 = i + 1;
                if (dot2 <= inverseNorm) {
                    int j2;
                    do {
                        j2 = inverseNorm--;
                        coefficients.set(i, Float.valueOf(((Number)coefficients.get(i)).floatValue() - r.get(i, j2) * ((Number)coefficients.get(j2)).floatValue()));
                    } while (j2 != dot2);
                }
                coefficients.set(i, Float.valueOf(((Number)coefficients.get(i)).floatValue() / r.get(i, i)));
            } while (0 <= j);
        }
        float yMean = 0.0f;
        int i = 0;
        while (i < m) {
            int h6 = i++;
            yMean += ((Number)y.get(h6)).floatValue();
        }
        yMean /= (float)m;
        float sumSquaredError = 0.0f;
        float sumSquaredTotal = 0.0f;
        dot2 = 0;
        while (dot2 < m) {
            h = dot2++;
            float term = 1.0f;
            float err = ((Number)y.get(h)).floatValue() - ((Number)coefficients.get(0)).floatValue();
            int n9 = 1;
            while (n9 < n6) {
                int i2 = n9++;
                err -= (term *= ((Number)x.get(h)).floatValue()) * ((Number)coefficients.get(i2)).floatValue();
            }
            sumSquaredError += 1.0f * err * err;
            float v = ((Number)y.get(h)).floatValue() - yMean;
            sumSquaredTotal += 1.0f * v * v;
        }
        float confidence = sumSquaredTotal <= 1.0E-6f ? 1.0f : 1.0f - sumSquaredError / sumSquaredTotal;
        return new PolynomialFit(coefficients, confidence);
    }
}

