/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.node.DepthSortedSet;
import androidx.compose.ui.node.LayoutNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0003H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSet;", "postponedMeasureRequests", "", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/DepthSortedSet;Ljava/util/List;)V", "assertConsistent", "", "isTreeConsistent", "", "node", "logTree", "", "nodeToString", "consistentLayoutState", "ui"})
public final class LayoutTreeConsistencyChecker {
    @NotNull
    private final LayoutNode root;
    @NotNull
    private final DepthSortedSet relayoutNodes;
    @NotNull
    private final List<LayoutNode> postponedMeasureRequests;

    public LayoutTreeConsistencyChecker(@NotNull LayoutNode root2, @NotNull DepthSortedSet relayoutNodes, @NotNull List<LayoutNode> postponedMeasureRequests) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)relayoutNodes, (String)"relayoutNodes");
        Intrinsics.checkNotNullParameter(postponedMeasureRequests, (String)"postponedMeasureRequests");
        this.root = root2;
        this.relayoutNodes = relayoutNodes;
        this.postponedMeasureRequests = postponedMeasureRequests;
    }

    public final void assertConsistent() {
        boolean inconsistencyFound;
        boolean bl = inconsistencyFound = !this.isTreeConsistent(this.root);
        if (inconsistencyFound) {
            System.out.println((Object)this.logTree());
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode node) {
        if (!this.consistentLayoutState(node)) {
            return false;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size();
        while (n < n2) {
            LayoutNode item$iv;
            int index$iv = n++;
            LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (this.isTreeConsistent(it)) continue;
            return false;
        }
        return true;
    }

    private final boolean consistentLayoutState(LayoutNode $this$consistentLayoutState) {
        block7: {
            LayoutNode.LayoutState parentLayoutState;
            LayoutNode parent2;
            block6: {
                parent2 = $this$consistentLayoutState.getParent$ui();
                if ($this$consistentLayoutState.isPlaced()) break block6;
                if ($this$consistentLayoutState.getPlaceOrder$ui() == Integer.MAX_VALUE) break block7;
                LayoutNode layoutNode = parent2;
                if (!(layoutNode == null ? false : layoutNode.isPlaced())) break block7;
            }
            if ($this$consistentLayoutState.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRemeasure && this.postponedMeasureRequests.contains($this$consistentLayoutState)) {
                return true;
            }
            LayoutNode layoutNode = parent2;
            LayoutNode.LayoutState layoutState = parentLayoutState = layoutNode == null ? null : layoutNode.getLayoutState$ui();
            if ($this$consistentLayoutState.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRemeasure) {
                return this.relayoutNodes.contains($this$consistentLayoutState) || parentLayoutState == LayoutNode.LayoutState.NeedsRemeasure || parentLayoutState == LayoutNode.LayoutState.Measuring;
            }
            if ($this$consistentLayoutState.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRelayout) {
                return this.relayoutNodes.contains($this$consistentLayoutState) || parentLayoutState == LayoutNode.LayoutState.NeedsRemeasure || parentLayoutState == LayoutNode.LayoutState.NeedsRelayout || parentLayoutState == LayoutNode.LayoutState.Measuring || parentLayoutState == LayoutNode.LayoutState.LayingOut;
            }
        }
        return true;
    }

    private final String nodeToString(LayoutNode node) {
        StringBuilder $this$nodeToString_u24lambda_u2d1 = new StringBuilder();
        boolean bl = false;
        $this$nodeToString_u24lambda_u2d1.append(node);
        $this$nodeToString_u24lambda_u2d1.append("" + '[' + (Object)((Object)node.getLayoutState$ui()) + ']');
        if (!node.isPlaced()) {
            $this$nodeToString_u24lambda_u2d1.append("[!isPlaced]");
        }
        $this$nodeToString_u24lambda_u2d1.append("[measuredByParent=" + (Object)((Object)node.getMeasuredByParent$ui()) + ']');
        if (!this.consistentLayoutState(node)) {
            $this$nodeToString_u24lambda_u2d1.append("[INCONSISTENT]");
        }
        String string = $this$nodeToString_u24lambda_u2d1.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(StringBuilder()) {\n\u2026     toString()\n        }");
        return string;
    }

    private final String logTree() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Tree state:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
        LayoutTreeConsistencyChecker.logTree$printSubTree(this, stringBuilder, this.root, 0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker this$0, StringBuilder stringBuilder, LayoutNode node, int depth) {
        int childrenDepth = 0;
        childrenDepth = depth;
        String nodeRepresentation = this$0.nodeToString(node);
        if (((CharSequence)nodeRepresentation).length() > 0) {
            int n = 0;
            while (n < depth) {
                int i = n++;
                stringBuilder.append("..");
            }
            StringBuilder i = stringBuilder.append(nodeRepresentation);
            Intrinsics.checkNotNullExpressionValue((Object)i, (String)"append(value)");
            StringBuilder stringBuilder2 = i.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
            ++childrenDepth;
        }
        List<LayoutNode> $this$fastForEach$iv = node.getChildren$ui();
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = $this$fastForEach$iv.size();
        while (n < n2) {
            LayoutNode item$iv;
            int index$iv = n++;
            LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            LayoutTreeConsistencyChecker.logTree$printSubTree(this$0, stringBuilder, it, childrenDepth);
        }
    }
}

