/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.node.DepthSortedSet;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutTreeConsistencyChecker;
import androidx.compose.ui.node.OnPositionedDispatcher;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\bJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0003J\u0018\u0010\"\u001a\u00020\b2\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010$J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0003J\u0010\u0010'\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u000e\u0010(\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0003J\u001b\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0018\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b,\u0010-R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\b*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006."}, d2={"Landroidx/compose/ui/node/MeasureAndLayoutDelegate;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "(Landroidx/compose/ui/node/LayoutNode;)V", "consistencyChecker", "Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "duringMeasureLayout", "", "hasPendingMeasureOrLayout", "getHasPendingMeasureOrLayout", "()Z", "<set-?>", "", "measureIteration", "getMeasureIteration", "()J", "onPositionedDispatcher", "Landroidx/compose/ui/node/OnPositionedDispatcher;", "postponedMeasureRequests", "", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSet;", "rootConstraints", "Landroidx/compose/ui/unit/Constraints;", "canAffectParent", "getCanAffectParent", "(Landroidx/compose/ui/node/LayoutNode;)Z", "dispatchOnPositionedCallbacks", "", "forceDispatch", "doRemeasure", "layoutNode", "forceMeasureTheSubtree", "measureAndLayout", "onLayout", "Lkotlin/Function0;", "onNodeDetached", "node", "remeasureAndRelayoutIfNeeded", "requestRelayout", "requestRemeasure", "updateRootConstraints", "constraints", "updateRootConstraints-BRTryo0", "(J)V", "ui"})
public final class MeasureAndLayoutDelegate {
    @NotNull
    private final LayoutNode root;
    @NotNull
    private final DepthSortedSet relayoutNodes;
    private boolean duringMeasureLayout;
    @NotNull
    private final OnPositionedDispatcher onPositionedDispatcher;
    private long measureIteration;
    @NotNull
    private final List<LayoutNode> postponedMeasureRequests;
    @Nullable
    private Constraints rootConstraints;
    @Nullable
    private final LayoutTreeConsistencyChecker consistencyChecker;

    public MeasureAndLayoutDelegate(@NotNull LayoutNode root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        this.root = root2;
        this.relayoutNodes = new DepthSortedSet(Owner.Companion.getEnableExtraAssertions());
        this.onPositionedDispatcher = new OnPositionedDispatcher();
        this.measureIteration = 1L;
        this.postponedMeasureRequests = new ArrayList();
        this.consistencyChecker = Owner.Companion.getEnableExtraAssertions() ? new LayoutTreeConsistencyChecker(this.root, this.relayoutNodes, this.postponedMeasureRequests) : (LayoutTreeConsistencyChecker)null;
    }

    public final boolean getHasPendingMeasureOrLayout() {
        DepthSortedSet this_$iv = this.relayoutNodes;
        boolean $i$f$isNotEmpty = false;
        return !this_$iv.isEmpty();
    }

    public final long getMeasureIteration() {
        if (!this.duringMeasureLayout) {
            boolean bl = false;
            String string = "measureIteration should be only used during the measure/layout pass";
            throw new IllegalArgumentException(string.toString());
        }
        return this.measureIteration;
    }

    public final void updateRootConstraints-BRTryo0(long constraints) {
        Constraints constraints2 = this.rootConstraints;
        if (!(constraints2 == null ? false : Constraints.equals-impl0((long)constraints2.unbox-impl(), (long)constraints))) {
            if (!(!this.duringMeasureLayout)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.rootConstraints = Constraints.box-impl((long)constraints);
            this.root.setLayoutState$ui(LayoutNode.LayoutState.NeedsRemeasure);
            this.relayoutNodes.add(this.root);
        }
    }

    public final boolean requestRemeasure(@NotNull LayoutNode layoutNode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        switch (WhenMappings.$EnumSwitchMapping$0[layoutNode.getLayoutState$ui().ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                this.postponedMeasureRequests.add(layoutNode);
                LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
                if (layoutTreeConsistencyChecker != null) {
                    layoutTreeConsistencyChecker.assertConsistent();
                }
                bl = false;
                break;
            }
            case 4: 
            case 5: {
                layoutNode.setLayoutState$ui(LayoutNode.LayoutState.NeedsRemeasure);
                if (layoutNode.isPlaced() || this.getCanAffectParent(layoutNode)) {
                    LayoutNode.LayoutState parentLayoutState;
                    LayoutNode layoutNode2 = layoutNode.getParent$ui();
                    LayoutNode.LayoutState layoutState = parentLayoutState = layoutNode2 == null ? null : layoutNode2.getLayoutState$ui();
                    if (parentLayoutState != LayoutNode.LayoutState.NeedsRemeasure) {
                        this.relayoutNodes.add(layoutNode);
                    }
                }
                if (!this.duringMeasureLayout) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean requestRelayout(@NotNull LayoutNode layoutNode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        switch (WhenMappings.$EnumSwitchMapping$0[layoutNode.getLayoutState$ui().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
                if (layoutTreeConsistencyChecker != null) {
                    layoutTreeConsistencyChecker.assertConsistent();
                }
                bl = false;
                break;
            }
            case 5: {
                layoutNode.setLayoutState$ui(LayoutNode.LayoutState.NeedsRelayout);
                if (layoutNode.isPlaced()) {
                    LayoutNode.LayoutState parentLayoutState;
                    LayoutNode layoutNode2 = layoutNode.getParent$ui();
                    LayoutNode.LayoutState layoutState = parentLayoutState = layoutNode2 == null ? null : layoutNode2.getLayoutState$ui();
                    if (parentLayoutState != LayoutNode.LayoutState.NeedsRemeasure && parentLayoutState != LayoutNode.LayoutState.NeedsRelayout) {
                        this.relayoutNodes.add(layoutNode);
                    }
                }
                if (!this.duringMeasureLayout) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean doRemeasure(LayoutNode layoutNode) {
        boolean bl;
        if (layoutNode == this.root) {
            Constraints constraints = this.rootConstraints;
            Intrinsics.checkNotNull((Object)constraints);
            bl = layoutNode.remeasure-_Sx5XlM$ui(constraints);
        } else {
            bl = LayoutNode.remeasure-_Sx5XlM$ui$default(layoutNode, null, 1, null);
        }
        boolean sizeChanged = bl;
        LayoutNode parent2 = layoutNode.getParent$ui();
        if (sizeChanged && parent2 != null) {
            if (layoutNode.getMeasuredByParent$ui() == LayoutNode.UsageByParent.InMeasureBlock) {
                this.requestRemeasure(parent2);
            } else {
                if (!(layoutNode.getMeasuredByParent$ui() == LayoutNode.UsageByParent.InLayoutBlock)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.requestRelayout(parent2);
            }
        }
        return sizeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean measureAndLayout(@Nullable Function0<Unit> onLayout) {
        if (!this.root.isAttached()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.root.isPlaced()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this.duringMeasureLayout)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.rootConstraints == null) {
            return false;
        }
        boolean rootNodeResized = false;
        DepthSortedSet this_$iv = this.relayoutNodes;
        boolean $i$f$isNotEmpty = false;
        if (!this_$iv.isEmpty()) {
            this.duringMeasureLayout = true;
            try {
                this_$iv = this.relayoutNodes;
                boolean $i$f$popEach = false;
                while (true) {
                    DepthSortedSet this_$iv$iv = this_$iv;
                    boolean $i$f$isNotEmpty2 = false;
                    if (!this_$iv$iv.isEmpty()) {
                        LayoutNode node$iv;
                        LayoutNode layoutNode = node$iv = this_$iv.pop();
                        boolean bl = false;
                        boolean sizeChanged = this.remeasureAndRelayoutIfNeeded(layoutNode);
                        if (layoutNode != this.root || !sizeChanged) continue;
                        rootNodeResized = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.duringMeasureLayout = false;
            }
            LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
            if (layoutTreeConsistencyChecker != null) {
                layoutTreeConsistencyChecker.assertConsistent();
            }
            Function0<Unit> function0 = onLayout;
            if (function0 != null) {
                function0.invoke();
            }
        }
        return rootNodeResized;
    }

    public static /* synthetic */ boolean measureAndLayout$default(MeasureAndLayoutDelegate measureAndLayoutDelegate, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        return measureAndLayoutDelegate.measureAndLayout((Function0<Unit>)function0);
    }

    private final boolean remeasureAndRelayoutIfNeeded(LayoutNode layoutNode) {
        boolean sizeChanged = false;
        if (layoutNode.isPlaced() || this.getCanAffectParent(layoutNode) || layoutNode.getAlignmentLines$ui().getRequired$ui()) {
            if (layoutNode.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRemeasure) {
                sizeChanged = this.doRemeasure(layoutNode);
            }
            if (layoutNode.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRelayout && layoutNode.isPlaced()) {
                if (layoutNode == this.root) {
                    layoutNode.place$ui(0, 0);
                } else {
                    layoutNode.replace$ui();
                }
                this.onPositionedDispatcher.onNodePositioned(layoutNode);
                LayoutTreeConsistencyChecker layoutTreeConsistencyChecker = this.consistencyChecker;
                if (layoutTreeConsistencyChecker != null) {
                    layoutTreeConsistencyChecker.assertConsistent();
                }
            }
            if (!((Collection)this.postponedMeasureRequests).isEmpty()) {
                List<LayoutNode> $this$fastForEach$iv = this.postponedMeasureRequests;
                boolean $i$f$fastForEach = false;
                int n = 0;
                int n2 = $this$fastForEach$iv.size();
                while (n < n2) {
                    LayoutNode item$iv;
                    int index$iv = n++;
                    LayoutNode it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    if (!it.isAttached()) continue;
                    this.requestRemeasure(it);
                }
                this.postponedMeasureRequests.clear();
            }
        }
        return sizeChanged;
    }

    public final void forceMeasureTheSubtree(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (this.relayoutNodes.isEmpty()) {
            return;
        }
        if (!this.duringMeasureLayout) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(layoutNode.getLayoutState$ui() != LayoutNode.LayoutState.NeedsRemeasure)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        MutableVector<LayoutNode> this_$iv = layoutNode.get_children$ui();
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                LayoutNode child = (LayoutNode)content$iv[i$iv];
                boolean bl = false;
                if (child.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRemeasure && this.relayoutNodes.remove(child)) {
                    this.remeasureAndRelayoutIfNeeded(child);
                }
                if (child.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRemeasure) continue;
                this.forceMeasureTheSubtree(child);
            } while (++i$iv < size$iv);
        }
        if (layoutNode.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRemeasure && this.relayoutNodes.remove(layoutNode)) {
            this.remeasureAndRelayoutIfNeeded(layoutNode);
        }
    }

    public final void dispatchOnPositionedCallbacks(boolean forceDispatch) {
        if (forceDispatch) {
            this.onPositionedDispatcher.onRootNodePositioned(this.root);
        }
        this.onPositionedDispatcher.dispatch();
    }

    public static /* synthetic */ void dispatchOnPositionedCallbacks$default(MeasureAndLayoutDelegate measureAndLayoutDelegate, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        measureAndLayoutDelegate.dispatchOnPositionedCallbacks(bl);
    }

    public final void onNodeDetached(@NotNull LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.relayoutNodes.remove(node);
    }

    private final boolean getCanAffectParent(LayoutNode $this$canAffectParent) {
        return $this$canAffectParent.getLayoutState$ui() == LayoutNode.LayoutState.NeedsRemeasure && ($this$canAffectParent.getMeasuredByParent$ui() == LayoutNode.UsageByParent.InMeasureBlock || $this$canAffectParent.getAlignmentLines$ui().getRequired$ui());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayoutNode.LayoutState.values().length];
            nArray[LayoutNode.LayoutState.Measuring.ordinal()] = 1;
            nArray[LayoutNode.LayoutState.NeedsRemeasure.ordinal()] = 2;
            nArray[LayoutNode.LayoutState.LayingOut.ordinal()] = 3;
            nArray[LayoutNode.LayoutState.NeedsRelayout.ordinal()] = 4;
            nArray[LayoutNode.LayoutState.Ready.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

