/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusManager;
import androidx.compose.ui.focus.FocusModifier;
import androidx.compose.ui.focus.FocusNodeUtilsKt;
import androidx.compose.ui.focus.FocusOrder;
import androidx.compose.ui.focus.FocusState;
import androidx.compose.ui.focus.FocusStateImpl;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.DelegatingLayoutNodeWrapper;
import androidx.compose.ui.node.LayoutNodeWrapper;
import androidx.compose.ui.node.Owner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020'R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u000e\u001a\u0004\u0018\u00010\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Landroidx/compose/ui/node/ModifiedFocusNode;", "Landroidx/compose/ui/node/DelegatingLayoutNodeWrapper;", "Landroidx/compose/ui/focus/FocusModifier;", "wrapped", "Landroidx/compose/ui/node/LayoutNodeWrapper;", "modifier", "(Landroidx/compose/ui/node/LayoutNodeWrapper;Landroidx/compose/ui/focus/FocusModifier;)V", "value", "Landroidx/compose/ui/focus/FocusStateImpl;", "focusState", "getFocusState", "()Landroidx/compose/ui/focus/FocusStateImpl;", "setFocusState", "(Landroidx/compose/ui/focus/FocusStateImpl;)V", "focusedChild", "getFocusedChild", "()Landroidx/compose/ui/node/ModifiedFocusNode;", "setFocusedChild", "(Landroidx/compose/ui/node/ModifiedFocusNode;)V", "getModifier", "()Landroidx/compose/ui/focus/FocusModifier;", "setModifier", "(Landroidx/compose/ui/focus/FocusModifier;)V", "attach", "", "clearFocusIfFocused", "detach", "findNextFocusWrapper", "excludeDeactivated", "", "findPreviousFocusWrapper", "focusRect", "Landroidx/compose/ui/geometry/Rect;", "onInitialize", "onModifierChanged", "populateFocusOrder", "focusOrder", "Landroidx/compose/ui/focus/FocusOrder;", "propagateFocusEvent", "Landroidx/compose/ui/focus/FocusState;", "sendOnFocusEvent", "ui"})
public final class ModifiedFocusNode
extends DelegatingLayoutNodeWrapper<FocusModifier> {
    public ModifiedFocusNode(@NotNull LayoutNodeWrapper wrapped, @NotNull FocusModifier modifier2) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)modifier2, (String)"modifier");
        super(wrapped, (Modifier.Element)modifier2);
    }

    @Override
    @NotNull
    public FocusModifier getModifier() {
        return (FocusModifier)super.getModifier();
    }

    @Override
    public void setModifier(@NotNull FocusModifier value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.clearFocusIfFocused();
        super.setModifier((Modifier.Element)value2);
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        this.getModifier().setFocusNode(this);
    }

    @NotNull
    public final FocusStateImpl getFocusState() {
        return this.getModifier().getFocusState();
    }

    public final void setFocusState(@NotNull FocusStateImpl value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.getModifier().setFocusState(value2);
        this.sendOnFocusEvent(value2);
    }

    @Nullable
    public final ModifiedFocusNode getFocusedChild() {
        return this.getModifier().getFocusedChild();
    }

    public final void setFocusedChild(@Nullable ModifiedFocusNode value2) {
        this.getModifier().setFocusedChild(value2);
    }

    @NotNull
    public final Rect focusRect() {
        return LayoutCoordinatesKt.findRoot(this).localBoundingBoxOf(this, false);
    }

    public final void sendOnFocusEvent(@NotNull FocusState focusState) {
        Intrinsics.checkNotNullParameter((Object)focusState, (String)"focusState");
        if (this.isAttached() && this.getModifier().getHasFocusListeners()) {
            LayoutNodeWrapper layoutNodeWrapper = this.getWrappedBy$ui();
            if (layoutNodeWrapper != null) {
                layoutNodeWrapper.propagateFocusEvent(focusState);
            }
        }
    }

    @Override
    public void onModifierChanged() {
        super.onModifierChanged();
        this.sendOnFocusEvent(this.getFocusState());
    }

    @Override
    public void attach() {
        super.attach();
        this.sendOnFocusEvent(this.getFocusState());
    }

    @Override
    public void detach() {
        this.clearFocusIfFocused();
        super.detach();
    }

    private final void clearFocusIfFocused() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getFocusState().ordinal()]) {
            case 1: 
            case 2: {
                Owner owner = this.getLayoutNode$ui().getOwner$ui();
                if (owner == null) break;
                FocusManager focusManager = owner.getFocusManager();
                if (focusManager == null) break;
                focusManager.clearFocus(true);
                break;
            }
            case 3: 
            case 4: {
                FocusStateImpl focusStateImpl;
                ModifiedFocusNode modifiedFocusNode = this.getWrapped$ui().findNextFocusWrapper(false);
                ModifiedFocusNode nextFocusNode = modifiedFocusNode == null ? FocusNodeUtilsKt.searchChildrenForFocusNode$default(this.getLayoutNode$ui(), null, false, 1, null) : modifiedFocusNode;
                ModifiedFocusNode parentFocusNode = this.findParentFocusNode$ui();
                if (parentFocusNode == null) break;
                parentFocusNode.getModifier().setFocusedChild(nextFocusNode);
                if (nextFocusNode != null) {
                    this.sendOnFocusEvent(nextFocusNode.getFocusState());
                    break;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[parentFocusNode.getFocusState().ordinal()]) {
                    case 3: {
                        focusStateImpl = FocusStateImpl.Inactive;
                        break;
                    }
                    case 4: {
                        focusStateImpl = FocusStateImpl.Deactivated;
                        break;
                    }
                    default: {
                        focusStateImpl = parentFocusNode.getFocusState();
                    }
                }
                parentFocusNode.setFocusState(focusStateImpl);
                break;
            }
            case 5: {
                ModifiedFocusNode nextFocusNode;
                ModifiedFocusNode modifiedFocusNode = this.getWrapped$ui().findNextFocusWrapper(false);
                ModifiedFocusNode modifiedFocusNode2 = nextFocusNode = modifiedFocusNode == null ? FocusNodeUtilsKt.searchChildrenForFocusNode$default(this.getLayoutNode$ui(), null, false, 1, null) : modifiedFocusNode;
                FocusStateImpl focusStateImpl = modifiedFocusNode2 == null ? null : modifiedFocusNode2.getFocusState();
                if (focusStateImpl == null) {
                    focusStateImpl = FocusStateImpl.Inactive;
                }
                this.sendOnFocusEvent(focusStateImpl);
            }
        }
    }

    @Override
    @NotNull
    public ModifiedFocusNode findPreviousFocusWrapper() {
        return this;
    }

    @Override
    @Nullable
    public ModifiedFocusNode findNextFocusWrapper(boolean excludeDeactivated) {
        return this.getModifier().getFocusState().isDeactivated() && excludeDeactivated ? super.findNextFocusWrapper(excludeDeactivated) : this;
    }

    @Override
    public void propagateFocusEvent(@NotNull FocusState focusState) {
        Intrinsics.checkNotNullParameter((Object)focusState, (String)"focusState");
    }

    @Override
    public void populateFocusOrder(@NotNull FocusOrder focusOrder) {
        Intrinsics.checkNotNullParameter((Object)focusOrder, (String)"focusOrder");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FocusStateImpl.values().length];
            nArray[FocusStateImpl.Active.ordinal()] = 1;
            nArray[FocusStateImpl.Captured.ordinal()] = 2;
            nArray[FocusStateImpl.ActiveParent.ordinal()] = 3;
            nArray[FocusStateImpl.DeactivatedParent.ordinal()] = 4;
            nArray[FocusStateImpl.Deactivated.ordinal()] = 5;
            nArray[FocusStateImpl.Inactive.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

