/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.platform.ClipboardManager;
import androidx.compose.ui.text.AnnotatedString;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Landroidx/compose/ui/platform/PlatformClipboardManager;", "Landroidx/compose/ui/platform/ClipboardManager;", "()V", "systemClipboard", "Ljava/awt/datatransfer/Clipboard;", "getSystemClipboard$ui", "()Ljava/awt/datatransfer/Clipboard;", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "setText", "", "annotatedString", "ui"})
public final class PlatformClipboardManager
implements ClipboardManager {
    @Nullable
    private final Clipboard systemClipboard;

    public PlatformClipboardManager() {
        Clipboard clipboard;
        PlatformClipboardManager platformClipboardManager;
        PlatformClipboardManager platformClipboardManager2 = this;
        try {
            platformClipboardManager = platformClipboardManager2;
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException e) {
            platformClipboardManager = platformClipboardManager2;
            clipboard = null;
        }
        platformClipboardManager.systemClipboard = clipboard;
    }

    @Nullable
    public final Clipboard getSystemClipboard$ui() {
        return this.systemClipboard;
    }

    @Override
    @Nullable
    public AnnotatedString getText() {
        AnnotatedString annotatedString;
        Clipboard clipboard = this.systemClipboard;
        if (clipboard == null) {
            annotatedString = null;
        } else {
            AnnotatedString annotatedString2;
            Clipboard it = clipboard;
            boolean bl = false;
            try {
                Object object = it.getData(DataFlavor.stringFlavor);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                annotatedString2 = new AnnotatedString((String)object, null, null, 6, null);
            }
            catch (UnsupportedFlavorException _) {
                annotatedString2 = null;
            }
            annotatedString = annotatedString2;
        }
        return annotatedString;
    }

    @Override
    public void setText(@NotNull AnnotatedString annotatedString) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"annotatedString");
        Clipboard clipboard = this.systemClipboard;
        if (clipboard != null) {
            clipboard.setContents(new StringSelection(annotatedString.getText()), null);
        }
    }
}

