/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeWrapper;
import androidx.compose.ui.semantics.SemanticsSortKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u0010\u0011B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Landroidx/compose/ui/semantics/NodeLocationHolder;", "", "subtreeRoot", "Landroidx/compose/ui/node/LayoutNode;", "node", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/LayoutNode;)V", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "location", "Landroidx/compose/ui/geometry/Rect;", "getNode$ui", "()Landroidx/compose/ui/node/LayoutNode;", "getSubtreeRoot$ui", "compareTo", "", "other", "Companion", "ComparisonStrategy", "ui"})
public final class NodeLocationHolder
implements Comparable<NodeLocationHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LayoutNode subtreeRoot;
    @NotNull
    private final LayoutNode node;
    @Nullable
    private final Rect location;
    @NotNull
    private final LayoutDirection layoutDirection;
    @NotNull
    private static ComparisonStrategy comparisonStrategy = ComparisonStrategy.Stripe;

    public NodeLocationHolder(@NotNull LayoutNode subtreeRoot, @NotNull LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)subtreeRoot, (String)"subtreeRoot");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.subtreeRoot = subtreeRoot;
        this.node = node;
        this.layoutDirection = this.subtreeRoot.getLayoutDirection();
        LayoutNodeWrapper subtreeRootWrapper = this.subtreeRoot.getInnerLayoutNodeWrapper$ui();
        LayoutNodeWrapper nodeWrapper = SemanticsSortKt.findWrapperToGetBounds(this.node);
        this.location = subtreeRootWrapper.isAttached() && nodeWrapper.isAttached() ? LayoutCoordinates.DefaultImpls.localBoundingBoxOf$default(subtreeRootWrapper, nodeWrapper, false, 2, null) : (Rect)null;
    }

    @NotNull
    public final LayoutNode getSubtreeRoot$ui() {
        return this.subtreeRoot;
    }

    @NotNull
    public final LayoutNode getNode$ui() {
        return this.node;
    }

    @Override
    public int compareTo(@NotNull NodeLocationHolder other) {
        float topDifference;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.location == null) {
            return 1;
        }
        if (other.location == null) {
            return -1;
        }
        if (comparisonStrategy == ComparisonStrategy.Stripe) {
            if (this.location.getBottom() - other.location.getTop() <= 0.0f) {
                return -1;
            }
            if (this.location.getTop() - other.location.getBottom() >= 0.0f) {
                return 1;
            }
        }
        if (this.layoutDirection == LayoutDirection.Ltr) {
            float leftDifference = this.location.getLeft() - other.location.getLeft();
            if (!(leftDifference == 0.0f)) {
                return leftDifference < 0.0f ? -1 : 1;
            }
        } else {
            float rightDifference = this.location.getRight() - other.location.getRight();
            if (!(rightDifference == 0.0f)) {
                return rightDifference < 0.0f ? 1 : -1;
            }
        }
        if (!((topDifference = this.location.getTop() - other.location.getTop()) == 0.0f)) {
            return topDifference < 0.0f ? -1 : 1;
        }
        float heightDifference = this.location.getHeight() - other.location.getHeight();
        if (!(heightDifference == 0.0f)) {
            return heightDifference < 0.0f ? 1 : -1;
        }
        float widthDifference = this.location.getWidth() - other.location.getWidth();
        if (!(widthDifference == 0.0f)) {
            return widthDifference < 0.0f ? 1 : -1;
        }
        Rect view1Bounds = LayoutCoordinatesKt.boundsInRoot(SemanticsSortKt.findWrapperToGetBounds(this.node));
        Rect view2Bounds = LayoutCoordinatesKt.boundsInRoot(SemanticsSortKt.findWrapperToGetBounds(other.node));
        LayoutNode child12 = SemanticsSortKt.findNodeByPredicateTraversal(this.node, (Function1<? super LayoutNode, Boolean>)((Function1)new Function1<LayoutNode, Boolean>(view1Bounds){
            final /* synthetic */ Rect $view1Bounds;
            {
                this.$view1Bounds = $view1Bounds;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LayoutNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LayoutNodeWrapper wrapper = SemanticsSortKt.findWrapperToGetBounds(it);
                return wrapper.isAttached() && !Intrinsics.areEqual((Object)this.$view1Bounds, (Object)LayoutCoordinatesKt.boundsInRoot(wrapper));
            }
        }));
        LayoutNode child22 = SemanticsSortKt.findNodeByPredicateTraversal(other.node, (Function1<? super LayoutNode, Boolean>)((Function1)new Function1<LayoutNode, Boolean>(view2Bounds){
            final /* synthetic */ Rect $view2Bounds;
            {
                this.$view2Bounds = $view2Bounds;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LayoutNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LayoutNodeWrapper wrapper = SemanticsSortKt.findWrapperToGetBounds(it);
                return wrapper.isAttached() && !Intrinsics.areEqual((Object)this.$view2Bounds, (Object)LayoutCoordinatesKt.boundsInRoot(wrapper));
            }
        }));
        if (child12 != null && child22 != null) {
            NodeLocationHolder childHolder1 = new NodeLocationHolder(this.subtreeRoot, child12);
            NodeLocationHolder childHolder2 = new NodeLocationHolder(other.subtreeRoot, child22);
            return childHolder1.compareTo(childHolder2);
        }
        if (child12 != null) {
            return 1;
        }
        if (child22 != null) {
            return -1;
        }
        return -1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/semantics/NodeLocationHolder$Companion;", "", "()V", "comparisonStrategy", "Landroidx/compose/ui/semantics/NodeLocationHolder$ComparisonStrategy;", "getComparisonStrategy$ui", "()Landroidx/compose/ui/semantics/NodeLocationHolder$ComparisonStrategy;", "setComparisonStrategy$ui", "(Landroidx/compose/ui/semantics/NodeLocationHolder$ComparisonStrategy;)V", "ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComparisonStrategy getComparisonStrategy$ui() {
            return comparisonStrategy;
        }

        public final void setComparisonStrategy$ui(@NotNull ComparisonStrategy comparisonStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)comparisonStrategy), (String)"<set-?>");
            NodeLocationHolder.comparisonStrategy = comparisonStrategy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/semantics/NodeLocationHolder$ComparisonStrategy;", "", "(Ljava/lang/String;I)V", "Stripe", "Location", "ui"})
    public static final class ComparisonStrategy
    extends Enum<ComparisonStrategy> {
        public static final /* enum */ ComparisonStrategy Stripe = new ComparisonStrategy();
        public static final /* enum */ ComparisonStrategy Location = new ComparisonStrategy();
        private static final /* synthetic */ ComparisonStrategy[] $VALUES;

        public static ComparisonStrategy[] values() {
            return (ComparisonStrategy[])$VALUES.clone();
        }

        public static ComparisonStrategy valueOf(String value2) {
            return Enum.valueOf(ComparisonStrategy.class, value2);
        }

        static {
            $VALUES = comparisonStrategyArray = new ComparisonStrategy[]{ComparisonStrategy.Stripe, ComparisonStrategy.Location};
        }
    }
}

