/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeWrapper;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsWrapper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\f\u001a\u00020\r*\u00020\tH\u0002\u001a\"\u0010\u000e\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013*\u00020\u00022\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a&\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0010H\u0080\b\u00f8\u0001\u0001\u001a\f\u0010\u0019\u001a\u00020\r*\u00020\tH\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"outerMergingSemantics", "Landroidx/compose/ui/semantics/SemanticsWrapper;", "Landroidx/compose/ui/node/LayoutNode;", "getOuterMergingSemantics", "(Landroidx/compose/ui/node/LayoutNode;)Landroidx/compose/ui/semantics/SemanticsWrapper;", "outerSemantics", "getOuterSemantics", "role", "Landroidx/compose/ui/semantics/Role;", "Landroidx/compose/ui/semantics/SemanticsNode;", "getRole", "(Landroidx/compose/ui/semantics/SemanticsNode;)Landroidx/compose/ui/semantics/Role;", "contentDescriptionFakeNodeId", "", "findClosestParentNode", "selector", "Lkotlin/Function1;", "", "findOneLayerOfSemanticsWrappers", "", "list", "", "nearestSemantics", "Landroidx/compose/ui/node/LayoutNodeWrapper;", "predicate", "roleFakeNodeId", "ui"})
public final class SemanticsNodeKt {
    @Nullable
    public static final SemanticsWrapper getOuterSemantics(@NotNull LayoutNode $this$outerSemantics) {
        SemanticsWrapper semanticsWrapper;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$outerSemantics, (String)"<this>");
            LayoutNodeWrapper $this$nearestSemantics$iv = $this$outerSemantics.getOuterLayoutNodeWrapper$ui();
            boolean $i$f$nearestSemantics = false;
            for (LayoutNodeWrapper wrapper$iv = $this$nearestSemantics$iv; wrapper$iv != null; wrapper$iv = wrapper$iv.getWrapped$ui()) {
                if (!(wrapper$iv instanceof SemanticsWrapper)) continue;
                SemanticsWrapper it = (SemanticsWrapper)wrapper$iv;
                boolean bl = false;
                if (!true) continue;
                semanticsWrapper = (SemanticsWrapper)wrapper$iv;
                break block1;
            }
            semanticsWrapper = null;
        }
        return semanticsWrapper;
    }

    @Nullable
    public static final SemanticsWrapper getOuterMergingSemantics(@NotNull LayoutNode $this$outerMergingSemantics) {
        SemanticsWrapper semanticsWrapper;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$outerMergingSemantics, (String)"<this>");
            LayoutNodeWrapper $this$nearestSemantics$iv = $this$outerMergingSemantics.getOuterLayoutNodeWrapper$ui();
            boolean $i$f$nearestSemantics = false;
            for (LayoutNodeWrapper wrapper$iv = $this$nearestSemantics$iv; wrapper$iv != null; wrapper$iv = wrapper$iv.getWrapped$ui()) {
                if (!(wrapper$iv instanceof SemanticsWrapper)) continue;
                SemanticsWrapper it = (SemanticsWrapper)wrapper$iv;
                boolean bl = false;
                if (!((SemanticsModifier)it.getModifier()).getSemanticsConfiguration().isMergingSemanticsOfDescendants()) continue;
                semanticsWrapper = (SemanticsWrapper)wrapper$iv;
                break block1;
            }
            semanticsWrapper = null;
        }
        return semanticsWrapper;
    }

    @Nullable
    public static final SemanticsWrapper nearestSemantics(@NotNull LayoutNodeWrapper $this$nearestSemantics, @NotNull Function1<? super SemanticsWrapper, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$nearestSemantics, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$nearestSemantics = false;
        for (LayoutNodeWrapper wrapper = $this$nearestSemantics; wrapper != null; wrapper = wrapper.getWrapped$ui()) {
            if (!(wrapper instanceof SemanticsWrapper) || !((Boolean)predicate.invoke((Object)wrapper)).booleanValue()) continue;
            return (SemanticsWrapper)wrapper;
        }
        return null;
    }

    private static final List<SemanticsWrapper> findOneLayerOfSemanticsWrappers(LayoutNode $this$findOneLayerOfSemanticsWrappers, List<SemanticsWrapper> list) {
        MutableVector<LayoutNode> this_$iv = $this$findOneLayerOfSemanticsWrappers.getZSortedChildren();
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                LayoutNode child = (LayoutNode)content$iv[i$iv];
                boolean bl = false;
                SemanticsWrapper outerSemantics = SemanticsNodeKt.getOuterSemantics(child);
                if (outerSemantics != null) {
                    list.add(outerSemantics);
                    continue;
                }
                SemanticsNodeKt.findOneLayerOfSemanticsWrappers(child, list);
            } while (++i$iv < size$iv);
        }
        return list;
    }

    static /* synthetic */ List findOneLayerOfSemanticsWrappers$default(LayoutNode layoutNode, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        return SemanticsNodeKt.findOneLayerOfSemanticsWrappers(layoutNode, list);
    }

    private static final LayoutNode findClosestParentNode(LayoutNode $this$findClosestParentNode, Function1<? super LayoutNode, Boolean> selector) {
        for (LayoutNode currentParent = $this$findClosestParentNode.getParent$ui(); currentParent != null; currentParent = currentParent.getParent$ui()) {
            if (!((Boolean)selector.invoke((Object)currentParent)).booleanValue()) continue;
            return currentParent;
        }
        return null;
    }

    private static final Role getRole(SemanticsNode $this$role) {
        return SemanticsConfigurationKt.getOrNull($this$role.getUnmergedConfig$ui(), SemanticsProperties.INSTANCE.getRole());
    }

    private static final int contentDescriptionFakeNodeId(SemanticsNode $this$contentDescriptionFakeNodeId) {
        return $this$contentDescriptionFakeNodeId.getId() + 2000000000;
    }

    private static final int roleFakeNodeId(SemanticsNode $this$roleFakeNodeId) {
        return $this$roleFakeNodeId.getId() + 1000000000;
    }

    public static final /* synthetic */ LayoutNode access$findClosestParentNode(LayoutNode $receiver, Function1 selector) {
        return SemanticsNodeKt.findClosestParentNode($receiver, (Function1<? super LayoutNode, Boolean>)selector);
    }

    public static final /* synthetic */ Role access$getRole(SemanticsNode $receiver) {
        return SemanticsNodeKt.getRole($receiver);
    }

    public static final /* synthetic */ int access$roleFakeNodeId(SemanticsNode $receiver) {
        return SemanticsNodeKt.roleFakeNodeId($receiver);
    }

    public static final /* synthetic */ int access$contentDescriptionFakeNodeId(SemanticsNode $receiver) {
        return SemanticsNodeKt.contentDescriptionFakeNodeId($receiver);
    }
}

